/*
 * Decompiled with CFR 0.152.
 */
package de.mn77.base.sys.file;

import de.mn77.base.error.Err;
import de.mn77.base.error.Err_FileSys;
import de.mn77.base.sys.MOut;
import de.mn77.base.sys.Sys;
import de.mn77.base.sys.file.I_FileSys_Item;
import de.mn77.base.sys.file.MDir;
import de.mn77.base.sys.file.MFile;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;

public class Lib_FileSys {
    public static I_FileSys_Item convertFrom(File file) {
        try {
            return file.isDirectory() ? new MDir(file) : new MFile(file);
        }
        catch (Err_FileSys e) {
            throw Err.impossible(new Object[0]);
        }
    }

    public static void copyFile(File from, File to) throws Err_FileSys {
        if (from.isDirectory()) {
            Err.forbidden("Can't copy a directory", from, to);
        }
        Err.fsIfMissing(from);
        Err.fsIfExist(to);
        Lib_FileSys.iCopyFile(from, to);
    }

    public static void createPathStructure(String path) throws Err_FileSys {
        String dirSep = Sys.getSeperatorDir();
        String[] elements = path.split(dirSep);
        MOut.dev(elements, dirSep);
        String current = Sys.isWindows() ? "" : dirSep;
        boolean first = true;
        String[] stringArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            if (element.length() != 0) {
                if (first) {
                    first = false;
                } else {
                    current = String.valueOf(current) + dirSep;
                }
                current = String.valueOf(current) + element;
                File f = new File(current);
                if (!f.exists() && !f.mkdir()) {
                    throw Err.newFileSys("Couldn't create Directory!", current);
                }
            }
            ++n2;
        }
    }

    public static MFile createTempFile(String filename, String suffix) throws IOException {
        if (suffix.charAt(0) != '.') {
            suffix = "." + suffix;
        }
        File tempFile = File.createTempFile(String.valueOf(filename) + "_", suffix);
        tempFile.deleteOnExit();
        return new MFile(tempFile);
    }

    public static Process defaultOpen(File f) throws Err_FileSys {
        try {
            if (Sys.isWindows()) {
                return new ProcessBuilder("rundll32", "url.dll,FileProtocolHandler", f.getAbsolutePath()).start();
            }
            if (Sys.isMac()) {
                return new ProcessBuilder("open", f.getAbsolutePath()).start();
            }
            if (Sys.isLinux()) {
                return new ProcessBuilder("xdg-open", f.getAbsolutePath()).start();
            }
            throw Err.todo("Unknown Operating-System", Sys.getOsName(), Sys.getOsVersion());
        }
        catch (IOException e) {
            throw Err.newFileSys("Starting failed", e, f.getAbsolutePath());
        }
    }

    public static String getSuffix(File file) {
        String name = file.getName();
        String suffix = name.replaceFirst("^.*\\.(.*)$", "$1");
        if (suffix.length() > 10 || name.equals(suffix)) {
            return "";
        }
        return suffix;
    }

    public static void move(File from, File to) throws Err_FileSys {
        boolean result = from.renameTo(to);
        if (!result) {
            throw Err.newFileSys("Moving file failed", from, to);
        }
    }

    public static boolean rename(File from, File to) throws Err_FileSys {
        Err.fsIfMissing(from);
        Err.fsIfExist(to);
        return from.renameTo(to);
    }

    public static DirectoryStream<Path> searchFiles(File base, String pattern) throws IOException {
        String path = base.getAbsolutePath();
        return Files.newDirectoryStream(Paths.get(path, new String[0]), pattern);
    }

    private static void iCopyFile(File from, File to) throws Err_FileSys {
        byte[] buffer = new byte[8192];
        int read = 0;
        RandomAccessFile raf_source = null;
        RandomAccessFile raf_target = null;
        try {
            try {
                raf_source = new RandomAccessFile(from, "r");
                raf_target = new RandomAccessFile(to, "rw");
                raf_target.setLength(raf_source.length());
                while ((read = raf_source.read(buffer)) > 0) {
                    raf_target.write(buffer, 0, read);
                }
            }
            catch (IOException e) {
                throw Err.wrap(e, "Copy-Error!");
            }
        }
        finally {
            block28: {
                try {
                    try {
                        raf_source.close();
                    }
                    catch (IOException e) {
                        MOut.error(e, "Couldn't close source-file!");
                        try {
                            raf_target.close();
                        }
                        catch (IOException e2) {
                            MOut.error(e2, "Couln't close target-file!");
                        }
                        break block28;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        raf_target.close();
                    }
                    catch (IOException e) {
                        MOut.error(e, "Couln't close target-file!");
                    }
                    throw throwable;
                }
                try {
                    raf_target.close();
                }
                catch (IOException e) {
                    MOut.error(e, "Couln't close target-file!");
                }
            }
        }
    }
}

