/*
 * Decompiled with CFR 0.152.
 */
package de.mn77.base.data.struct.atomic;

import de.mn77.base.error.Err;
import de.mn77.base.error.Err_Runtime;
import java.util.Iterator;
import java.util.RandomAccess;

public class ByteList
implements RandomAccess,
Iterable<Byte> {
    private byte[] data;
    private int size = 0;

    public ByteList() {
        this.data = new byte[10];
        this.size = 0;
    }

    public ByteList(byte[] ba) {
        Err.ifNull((Object)ba);
        this.data = ba;
        this.size = ba.length;
    }

    public ByteList(int initSize) {
        this.data = new byte[initSize];
        this.size = 0;
    }

    public void add(byte value) {
        this.iCheckGrow(1);
        this.data[this.size] = value;
        ++this.size;
    }

    public byte get(int idx) {
        this.iCheckBounds(idx);
        return this.data[idx];
    }

    @Override
    public Iterator<Byte> iterator() {
        return new Iterator<Byte>(){
            private int next = 0;

            @Override
            public boolean hasNext() {
                return this.next < ByteList.this.size;
            }

            @Override
            public Byte next() {
                return ByteList.this.data[this.next++];
            }

            @Override
            public void remove() {
                Err.todo(new Object[0]);
            }
        };
    }

    public void set(int idx, byte value) {
        this.iCheckBounds(idx);
        this.data[idx] = value;
    }

    public int size() {
        return this.size;
    }

    public byte[] toArray() {
        byte[] copy = new byte[this.size];
        System.arraycopy(this.data, 0, copy, 0, this.size);
        return copy;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        int i = 0;
        while (i < this.size) {
            if (i != 0) {
                sb.append(',');
            }
            sb.append(this.data[i]);
            ++i;
        }
        sb.append(']');
        return sb.toString();
    }

    private void iCheckBounds(int pos) {
        Err.ifOutOfBounds(1, this.size, pos);
    }

    private void iCheckGrow(int toAdd) {
        if (this.size + toAdd <= this.data.length) {
            return;
        }
        if (this.size > 0x3FFFFFFF) {
            throw new Err_Runtime("Maximum of PIntList reached", new Object[0]);
        }
        int grow = this.size <= 20 ? 10 : this.size / 2;
        int newSize = this.size + toAdd + grow;
        byte[] copy = new byte[newSize];
        System.arraycopy(this.data, 0, copy, 0, this.size);
        this.data = copy;
    }
}

