/*
 * Decompiled with CFR 0.152.
 */
package de.mn77.base.data.search;

import de.mn77.base.data.struct.I_List;
import de.mn77.base.data.struct.SimpleList;
import de.mn77.base.data.struct.table.ArrayTable;
import de.mn77.base.data.struct.table.I_Table;
import de.mn77.base.data.struct.table.type.I_TypeTable;
import de.mn77.base.error.Err;

public class SearchTable {
    public static <T> I_Table<T> filter(I_Table<T> tab, int col, String regex, boolean case_sensitiv) {
        Err.ifNull(tab, regex);
        Err.ifOutOfBounds(0, tab.width() - 1, col);
        Err.ifTooSmall(0.0, tab.width() - 1);
        ArrayTable result = new ArrayTable(tab.width());
        if (!case_sensitiv) {
            regex = "(?i)" + regex;
        }
        for (Object[] objectArray : tab) {
            if (!("" + objectArray[col]).matches(regex)) continue;
            result.add(objectArray);
        }
        return result;
    }

    public static <TG> I_List<TG> filterColumn(I_TypeTable<TG> tab, int col, String regex, boolean case_sensitiv) {
        Err.ifNull(tab, regex);
        Err.ifOutOfBounds(0, tab.width() - 1, col);
        Err.ifTooSmall(1.0, tab.width());
        SimpleList result = new SimpleList();
        if (!case_sensitiv) {
            regex = "(?i)" + regex;
        }
        int z = 1;
        while (z <= tab.size()) {
            String o = "" + tab.get(col, z);
            if (o.matches(regex)) {
                result.add(tab.get(z));
            }
            ++z;
        }
        return result;
    }
}

