/*
 * Decompiled with CFR 0.152.
 */
package de.mn77.base.data.form;

import de.mn77.base.data.constant.ALIGN;
import de.mn77.base.data.constant.DATE;
import de.mn77.base.data.constant.LANGUAGE;
import de.mn77.base.data.form.FormNumber;
import de.mn77.base.data.form.FormString;
import de.mn77.base.data.type.datetime.I_Date;
import de.mn77.base.data.type.datetime.I_DateTime;
import de.mn77.base.data.type.datetime.I_Time;
import de.mn77.base.data.type.datetime.Lib_DateTime;
import de.mn77.base.data.type.datetime.format.FORM_DATE;
import de.mn77.base.data.type.datetime.format.FORM_DATETIME;
import de.mn77.base.data.type.datetime.format.FORM_TIME;
import de.mn77.base.error.Err;

public class FormDateTime {
    public static String compose(I_Date date, LANGUAGE lang, Object ... format) {
        Err.ifNull(format);
        Err.ifTooSmall(1.0, format.length);
        StringBuilder sb = new StringBuilder();
        Object[] objectArray = format;
        int n = format.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            if (o instanceof String) {
                sb.append(o);
            } else if (o == FORM_DATE.YEAR_4) {
                sb.append(FormNumber.width(4, date.getYear(), false));
            } else if (o == FORM_DATE.YEAR_2) {
                String tmp = "" + date.getYear();
                if (tmp.length() >= 2) {
                    sb.append(tmp.substring(tmp.length() - 2, tmp.length()));
                } else {
                    sb.append(FormString.width(2, '0', tmp, ALIGN.RIGHT, false));
                }
            } else if (o == FORM_DATE.YEAR) {
                sb.append("" + date.getYear());
            } else if (o == FORM_DATE.MONTH) {
                sb.append(date.getMonth());
            } else if (o == FORM_DATE.MONTH_2) {
                sb.append(FormNumber.width(2, date.getMonth(), false));
            } else if (o == FORM_DATE.MONTH_TEXT) {
                sb.append(DATE.NAME_MONTH_DE[date.getMonth() - 1]);
            } else if (o == FORM_DATE.MONTH_TEXT_3) {
                sb.append(DATE.NAME_MONTH_DE[date.getMonth() - 1].substring(0, 3));
            } else if (o == FORM_DATE.DAY) {
                sb.append(date.getDay());
            } else if (o == FORM_DATE.DAY_2) {
                sb.append(FormNumber.width(2, date.getDay(), false));
            } else if (o == FORM_DATE._DAYS_OF_MONTH) {
                sb.append(FormNumber.width(2, Lib_DateTime.daysOfMonth(date.getMonth(), date.getYear()), false));
            } else if (o == FORM_DATE.DAY_WEEK_TEXT_3) {
                sb.append(Lib_DateTime.nameDayOfWeek(date.getDayOfWeek(), lang).substring(0, 3));
            } else {
                Err.invalid(o);
            }
            ++n2;
        }
        return sb.toString();
    }

    public static String compose(I_Date date, Object ... format) {
        return FormDateTime.compose(date, LANGUAGE.getDefault(), format);
    }

    public static String compose(I_DateTime time, Object ... format) {
        Err.ifNull((Object)time);
        if (format == null || format.length == 0) {
            return FormDateTime.compose(time, new Object[0]);
        }
        StringBuilder sb = new StringBuilder();
        Object[] objectArray = format;
        int n = format.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            if (o instanceof String) {
                sb.append(o);
            } else if (o instanceof FORM_DATE) {
                sb.append(FormDateTime.compose(time.getDate(), LANGUAGE.EN, o));
            } else if (o instanceof FORM_TIME) {
                sb.append(FormDateTime.compose(time.getTime(), o));
            } else {
                Err.invalid(o);
            }
            ++n2;
        }
        return sb.toString();
    }

    public static String compose(I_Time time, Object ... format) {
        Err.ifNull((Object)time);
        StringBuilder sb = new StringBuilder();
        Object[] objectArray = format;
        int n = format.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            if (o instanceof String) {
                sb.append(o);
            } else {
                switch ((FORM_TIME)((Object)o)) {
                    case STD_2: {
                        sb.append(FormNumber.width(2, time.getHours(), false));
                        break;
                    }
                    case STD: {
                        sb.append(time.getHours());
                        break;
                    }
                    case MIN_2: {
                        sb.append(FormNumber.width(2, time.getMinutes(), false));
                        break;
                    }
                    case MIN: {
                        sb.append(time.getMinutes());
                        break;
                    }
                    case SEK_2: {
                        sb.append(FormNumber.width(2, time.getSeconds(), false));
                        break;
                    }
                    case SEK: {
                        sb.append(time.getSeconds());
                        break;
                    }
                    case MSEK: {
                        sb.append(time.getMilliSeconds());
                        break;
                    }
                    case MSEK_3: {
                        sb.append(FormNumber.width(3, time.getMilliSeconds(), false));
                    }
                }
            }
            ++n2;
        }
        return sb.toString();
    }

    public static String composeDE(I_Date date) {
        return FormDateTime.compose(date, LANGUAGE.DE, FORM_DATE.GROUP_DE);
    }

    public static String composeDE(I_DateTime datetime) {
        return FormDateTime.compose(datetime, FORM_DATETIME.GROUP_DE);
    }

    public static String composeFileSysSlim(I_DateTime datetime) {
        return FormDateTime.compose(datetime, FORM_DATETIME.GROUP_FILESYS_SLIM);
    }

    public static String composeFileSysWide(I_DateTime datetime) {
        return FormDateTime.compose(datetime, FORM_DATETIME.GROUP_FILESYS);
    }

    public static String composeFull(I_DateTime datetime) {
        return FormDateTime.compose(datetime, FORM_DATETIME.GROUP_DEFAULT_FULL);
    }

    public static String composeISO(I_Date date) {
        return FormDateTime.compose(date, LANGUAGE.EN, FORM_DATE.GROUP_ISO);
    }

    public static String composeShort(I_DateTime datetime) {
        return FormDateTime.compose(datetime, FORM_DATETIME.GROUP_DEFAULT);
    }

    public static String composeSlim(I_Date date) {
        return FormDateTime.compose(date, LANGUAGE.EN, FORM_DATE.GROUP_SHORT);
    }
}

