/*
 * Decompiled with CFR 0.152.
 */
package de.mn77.base.data.charset;

import de.mn77.base.error.Err;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public class ConvertCharset {
    public static byte[] toBytes(String s, Charset cs) {
        Err.ifNull(s, cs);
        return s.getBytes(cs);
    }

    public static String toString(byte[] ba) {
        return ConvertCharset.iBytesToString(ba, null, Charset.defaultCharset());
    }

    public static String toString(byte[] ba, Charset cs) {
        return ConvertCharset.iBytesToString(ba, cs, Charset.defaultCharset());
    }

    public static String toString(byte[] ba, String charsetName) {
        return ConvertCharset.iBytesToString(ba, charsetName, Charset.defaultCharset());
    }

    public static String toUTF8(byte[] ba, Charset cs) {
        return ConvertCharset.iBytesToString(ba, cs, StandardCharsets.UTF_8);
    }

    public static String toUTF8(byte[] ba, String charsetName) {
        return ConvertCharset.iBytesToString(ba, charsetName, StandardCharsets.UTF_8);
    }

    private static String iBytesToString(byte[] ba, Charset cs, Charset def) {
        Err.ifNull((Object)ba);
        return cs == null || cs.equals(def) ? new String(ba, def) : new String(ba, cs);
    }

    private static String iBytesToString(byte[] ba, String charsetName, Charset def) {
        Err.ifNull((Object)ba);
        try {
            return charsetName == null || charsetName.equals(def.name()) ? new String(ba, def) : new String(ba, charsetName);
        }
        catch (UnsupportedEncodingException e) {
            Err.show(e);
            return new String(ba);
        }
    }
}

