/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.edit.editor.funcs;

import de.mn77.base.data.convert.ConvString;
import de.mn77.base.data.group.Group2;
import de.mn77.base.data.group.Section;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import javax.swing.text.JTextComponent;
import org.jaymo_lang.edit.editor.CodeEditor;
import org.jaymo_lang.edit.editor.funcs.Lib_EditFunctions;

public class Fn_Comment {
    public void init(final CodeEditor editor) {
        editor.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getModifiersEx() == 128 && (e.getKeyCode() == 55 || e.getKeyCode() == 520)) {
                    e.consume();
                    boolean b = Fn_Comment.this.iComment(editor);
                    if (b) {
                        editor.getHistory().add();
                    }
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }
        });
    }

    protected boolean iComment(JTextComponent tp) {
        int cursorPos = tp.getCaretPosition();
        int x = tp.getCaret().getMark();
        String text = tp.getText();
        if (text.length() == 0) {
            return false;
        }
        Section selection = Lib_EditFunctions.getLines(text, cursorPos, x);
        if (selection != null) {
            if (selection.end < selection.start) {
                return false;
            }
            String part = text.substring(selection.start, selection.end);
            ArrayList lines = ConvString.toLines((String)part);
            boolean isCommented = this.isCommented(lines);
            Group2<String, Integer> pa = isCommented ? this.iReplaceRemove(lines) : this.iReplaceAdd(lines);
            tp.select(selection.start, selection.end);
            tp.replaceSelection((String)pa.o1);
            tp.select(cursorPos + (Integer)pa.o2, cursorPos + (Integer)pa.o2);
            return true;
        }
        return false;
    }

    private Group2<String, Integer> iReplaceAdd(ArrayList<String> lines) {
        StringBuffer sb = new StringBuffer();
        for (String line : lines) {
            sb.append("# ");
            sb.append(line);
            sb.append('\n');
        }
        sb.deleteCharAt(sb.length() - 1);
        return new Group2((Object)sb.toString(), (Object)(lines.size() * 2));
    }

    private Group2<String, Integer> iReplaceRemove(ArrayList<String> lines) {
        StringBuffer sb = new StringBuffer();
        int changed = 0;
        for (String line : lines) {
            String line2 = line.replaceFirst("[ \\t]*#[ ]?", "");
            changed -= line.length() - line2.length();
            sb.append(line2);
            sb.append('\n');
        }
        sb.deleteCharAt(sb.length() - 1);
        return new Group2((Object)sb.toString(), (Object)changed);
    }

    private boolean isCommented(ArrayList<String> lines) {
        String line1 = lines.get(0).trim();
        boolean searchCommented = line1.length() > 0 && line1.charAt(0) == '#';
        for (String line : lines) {
            if ((line = line.trim()).length() <= 0 || line.charAt(0) == '#' == searchCommented) continue;
            return false;
        }
        return searchCommented;
    }
}

