/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.edit.defs;

import de.mn77.base.sys.MOut;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import org.jaymo_lang.edit.action.EVENTS;
import org.jaymo_lang.edit.action.JayMo_Actions;
import org.jaymo_lang.edit.defs.EditorMainPanel;
import org.jaymo_lang.edit.defs.StatusBar;
import org.jaymo_lang.edit.editor.context.EditorContextMenu;

public class ToolbarPanel
extends JPanel {
    private static final long serialVersionUID = 6516457542639499813L;
    private final EditorMainPanel main;
    private final StatusBar statusBar;

    public ToolbarPanel(JayMo_Actions actions) {
        super(new BorderLayout());
        this.main = new EditorMainPanel(actions);
        this.statusBar = new StatusBar();
        actions.setMain(this.main);
        EditorContextMenu.addTo(this.main.getComponentEditor(), actions);
        JToolBar toolBar = new JToolBar("Toolbar 1");
        toolBar.setFloatable(false);
        toolBar.setRollover(true);
        this.addButtons(actions, toolBar);
        this.setPreferredSize(new Dimension(450, 130));
        this.add((Component)toolBar, "First");
        this.add((Component)this.main, "Center");
        this.add((Component)this.statusBar, "Last");
    }

    private void addButtons(JayMo_Actions actions, JToolBar toolBar) {
        JLabel image = new JLabel();
        ImageIcon img = new ImageIcon(this.getClass().getClassLoader().getResource("jar/logo/jaymo_toolbar_76x36.png"));
        image.setIcon(img);
        toolBar.add(image);
        toolBar.addSeparator();
        JButton button = null;
        button = this.iCreateButton(actions, "/jar/icon/document-new.png", "New", EVENTS.NEW, "New script", null);
        toolBar.add(button);
        button = this.iCreateButton(actions, "/jar/icon/document-open.png", "Open", EVENTS.OPEN, "Load a script", "STRG + o");
        toolBar.add(button);
        button = this.iCreateButton(actions, "/jar/icon/x-office-address-book.png", "Recent", EVENTS.RECENT, "Open a recent edited script", null);
        toolBar.add(button);
        button = this.iCreateButton(actions, "/jar/icon/document-save.png", "Save", EVENTS.SAVE, "Save script", "STRG + s");
        toolBar.add(button);
        button = this.iCreateButton(actions, "/jar/icon/document-save-as.png", "Save as", EVENTS.SAVE_AS, "Save script as", "STRG + SHIFT + s");
        toolBar.add(button);
        toolBar.addSeparator();
        JButton undoButton = this.iCreateButton(actions, "/jar/icon/edit-undo.png", "Undo", EVENTS.UNDO, "Undo", "STRG + z");
        toolBar.add(undoButton);
        JButton redoButton = this.iCreateButton(actions, "/jar/icon/edit-redo.png", "Redo", EVENTS.REDO, "Redo", "STRG + y");
        toolBar.add(redoButton);
        this.main.getComponentEditor().getHistory().eChanged(c -> {
            undoButton.setEnabled(c.canUndo());
            redoButton.setEnabled(c.canRedo());
        });
        undoButton.setEnabled(false);
        redoButton.setEnabled(false);
        toolBar.addSeparator();
        button = this.iCreateButton(actions, "/jar/icon/edit-cut.png", "Cut", EVENTS.CUT, "Cut", "STRG + x");
        toolBar.add(button);
        button = this.iCreateButton(actions, "/jar/icon/edit-copy.png", "Copy", EVENTS.COPY, "Copy", "STRG + c");
        toolBar.add(button);
        button = this.iCreateButton(actions, "/jar/icon/edit-paste.png", "Paste", EVENTS.PASTE, "Paste", "STRG + v");
        toolBar.add(button);
        toolBar.addSeparator();
        button = this.iCreateButton(actions, "/jar/icon/format-indent-less.png", "Indent-", EVENTS.OUTDENT, "Less indent", "SHIFT + Tab");
        toolBar.add(button);
        button = this.iCreateButton(actions, "/jar/icon/format-indent-more.png", "Indent+", EVENTS.INDENT, "More indent", "Tab");
        toolBar.add(button);
        button = this.iCreateButton(actions, "/jar/icon/edit-find.png", "Find", EVENTS.FIND, "Find", "STRG + f");
        toolBar.add(button);
        toolBar.addSeparator();
        button = this.iCreateButton(actions, "/jar/icon/media/media-playback-start_green.png", "Execute", EVENTS.EXEC, "Execute script", "F9");
        toolBar.add(button);
        JButton execButton = button;
        button = this.iCreateButton(actions, "/jar/icon/media/media-playback-stop_red.png", "Stop", EVENTS.STOP, "Stop execution", "F10");
        toolBar.add(button);
        button.setEnabled(false);
        JButton terminateButton = button;
        toolBar.addSeparator();
        button = this.iCreateButton(actions, "/jar/icon/help-browser.png", "Info", EVENTS.INFO, "Informations about JayMo", "F1");
        toolBar.add(button);
        button = this.iCreateButton(actions, "/jar/icon/applications-internet.png", "Website", EVENTS.WEB, "Go to 'www.jaymo-lang.org'", "F12");
        toolBar.add(button);
        actions.setButtons(execButton, terminateButton);
    }

    protected JButton iCreateButton(JayMo_Actions actions, String imagePath, String altText, EVENTS ev, String toolTipText, String hotkey) {
        URL imageURL = ToolbarPanel.class.getResource(imagePath);
        JButton button = new JButton();
        button.setActionCommand(ev.name());
        if (hotkey != null) {
            toolTipText = String.valueOf(toolTipText) + "  (" + hotkey + ')';
        }
        button.setToolTipText(toolTipText);
        button.addActionListener(actions);
        if (imageURL != null) {
            button.setIcon(new ImageIcon(imageURL, altText));
        } else {
            MOut.error((String)("Image not found: " + imagePath));
        }
        return button;
    }

    public void setFocus() {
        this.main.setFocus();
    }

    public void setStatus(String s) {
        this.statusBar.setMessage(s);
    }
}

