/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.cli;

import de.mn77.base.data.Lib_String;
import de.mn77.base.data.group.Group2;
import de.mn77.base.error.Err;
import de.mn77.base.error.Err_FileSys;
import de.mn77.base.sys.MOut;
import de.mn77.base.version.I_VersionData;
import de.mn77.base.version.Lib_Version;
import de.mn77.base.version.VersionData_ABC;
import de.mn77.lib.terminal.CSI_COLOR_BG;
import de.mn77.lib.terminal.CSI_COLOR_FG;
import de.mn77.lib.terminal.MTerminal;
import java.io.IOException;
import org.jaymo_lang.error.ErrorBaseDebug;
import org.jaymo_lang.model.App;
import org.jaymo_lang.parser.Parser_App;

public class CLI {
    private static final VersionData_ABC VERSION = new VersionData_ABC(0, 8, 2);
    private static final String PROMPT = "JayMo> ";
    private static final String RESULT_PREFIX = "=>  ";
    private static final Object EXIT_MESSAGE = "Have a nice day!";

    public static void main(String[] args) {
        try {
            Lib_Version.init((I_VersionData)VERSION, (boolean)false);
            CLI cli = new CLI();
            cli.start(false, false);
        }
        catch (Throwable e) {
            Err.exit((Throwable)e);
        }
    }

    public void start(boolean parseOnly, boolean debug) throws IOException, Err_FileSys {
        MOut.debugNo();
        MOut.setJavaErrors((boolean)false);
        Lib_Version.initKeep((I_VersionData)VERSION);
        Parser_App parser = new Parser_App(false);
        final MTerminal terminal = new MTerminal();
        if (debug) {
            terminal.setDebug();
        }
        parser.setTerminalRawMode(terminal.isInRawMode());
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                terminal.closeTerminal();
            }
        });
        this.iPrintHeadLine(terminal, parser);
        boolean run = true;
        while (run) {
            run = this.runTerminal(parser, terminal, null, parseOnly);
        }
        MOut.print((Object[])new Object[]{EXIT_MESSAGE});
    }

    public boolean runTerminal(Parser_App parser, MTerminal terminal, String in, boolean parseOnly) throws IOException, Err_FileSys {
        String output;
        String userInput;
        String string = userInput = in != null ? in : this.iReadLine(terminal);
        if (userInput == null || userInput.equals("exit") || userInput.equals("quit") || userInput.equals("q")) {
            terminal.print("\r\n");
            terminal.closeTerminal();
            return false;
        }
        boolean rawBefore = terminal.temporaryCooked();
        Group2<String, Boolean> result = this.iExec(parser, userInput, parseOnly);
        terminal.temporaryReset(rawBefore);
        boolean execOkay = (Boolean)result.o2;
        String string2 = parseOnly ? (execOkay ? "Parsing okay" : "Parsing failed") : (output = (String)result.o1);
        if (terminal != null) {
            if (terminal.isInRawMode()) {
                CSI_COLOR_FG color = execOkay ? CSI_COLOR_FG.GREEN : CSI_COLOR_FG.RED;
                output = Lib_String.replace((String)output, (char)'\n', (String)"\n\r");
                terminal.print(new Object[]{color, "\r=>  ", output, "\r\n", CSI_COLOR_FG.DEFAULT});
            } else {
                terminal.print(RESULT_PREFIX, output, "\n");
            }
        }
        return true;
    }

    private Group2<String, Boolean> iExec(Parser_App parser, String s, boolean parseOnly) throws Err_FileSys {
        int nextLineBreak;
        String result = null;
        boolean ok = false;
        try {
            App app = parser.parseText(s);
            result = parseOnly ? null : app.exec(null);
            ok = true;
        }
        catch (ErrorBaseDebug t) {
            MOut.print((Object[])new Object[]{t.toInfo()});
            result = "Error";
        }
        catch (Throwable t) {
            String errMsg = "Error   : Java-Error\r\n";
            MOut.print((Object[])new Object[]{"Error   : Java-Error\r\n" + t.getMessage()});
            result = "Error";
        }
        if (result == null) {
            result = "";
        }
        if ((nextLineBreak = result.indexOf(10)) >= 0) {
            result = String.valueOf(result.substring(0, nextLineBreak)) + "\u00b6\u2026";
        }
        return new Group2((Object)result, (Object)ok);
    }

    private void iPrintHeadLine(MTerminal terminal, Parser_App parser) {
        String version_parser = parser.getVersionString(false, false);
        String version_cli = "CLI " + VERSION.toStringShort();
        String delimiter = "  /  ";
        if (terminal.isInRawMode()) {
            terminal.print(new Object[]{CSI_COLOR_BG.BLUE});
            terminal.print(new Object[]{CSI_COLOR_FG.WHITE, "JayMo"});
            terminal.print(new Object[]{CSI_COLOR_BG.DEFAULT});
            terminal.print("  ");
            terminal.print(new Object[]{CSI_COLOR_FG.YELLOW, version_parser});
            terminal.print(new Object[]{CSI_COLOR_FG.DARKGRAY, "  /  "});
            terminal.print(new Object[]{CSI_COLOR_FG.GREEN, version_cli});
            terminal.print(new Object[]{CSI_COLOR_FG.DARKGRAY, "  /  "});
            terminal.print(new Object[]{CSI_COLOR_FG.BLUE});
            terminal.print("www.jaymo-lang.org");
            terminal.print("\r\n\n");
        } else {
            StringBuilder sb = new StringBuilder();
            sb.append("JayMo");
            sb.append("  ");
            sb.append(version_parser);
            sb.append("  /  ");
            sb.append(version_cli);
            sb.append("  /  ");
            sb.append("www.jaymo-lang.org");
            sb.append("\n\n");
            terminal.print(sb.toString());
        }
    }

    private String iReadLine(MTerminal terminal) throws IOException {
        if (terminal.isInRawMode()) {
            terminal.print(new Object[]{CSI_COLOR_BG.DEFAULT, CSI_COLOR_FG.LIGHTBLUE, PROMPT, CSI_COLOR_FG.DEFAULT});
            String input = terminal.readLine();
            terminal.print("\r\n");
            return input;
        }
        terminal.print(PROMPT);
        return terminal.readLine();
    }
}

