/*
 * Decompiled with CFR 0.152.
 */
package de.mn77.lib.xml;

import de.mn77.base.error.Err;
import de.mn77.base.error.Err_Exception;
import de.mn77.base.sys.MOut;
import java.io.IOException;
import java.io.OutputStream;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class XML_Output {
    private XMLStreamWriter writer;
    private OutputStream stream;

    public static void main(String[] args) {
        try {
            XML_Output xml = new XML_Output(MOut.streamText());
            xml.oeffnen("party");
            xml.attribut("datum", "31.12.2001");
            xml.oeffnen("gast");
            xml.attribut("name", "Albert \u00c4ngstlich");
            xml.schliessen();
            xml.schliessen();
            xml.fertig();
        }
        catch (Throwable t) {
            Err.exit((Throwable)t);
        }
    }

    public XML_Output(OutputStream os) throws Err_Exception {
        try {
            XMLOutputFactory factory = XMLOutputFactory.newInstance();
            this.writer = factory.createXMLStreamWriter(os);
            this.writer.writeStartDocument();
            this.writer.writeCharacters("\n");
            this.stream = os;
        }
        catch (XMLStreamException e) {
            Err.wrap((Exception)e, (Object[])new Object[]{"Schreiben fehlgeschlagen"});
        }
    }

    public XML_Output(OutputStream os, String encoding) throws Err_Exception {
        try {
            XMLOutputFactory factory = XMLOutputFactory.newInstance();
            this.writer = factory.createXMLStreamWriter(os);
            this.writer.writeStartDocument(encoding, "1.0");
            this.stream = os;
        }
        catch (XMLStreamException e) {
            Err.wrap((Exception)e, (Object[])new Object[]{"Schreiben fehlgeschlagen"});
        }
    }

    public void fertig() throws Err_Exception {
        try {
            this.writer.writeEndDocument();
            this.writer.close();
            this.stream.close();
        }
        catch (XMLStreamException e) {
            Err.wrap((Exception)e, (Object[])new Object[]{"Schreiben fehlgeschlagen"});
        }
        catch (IOException e) {
            Err.wrap((IOException)e, (Object[])new Object[]{"Schreiben fehlgeschlagen"});
        }
    }

    public void oeffnen(String name) throws Err_Exception {
        try {
            this.writer.writeStartElement(name);
        }
        catch (XMLStreamException e) {
            Err.wrap((Exception)e, (Object[])new Object[]{"Schreiben fehlgeschlagen"});
        }
    }

    public void text(String text) throws Err_Exception {
        try {
            this.writer.writeCharacters(text);
        }
        catch (XMLStreamException e) {
            Err.wrap((Exception)e, (Object[])new Object[]{"Schreiben fehlgeschlagen"});
        }
    }

    public void schliessen(String wirdnichtverwendet) throws Err_Exception {
        this.schliessen();
    }

    public void schliessen() throws Err_Exception {
        try {
            this.writer.writeEndElement();
            this.writer.writeCharacters("\n");
        }
        catch (XMLStreamException e) {
            Err.wrap((Exception)e, (Object[])new Object[]{"Schreiben fehlgeschlagen"});
        }
    }

    public void attribut(String name, String wert) throws Err_Exception {
        try {
            this.writer.writeAttribute(name, wert);
        }
        catch (XMLStreamException e) {
            Err.wrap((Exception)e, (Object[])new Object[]{"Schreiben fehlgeschlagen"});
        }
    }

    public void attributNull(String name, String wert) throws Err_Exception {
        if (wert != null) {
            this.attribut(name, wert);
        }
    }

    public XMLStreamWriter gWriter() {
        return this.writer;
    }

    public void schnell(String name, String text) throws Err_Exception {
        this.oeffnen(name);
        this.text(text);
        this.schliessen();
    }
}

