/*
 * Decompiled with CFR 0.152.
 */
package de.mn77.lib.udp;

import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class UDP_Packet {
    private byte[] data = null;
    private InetAddress address = null;
    private int port = 0;

    public UDP_Packet(DatagramPacket packet) {
        this.address = packet.getAddress();
        this.port = packet.getPort();
        this.data = new byte[packet.getLength()];
        System.arraycopy(packet.getData(), packet.getOffset(), this.data, 0, packet.getLength());
    }

    public UDP_Packet(InetAddress address, int port, byte[] data) {
        this.address = address;
        this.port = port;
        this.data = data;
    }

    public UDP_Packet(InetAddress address, int port, String data) {
        this.address = address;
        this.port = port;
        this.setData(data);
    }

    public UDP_Packet(String target, int port, String bytes) throws UnknownHostException {
        this.address = InetAddress.getByName(target);
        this.port = port;
        this.setData(bytes);
    }

    public UDP_Packet(String target, int port, byte[] bytes) throws UnknownHostException {
        this.address = InetAddress.getByName(target);
        this.port = port;
        this.data = bytes;
    }

    public UDP_Packet() {
    }

    public String toString() {
        return this.getAddress() + ":" + this.getPort() + " \"" + this.getString() + "\"";
    }

    public void setData(byte[] data) {
        this.data = data;
    }

    public void setData(byte[] data, int offset, int size) {
        byte[] ba = new byte[size];
        System.arraycopy(data, offset, ba, 0, size);
        this.data = ba;
    }

    public void setData(String text) {
        this.data = text.getBytes();
    }

    public void setAddress(InetAddress address) {
        this.address = address;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public byte[] getData() {
        return this.data;
    }

    public String getString() {
        return new String(this.data);
    }

    public InetAddress getAddress() {
        return this.address;
    }

    public int getPort() {
        return this.port;
    }

    public DatagramPacket getDatagram() {
        return new DatagramPacket(this.data, 0, this.data.length, this.address, this.port);
    }
}

