/*
 * Decompiled with CFR 0.152.
 */
package de.mn77.lib.textstyler;

import de.mn77.base.data.Lib_Math;
import de.mn77.base.data.Lib_String;
import de.mn77.base.data.struct.I_Sequence;
import de.mn77.base.data.struct.list.I_List;
import de.mn77.base.data.struct.list.MList;
import de.mn77.base.data.struct.potlist.PotList;
import de.mn77.lib.textstyler.I_TextStyler;
import de.mn77.lib.textstyler.TS_Line;

public class TextStyler
implements I_TextStyler {
    private final I_List<TS_Line> lines = new MList();
    private boolean border = false;

    @Override
    public TS_Line newLine() {
        TS_Line line = new TS_Line(this);
        this.lines.add((Object)line);
        return line;
    }

    @Override
    public void addBorder() {
        this.border = true;
    }

    @Override
    public String get() {
        PotList requirements = new PotList();
        int maxRanges = 0;
        for (TS_Line line : this.lines) {
            I_Sequence<Integer> lineRequire = line.gBedarf();
            requirements.addRow(lineRequire);
            maxRanges = (Integer)Lib_Math.max((Comparable[])new Integer[]{maxRanges, lineRequire.size()});
        }
        MList widthList = new MList();
        int i = 1;
        while (i <= maxRanges) {
            widthList.add((Object)0);
            ++i;
        }
        for (I_Sequence requireLine : requirements) {
            while (requireLine.size() < maxRanges) {
                ((I_List)requireLine).add(null);
            }
        }
        for (I_Sequence lineRequires : requirements) {
            int last = 1;
            int nulling = 0;
            int nr = 1;
            while (nr <= lineRequires.size()) {
                if (lineRequires.get(nr) == null) {
                    ++nulling;
                }
                if (lineRequires.get(nr) != null || nr == lineRequires.size()) {
                    if (nulling > 0) {
                        int value = (Integer)lineRequires.get(last);
                        int part = Lib_Math.roundUp((double)((double)value / ((double)nulling + 1.0)));
                        int nr2 = last;
                        while (nr2 <= last + nulling) {
                            ((I_List)lineRequires).set(nr2, (Object)part);
                            ++nr2;
                        }
                        nulling = 0;
                    }
                    last = nr;
                }
                ++nr;
            }
        }
        for (I_Sequence lineRequires : requirements) {
            int i2 = 1;
            while (i2 <= lineRequires.size()) {
                widthList.set(i2, (Object)((Integer)Lib_Math.max((Comparable[])new Integer[]{(Integer)widthList.get(i2), (Integer)lineRequires.get(i2)})));
                ++i2;
            }
        }
        int widthOverAll = 0;
        for (Integer width : widthList) {
            widthOverAll += width.intValue();
        }
        StringBuilder result = new StringBuilder();
        if (this.border) {
            result.append("/" + Lib_String.sequence((char)'\u00af', (long)(widthOverAll + 2)) + "\\\n");
        }
        int pos = 1;
        while (pos <= this.lines.size()) {
            if (pos > 1) {
                result.append('\n');
            }
            TS_Line line = (TS_Line)this.lines.get(pos);
            result.append(this.border ? "| " + line.get((I_Sequence<Integer>)widthList) + " |" : line.get((I_Sequence<Integer>)widthList));
            ++pos;
        }
        if (this.border) {
            result.append("\n\\" + Lib_String.sequence((char)'_', (long)(widthOverAll + 2)) + "/\n");
        }
        return result.toString();
    }

    public String toString() {
        return this.get();
    }
}

