/*
 * Decompiled with CFR 0.152.
 */
package de.mn77.lib.textstyler;

import de.mn77.base.data.group.Group2;
import de.mn77.base.data.struct.I_Sequence;
import de.mn77.base.data.struct.list.I_List;
import de.mn77.base.data.struct.list.MList;
import de.mn77.base.data.struct.table.type.TypeTable2;
import de.mn77.base.error.Err;
import de.mn77.lib.textstyler.TS_CONSTANTS;
import de.mn77.lib.textstyler.TS_Field;
import de.mn77.lib.textstyler.TextStyler;

public class TS_Line {
    private final TextStyler td;
    private final TypeTable2<TS_CONSTANTS, String> content;
    private I_List<TS_Field> puffer_bereiche;
    private int nextTab = 1;

    public TS_Line(TextStyler td) {
        this.td = td;
        this.content = new TypeTable2(TS_CONSTANTS.class, String.class);
    }

    public TS_Line l(String text) {
        Err.ifNull((Object[])new Object[]{text});
        this.content.add(new Object[]{TS_CONSTANTS.LEFT, text});
        return this;
    }

    public TS_Line r(String text) {
        Err.ifNull((Object[])new Object[]{text});
        this.content.add(new Object[]{TS_CONSTANTS.RIGHT, text});
        return this;
    }

    public TS_Line c(String text) {
        Err.ifNull((Object[])new Object[]{text});
        this.content.add(new Object[]{TS_CONSTANTS.CENTER, text});
        return this;
    }

    public TS_Line tc(char c) {
        this.content.add(new Object[]{TS_CONSTANTS.FILL, "" + c});
        return this;
    }

    public TS_Line t(int ... nr) {
        Err.ifOutOfBounds((double)0.0, (double)1.0, (double[])new double[]{nr.length});
        int tab = nr.length == 1 ? nr[0] : this.nextTab;
        Err.ifToSmall((double)this.nextTab, (double)tab);
        this.nextTab = tab + 1;
        this.content.add(new Object[]{TS_CONSTANTS.TAB, "" + tab});
        return this;
    }

    public TS_Line rtl(String text, char delimiter, int ... nr) {
        Err.ifNull((Object[])new Object[]{text});
        if (text.indexOf(delimiter) == -1) {
            Err.invalid((Object[])new Object[]{"Text contains no delimiter. But it is needed!"});
        }
        String r = text.substring(0, text.indexOf(delimiter));
        String l = text.substring(text.indexOf(delimiter), text.length());
        this.r(r);
        this.t(nr);
        this.l(l);
        return this;
    }

    public TextStyler gDesigner() {
        return this.td;
    }

    public I_Sequence<Integer> gBedarf() {
        this.puffer_bereiche = new MList();
        TS_Field akt_bereich = new TS_Field();
        this.puffer_bereiche.add((Object)akt_bereich);
        int naechste_flucht = 1;
        for (Group2 g : this.content) {
            if (g.o1 == TS_CONSTANTS.LEFT) {
                akt_bereich.left((String)g.o2);
            }
            if (g.o1 == TS_CONSTANTS.CENTER) {
                akt_bereich.center((String)g.o2);
            }
            if (g.o1 == TS_CONSTANTS.RIGHT) {
                akt_bereich.right((String)g.o2);
            }
            if (g.o1 == TS_CONSTANTS.FILL) {
                akt_bereich.fill(((String)g.o2).charAt(0));
            }
            if (g.o1 != TS_CONSTANTS.TAB) continue;
            int fluchtnr = Integer.parseInt((String)g.o2);
            while (naechste_flucht < fluchtnr) {
                this.puffer_bereiche.add(null);
                ++naechste_flucht;
            }
            akt_bereich = new TS_Field();
            this.puffer_bereiche.add((Object)akt_bereich);
            ++naechste_flucht;
        }
        MList result = new MList();
        for (TS_Field bereich : this.puffer_bereiche) {
            result.add(bereich == null ? null : Integer.valueOf(bereich.needed()));
        }
        return result;
    }

    public String get(I_Sequence<Integer> breiten) {
        Err.ifToSmall((double)this.puffer_bereiche.size(), (double)breiten.size());
        while (this.puffer_bereiche.size() < breiten.size()) {
            this.puffer_bereiche.add(null);
        }
        MList breiten2 = new MList();
        int letzter = 1;
        int bnr = 1;
        while (bnr <= this.puffer_bereiche.size()) {
            if (this.puffer_bereiche.get(bnr) == null) {
                breiten2.set(letzter, (Object)((Integer)breiten2.get(letzter) + (Integer)breiten.get(bnr)));
                breiten2.add((Object)0);
            } else {
                breiten2.add((Object)((Integer)breiten.get(bnr)));
                letzter = bnr;
            }
            ++bnr;
        }
        StringBuilder sb = new StringBuilder();
        int bnr2 = 1;
        while (bnr2 <= this.puffer_bereiche.size()) {
            TS_Field bereich = (TS_Field)this.puffer_bereiche.get(bnr2);
            if (bereich != null) {
                sb.append(bereich.get((Integer)breiten2.get(bnr2)));
            }
            ++bnr2;
        }
        return sb.toString();
    }
}

