/*
 * Decompiled with CFR 0.152.
 */
package de.mn77.lib.textstyler;

import de.mn77.base.data.Lib_Math;
import de.mn77.base.data.Lib_String;
import de.mn77.base.data.group.Group2;
import de.mn77.base.data.struct.list.I_List;
import de.mn77.base.data.struct.list.MList;
import de.mn77.base.error.Err;
import de.mn77.lib.textstyler.TS_CONSTANTS;

public class TS_Field {
    private final I_List<Group2<TS_CONSTANTS, String>> content = new MList();
    private int buffer_needed;

    public void left(String text) {
        this.content.add((Object)new Group2((Object)TS_CONSTANTS.LEFT, (Object)text));
    }

    public void center(String text) {
        this.content.add((Object)new Group2((Object)TS_CONSTANTS.CENTER, (Object)text));
    }

    public void right(String text) {
        this.content.add((Object)new Group2((Object)TS_CONSTANTS.RIGHT, (Object)text));
    }

    public void fill(char c) {
        this.content.add((Object)new Group2((Object)TS_CONSTANTS.FILL, (Object)("" + c)));
    }

    public int needed() {
        int needs;
        int l = 0;
        int m = 0;
        int r = 0;
        for (Group2 g : this.content) {
            if (g.o1 == TS_CONSTANTS.LEFT) {
                if (l > 0) {
                    ++l;
                }
                l += ((String)g.o2).length();
            }
            if (g.o1 == TS_CONSTANTS.CENTER) {
                if (m > 0) {
                    ++m;
                }
                m += ((String)g.o2).length();
            }
            if (g.o1 != TS_CONSTANTS.RIGHT) continue;
            if (r > 0) {
                ++r;
            }
            r += ((String)g.o2).length();
        }
        int a = (Integer)Lib_Math.max((Comparable[])new Integer[]{l, r});
        int flm = m > 0 ? 1 : 0;
        int fmr = l > 0 || m > 0 ? 1 : 0;
        this.buffer_needed = needs = m > 0 ? a + flm + m + fmr + a : l + flm + m + fmr + r;
        return this.buffer_needed;
    }

    public String get(int wantedWith) {
        int remR;
        int remL;
        int rem;
        Err.ifToSmall((double)this.buffer_needed, (double)wantedWith);
        String l = "";
        String m = "";
        String r = "";
        int lz = 0;
        int mz = 0;
        int rz = 0;
        char cur_fill = ' ';
        char fill_right = ' ';
        char fill_left = ' ';
        for (Group2 g : this.content) {
            if (g.o1 == TS_CONSTANTS.LEFT) {
                if (mz > 0 || rz > 0) {
                    Err.invalid((Object[])new Object[]{"Left after Center or Right"});
                }
                if (lz > 0) {
                    l = String.valueOf(l) + cur_fill;
                }
                l = String.valueOf(l) + (String)g.o2;
                ++lz;
            }
            if (g.o1 == TS_CONSTANTS.CENTER) {
                if (rz > 0) {
                    Err.invalid((Object[])new Object[]{"Center after Right"});
                }
                if (mz > 0) {
                    m = String.valueOf(m) + cur_fill;
                }
                m = String.valueOf(m) + (String)g.o2;
                ++mz;
            }
            if (g.o1 == TS_CONSTANTS.RIGHT) {
                if (rz > 0) {
                    r = String.valueOf(r) + cur_fill;
                }
                r = String.valueOf(r) + (String)g.o2;
                ++rz;
            }
            if (g.o1 != TS_CONSTANTS.FILL) continue;
            cur_fill = ((String)g.o2).charAt(0);
            if (mz == 0 && rz == 0) {
                fill_left = cur_fill;
            }
            if (rz != 0) continue;
            fill_right = cur_fill;
        }
        if (mz == 0) {
            fill_right = fill_left;
        }
        if (m.length() > 0) {
            int outside = Math.max(l.length(), r.length());
            rem = wantedWith - 2 * outside - m.length();
            remL = outside - l.length() + rem / 2;
            remR = outside - r.length() + rem / 2;
        } else {
            rem = wantedWith - l.length() - r.length() - m.length();
            remL = rem / 2;
            remR = rem / 2;
        }
        if (!Lib_Math.isEven((long)rem)) {
            ++remR;
        }
        return String.valueOf(l) + Lib_String.sequence((char)fill_left, (long)remL) + m + Lib_String.sequence((char)fill_right, (long)remR) + r;
    }
}

