/*
 * Decompiled with CFR 0.152.
 */
package de.mn77.lib.tcp;

import de.mn77.base.error.Err;
import de.mn77.base.event.A_EnumEventHandler;
import de.mn77.base.sys.MOut;
import de.mn77.lib.tcp.TCP_Connection;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.function.Consumer;

public class TCP_Server
extends A_EnumEventHandler {
    private final ServerSocket serversocket;

    public TCP_Server(int port) throws IOException {
        this.serversocket = new ServerSocket(port);
    }

    public TCP_Connection waitForConnection() {
        return this.waitForConnection(60000);
    }

    public TCP_Connection waitForConnection(int timeout_ms) {
        try {
            this.serversocket.setSoTimeout(timeout_ms);
            Socket socket = this.serversocket.accept();
            TCP_Connection connection = new TCP_Connection(socket, false);
            this.eventStart(EVENTS.CONNECT, (Object)connection);
            return connection;
        }
        catch (SocketTimeoutException e) {
            this.eventStart(EVENTS.TIMEOUT, e);
            MOut.debug((Object[])new Object[]{e});
        }
        catch (IOException e) {
            this.eventStart(EVENTS.ERROR, e);
            Err.show((Throwable)e);
        }
        return null;
    }

    public void close() {
        try {
            this.serversocket.setSoTimeout(1);
            this.serversocket.close();
        }
        catch (SocketException e) {
            Err.show((Throwable)e);
        }
        catch (IOException e) {
            Err.show((Throwable)e);
        }
    }

    public void onTimeOut(Consumer<SocketTimeoutException> z) {
        this.eventAdd(EVENTS.TIMEOUT, z);
    }

    public void onError(Consumer<IOException> z) {
        this.eventAdd(EVENTS.ERROR, z);
    }

    public void onConnect(Consumer<TCP_Connection> z) {
        this.eventAdd(EVENTS.CONNECT, z);
    }

    public boolean isWaiting() {
        return !this.serversocket.isClosed();
    }

    private static enum EVENTS {
        TIMEOUT,
        ERROR,
        CONNECT;

    }
}

