/*
 * Decompiled with CFR 0.152.
 */
package de.mn77.lib.tcp;

import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class TCP_Packet {
    private byte[] data = null;
    private InetAddress address = null;
    private int port = 0;

    public TCP_Packet() {
    }

    public TCP_Packet(DatagramPacket packet) {
        this.address = packet.getAddress();
        this.port = packet.getPort();
        this.data = new byte[packet.getLength()];
        System.arraycopy(packet.getData(), packet.getOffset(), this.data, 0, packet.getLength());
    }

    public TCP_Packet(InetAddress address, int port, byte[] bytes) {
        this.address = address;
        this.port = port;
        this.data = bytes;
    }

    public TCP_Packet(InetAddress address, int port, String bytes) {
        this.address = address;
        this.port = port;
        this.setData(bytes);
    }

    public TCP_Packet(String target, int port, byte[] bytes) throws UnknownHostException {
        this.address = InetAddress.getByName(target);
        this.port = port;
        this.data = bytes;
    }

    public TCP_Packet(String target, int port, String bytes) throws UnknownHostException {
        this.address = InetAddress.getByName(target);
        this.port = port;
        this.setData(bytes);
    }

    public InetAddress getAddress() {
        return this.address;
    }

    public byte[] getData() {
        return this.data;
    }

    public String getDataAsString() {
        return new String(this.data);
    }

    public DatagramPacket getDatagram() {
        return new DatagramPacket(this.data, 0, this.data.length, this.address, this.port);
    }

    public int getPort() {
        return this.port;
    }

    public void setAddress(InetAddress adresse) {
        this.address = adresse;
    }

    public void setData(byte[] bytes) {
        this.data = bytes;
    }

    public void setData(byte[] bytes, int offset, int size) {
        byte[] ba = new byte[size];
        System.arraycopy(bytes, offset, ba, 0, size);
        this.data = ba;
    }

    public void setData(String message) {
        this.data = message.getBytes();
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String toString() {
        return this.getAddress() + ":" + this.getPort() + " \"" + this.getDataAsString() + "\"";
    }
}

