/*
 * Decompiled with CFR 0.152.
 */
package de.mn77.lib.ntp;

import de.mn77.base.data.Lib_Math;
import de.mn77.base.data.type.datetime.I_Date;
import de.mn77.base.data.type.datetime.I_DateTime;
import de.mn77.base.data.type.datetime.I_Time;
import de.mn77.base.data.type.datetime.MDate;
import de.mn77.base.data.type.datetime.MDateTime;
import de.mn77.base.data.type.datetime.MTime;
import de.mn77.base.error.Err_Network;
import de.mn77.lib.ntp.I_NTP_Client_Base;
import de.mn77.lib.ntp.NTP_Message;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;

public class SNTP_Client
implements I_NTP_Client_Base {
    private final String server;
    private long diff = 0L;
    private long transitTime = -1L;
    private NTP_Message message = null;

    public SNTP_Client() {
        this("pool.ntp.org");
    }

    public SNTP_Client(String server) {
        this.server = server;
    }

    @Override
    public long getDifferenceMSek() {
        return this.diff;
    }

    public long getTransitTimeMSec() {
        return this.transitTime;
    }

    public NTP_Message getMessage() {
        return this.message;
    }

    @Override
    public I_Time getTime() {
        return new MTime(System.currentTimeMillis() + this.diff);
    }

    @Override
    public I_Date getDate() {
        return new MDate(System.currentTimeMillis() + this.diff);
    }

    @Override
    public I_DateTime getDateTime() {
        return new MDateTime(System.currentTimeMillis() + this.diff);
    }

    @Override
    public void update() throws Err_Network {
        try {
            DatagramSocket socket = new DatagramSocket();
            InetAddress serverAddress = InetAddress.getByName(this.server);
            byte[] data = new NTP_Message().dataBytes();
            DatagramPacket packet = new DatagramPacket(data, data.length, serverAddress, 123);
            NTP_Message.timeDoubleToByte(packet.getData(), 40, NTP_Message.utcToTimestamp(System.currentTimeMillis()));
            socket.setSoTimeout(3000);
            socket.send(packet);
            packet = new DatagramPacket(data, data.length);
            socket.receive(packet);
            socket.close();
            double recieveTime = NTP_Message.utcToTimestamp(System.currentTimeMillis());
            NTP_Message msg = new NTP_Message(packet.getData());
            double localDiff = (msg.serverRecieveTime - msg.clientSendTime + (msg.serverSendTime - recieveTime)) / 2.0;
            double duration = recieveTime - msg.clientSendTime - (msg.serverSendTime - msg.serverRecieveTime);
            this.diff = Long.parseLong(Lib_Math.roundToString((double)(localDiff * 1000.0), (int)0));
            this.transitTime = Long.parseLong(Lib_Math.roundToString((double)(duration * 1000.0), (int)0));
            this.message = msg;
        }
        catch (IOException e) {
            throw new Err_Network((Throwable)e, new Object[]{this.server});
        }
    }

    public String toString() {
        return "SNTP-Client (Server: '" + this.server + "')";
    }
}

