/*
 * Decompiled with CFR 0.152.
 */
package de.mn77.lib.lang;

import de.mn77.base.data.form.FormString;
import de.mn77.base.data.struct.list.I_List;
import de.mn77.base.error.Err_FileSys;
import de.mn77.base.sys.file.Lib_TextFile;
import de.mn77.lib.lang.PoData;
import de.mn77.lib.lang.PoItem;
import java.io.File;

public class PoWriter {
    public static void write(File poTransFile, PoData data) throws Err_FileSys {
        StringBuilder sb = new StringBuilder();
        for (PoItem item : data.getItems()) {
            I_List<String> comments = item.getComments();
            if (comments != null) {
                for (String comment : comments) {
                    sb.append(String.valueOf(comment) + '\n');
                }
            }
            if (item.isFuzzy()) {
                sb.append("#, fuzzy\n");
            }
            String id = FormString.escapeSpecialChars((String)item.getId(), (boolean)false, (boolean)true);
            id = PoWriter.iToLines(id);
            sb.append("msgid " + id + "\n");
            String str = FormString.escapeSpecialChars((String)item.getStr(), (boolean)false, (boolean)true);
            str = PoWriter.iToLines(str);
            sb.append("msgstr " + str + "\n");
            sb.append('\n');
        }
        Lib_TextFile.set((File)poTransFile, (String)sb.toString(), (boolean)true);
    }

    private static String iToLines(String s) {
        String s2 = s.replace("\\n", "\\n\"\n\"");
        if (s.length() != s2.length()) {
            s2 = "\"\n\"" + s2;
        }
        if (s2.endsWith("\\n\"\n\"")) {
            s2 = s2.substring(0, s2.length() - 3);
        }
        return "\"" + s2 + '\"';
    }
}

