/*
 * Decompiled with CFR 0.152.
 */
package de.mn77.lib.fuzzy;

import de.mn77.base.data.filter.FilterString;
import de.mn77.base.error.Err;

public class Fuzzy {
    private final char[] lowercaseTable = this.iCreateTable();

    public double compare(String s1, String s2) {
        return (double)this.iCompare(s1, s2, false) / 100.0;
    }

    public double compare(String s1, String s2, boolean onlyLengthOfString1) {
        return (double)this.iCompare(s1, s2, onlyLengthOfString1) / 100.0;
    }

    private int iCompare(String s1, String s2, boolean onlyLengthOfString1) {
        Err.ifNull((Object[])new Object[]{s1, s2});
        s1 = FilterString.trimToASCII((String)s1);
        s2 = FilterString.trimToASCII((String)s2);
        int s1_len = s1.length();
        int s2_len = s2.length();
        int s1_pos = 1;
        int s2_pos = 1;
        int equal = 0;
        int result = 0;
        if (s1_len == 0 || s2_len == 0) {
            return 0;
        }
        int s1_len3 = this.iDiv3(s1_len << 1);
        int s2_len3 = this.iDiv3(s2_len << 1);
        char next1 = this.lowercaseTable[this.iChar(s1, s1_pos)];
        char next2 = this.lowercaseTable[this.iChar(s2, s2_pos)];
        while (s1_pos <= s1_len && s2_pos <= s2_len) {
            char current1 = next1;
            next1 = this.lowercaseTable[this.iChar(s1, ++s1_pos)];
            char current2 = next2;
            next2 = this.lowercaseTable[this.iChar(s2, ++s2_pos)];
            if (current1 == current2) {
                if (s1_pos <= 3 && s2_pos <= 3) {
                    equal += 300;
                    continue;
                }
                equal += 200;
                continue;
            }
            if (s1_pos < s1_len && s2_pos < s2_len && current1 == next2 && current2 == next1) {
                result += this.iWeight(s1_pos, s1_len3) + this.iWeight(s2_pos, s2_len3);
                equal += 100;
                current1 = next1;
                next1 = this.lowercaseTable[this.iChar(s1, ++s1_pos)];
                current2 = next2;
                next2 = this.lowercaseTable[this.iChar(s2, ++s2_pos)];
                continue;
            }
            if (s1_pos < s1_len && next1 == current2) {
                result += this.iWeight(s1_pos, s1_len3);
                equal += 200;
                current1 = next1;
                next1 = this.lowercaseTable[this.iChar(s1, ++s1_pos)];
                continue;
            }
            if (s2_pos < s2_len && current1 == next2) {
                result += this.iWeight(s2_pos, s2_len3);
                equal += 200;
                current2 = next2;
                next2 = this.lowercaseTable[this.iChar(s2, ++s2_pos)];
                continue;
            }
            result += this.iWeight(s1_pos, s1_len3) + this.iWeight(s2_pos, s2_len3);
        }
        if (!onlyLengthOfString1 || s1_pos < s1_len) {
            while (s1_pos <= s1_len) {
                result += this.iWeight(s1_pos, s1_len3);
                ++s1_pos;
            }
            while (s2_pos <= s2_len) {
                result += this.iWeight(s2_pos, s2_len3);
                ++s2_pos;
            }
        }
        result = equal * 100 / (equal + result);
        return result;
    }

    private char[] iCreateTable() {
        char[] result = new char[256];
        char ch = '\u0000';
        while (ch < '\u0100') {
            char ch2 = ch;
            result[ch] = ch2 = ("" + ch2).toLowerCase().charAt(0);
            ch = (char)(ch + '\u0001');
        }
        return result;
    }

    private int iDiv3(int x) {
        return (x << 2) + x + (x >> 2) + 8 >> 4;
    }

    private char iChar(String s, int pos) {
        return pos > s.length() ? (char)'\u0000' : s.charAt(--pos);
    }

    private int iWeight(int i, int length) {
        if (i > length) {
            return 30;
        }
        if (i > length >> 1) {
            return 80;
        }
        return 100;
    }
}

