/*
 * Decompiled with CFR 0.152.
 */
package de.mn77.lib.csv;

import de.mn77.base.data.Lib_Array;
import de.mn77.base.data.group.Group2;
import de.mn77.base.data.struct.list.MList;
import de.mn77.base.data.struct.table.I_Table;
import de.mn77.base.data.struct.table.MTable;
import de.mn77.base.sys.MOut;
import de.mn77.base.sys.file.Lib_TextFile;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public class Lib_CSV {
    public static void main(String[] args) {
        try {
            File file = new File("/tmp/Umsaetze_edit2.csv");
            String csv = Lib_TextFile.read((File)file, (boolean)true);
            I_Table<String> tab1 = Lib_CSV.parse(csv, '\"', ';', "\n", true, false, StandardCharsets.UTF_8);
            MOut.print((Object[])new Object[]{tab1});
            MOut.print((Object[])new Object[]{"-----------"});
            I_Table<String> tab2 = Lib_CSV.parse(csv, '\"', ';', "\n", false, true, StandardCharsets.UTF_8);
            MOut.print((Object[])new Object[]{tab2});
            MOut.print((Object[])new Object[]{"-----------"});
            I_Table<String> tab3 = Lib_CSV.parse(csv, '\"', ';', "\n", true, true, StandardCharsets.UTF_8);
            MOut.print((Object[])new Object[]{tab3});
        }
        catch (Throwable t) {
            MOut.error((Throwable)t);
        }
    }

    public static I_Table<String> parse(String csv, char separator_field, char separator_column, String separator_line, boolean first, boolean other, Charset cs) {
        if (cs != null && !cs.equals(StandardCharsets.UTF_8)) {
            csv = new String(csv.getBytes(cs), StandardCharsets.UTF_8);
        }
        return Lib_CSV.parse(csv, separator_field, separator_column, separator_line, first, other);
    }

    public static I_Table<String> parse(String csv, char separator_field, char separator_column, String separator_line, boolean first, boolean other) {
        MTable result = null;
        int offset = 0;
        int lineNr = 0;
        Integer width = null;
        while (offset < csv.length()) {
            Group2<String[], Integer> g = Lib_CSV.parseNextLine(csv, offset, separator_field, separator_column, separator_line);
            Object[] sa = (String[])g.o1;
            offset = (Integer)g.o2;
            if (result == null) {
                width = sa.length;
                result = new MTable(width.intValue());
            }
            if (sa.length == 0) continue;
            if (first && lineNr == 0 || other && lineNr > 0) {
                while (sa.length < width) {
                    sa = Lib_Array.append(String.class, (String[])sa, null);
                }
                result.add(sa);
            }
            ++lineNr;
        }
        return result;
    }

    private static Group2<String[], Integer> parseNextLine(String text, int offset, char separator_field, char separator_column, String separator_line) {
        MList result = new MList();
        boolean open = false;
        boolean double_tf = false;
        String field = "";
        int p = offset;
        while (p < text.length()) {
            boolean latest;
            char c = text.charAt(p);
            boolean bl = latest = p == text.length() - 1;
            if (c == separator_field) {
                if (double_tf) {
                    double_tf = false;
                    field = String.valueOf(field) + c;
                } else if (open) {
                    if (latest || text.charAt(p + 1) != separator_field) {
                        open = false;
                    } else {
                        double_tf = true;
                    }
                } else {
                    open = true;
                }
            } else if (!open && c == separator_column) {
                result.add((Object)field);
                field = "";
                if (latest) {
                    result.add((Object)"");
                }
            } else {
                if (!open && text.startsWith(separator_line, p)) {
                    if (field.length() > 0) {
                        result.add((Object)field);
                        field = "";
                    }
                    return new Group2((Object)((String[])result.toArray(String.class)), (Object)(p + separator_line.length()));
                }
                field = String.valueOf(field) + c;
            }
            ++p;
        }
        if (field.length() > 0) {
            result.add((Object)field);
        }
        return new Group2((Object)((String[])result.toArray(String.class)), (Object)text.length());
    }
}

