/*
 * Decompiled with CFR 0.152.
 */
package de.mn77.lib.crypt.digest;

import de.mn77.base.error.Err;
import de.mn77.base.sys.MOut;
import de.mn77.lib.crypt.Lib_Base64;
import de.mn77.lib.crypt.digest.JAVA_DIGEST;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class JavaDigest {
    private final JAVA_DIGEST vg;
    private final MessageDigest md;

    public JavaDigest(JAVA_DIGEST vg) {
        Err.ifNull((Object[])new Object[]{vg});
        this.vg = vg;
        try {
            this.md = MessageDigest.getInstance(this.vg.javaName);
        }
        catch (NoSuchAlgorithmException e) {
            throw Err.exit((Throwable)e);
        }
    }

    public byte[] calculate(byte[] text) {
        Err.ifNull((Object[])new Object[]{text});
        byte[] hash = this.md.digest(text);
        this.md.reset();
        return hash;
    }

    public void add(byte[] ba) {
        this.md.update(ba);
    }

    public void add(byte b) {
        this.md.update(b);
    }

    public void add(byte[] ba, int offset, int len) {
        this.md.update(ba, offset, len);
    }

    public byte[] calculate() {
        byte[] hash = this.md.digest();
        this.md.reset();
        return hash;
    }

    public String toString() {
        return new String(Lib_Base64.encode(this.calculate()));
    }

    public static void main(String[] args) {
        try {
            JavaDigest jc = new JavaDigest(JAVA_DIGEST.SHA1);
            byte[] h1 = jc.calculate("hello".getBytes());
            MOut.print((Object[])new Object[]{h1});
            MOut.print((Object[])new Object[]{new String(h1)});
            MOut.print((Object[])new Object[]{Lib_Base64.encode(h1)});
        }
        catch (Throwable t) {
            Err.exit((Throwable)t);
        }
    }
}

