/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.util;

import de.mn77.base.data.Lib_String;
import de.mn77.base.data.convert.ConvObject;
import de.mn77.base.data.form.FormString;
import de.mn77.base.data.struct.table.ArrayTable;
import de.mn77.base.error.I_ErrorDetails;
import org.jaymo_lang.error.ErrorBaseDebug;
import org.jaymo_lang.model.Call;
import org.jaymo_lang.runtime.CallRuntime;
import org.jaymo_lang.runtime.STYPE;
import org.jaymo_lang.util.Lib_Error;

public class ErrorComposer {
    private final String message;
    private final String group;
    private final ErrorBaseDebug ebd;
    private final Throwable ex;
    ArrayTable<Object> tab = new ArrayTable(3);
    private int maxFile = 0;
    private int maxLine = 0;
    private int maxLineNr = 0;

    public ErrorComposer(Throwable ex, CallRuntime cr) {
        this(ex, cr, null);
    }

    public ErrorComposer(Throwable ex, CallRuntime cr, String messageToUse) {
        this.ex = ex;
        this.message = messageToUse;
        this.ebd = ex instanceof ErrorBaseDebug ? (ErrorBaseDebug)ex : null;
        this.group = Lib_Error.errorTypeString(ex);
        this.iComposeTable(cr);
    }

    public String compose() {
        StringBuilder sb = new StringBuilder();
        sb.append("Error   : ");
        sb.append(this.group);
        sb.append("\nMessage : ");
        String usedMessage = this.message != null ? this.message : Lib_Error.collectMessages(this.ex);
        sb.append(usedMessage);
        sb.append('\n');
        if (this.ex instanceof I_ErrorDetails) {
            for (Object object : ((I_ErrorDetails)((Object)this.ex)).getDetails()) {
                if (!(this.ex instanceof ErrorBaseDebug)) {
                    sb.append("Detail  : ");
                }
                sb.append(ConvObject.toText(object));
                sb.append('\n');
            }
        }
        for (Object[] objectArray : this.tab) {
            sb.append("  ");
            sb.append('@');
            sb.append(' ');
            sb.append(FormString.width(this.maxFile, (String)this.iEmpty(objectArray[0]), false));
            sb.append(' ');
            if (objectArray[1] != null) {
                sb.append(':');
                String line = "" + objectArray[1];
                sb.append(line);
                sb.append(Lib_String.sequence(' ', (long)(this.maxLine - line.length())));
            }
            if (objectArray[2] != null) {
                sb.append("    ");
                sb.append(objectArray[2]);
            }
            sb.append('\n');
        }
        sb.setLength(sb.length() - 1);
        return sb.toString();
    }

    private void iAdd(String file, int rawLine, String s) {
        int lenFile = (file = (String)this.iEmpty(file)).length();
        if (lenFile > this.maxFile) {
            this.maxFile = lenFile;
        }
        if (rawLine > this.maxLineNr) {
            this.maxLineNr = rawLine;
        }
        this.tab.addRow((Object[])new Object[]{file, rawLine, s});
    }

    private void iComposeTable(CallRuntime cr) {
        Call last = null;
        Call first = null;
        if (this.ebd != null) {
            CallRuntime crv = this.ebd.getCallRuntime();
            while (crv != null) {
                if (crv.call != null && crv.call != last) {
                    Call c = crv.call;
                    if (first == null) {
                        first = c;
                    }
                    this.iAdd(c.debugInfo.getRawFile(), c.debugInfo.getRawLine(), c.toString(cr, STYPE.IDENT));
                    last = c;
                }
                crv = crv.parent;
            }
        }
        if (cr != null && cr.call != null) {
            String s;
            Call c = cr.call;
            if (!(last != null && c == last || first != null && c == first || (s = c.toString(cr, STYPE.IDENT)).length() <= 0)) {
                this.iAdd(c.debugInfo.getRawFile(), c.debugInfo.getRawLine(), s);
            }
        } else if (this.ebd != null) {
            String file = this.ebd.getFile();
            Integer line = this.ebd.getLine();
            if (file != null || line != null) {
                this.iAdd(file, line, null);
            }
        }
        this.maxLine = ("" + this.maxLineNr).length();
    }

    private Object iEmpty(Object o) {
        return o == null ? "" : o;
    }
}

