/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.runtime;

import de.mn77.base.data.group.Group2;
import de.mn77.base.error.Err;
import de.mn77.base.sys.Sys;
import org.jaymo_lang.error.CodeError;
import org.jaymo_lang.error.ReturnException;
import org.jaymo_lang.error.RuntimeError;
import org.jaymo_lang.model.App;
import org.jaymo_lang.model.Call;
import org.jaymo_lang.model.Function;
import org.jaymo_lang.model.I_AutoBlockDo;
import org.jaymo_lang.model.ObjectCallResult;
import org.jaymo_lang.model.Type;
import org.jaymo_lang.object.A_EventObject;
import org.jaymo_lang.object.A_Object;
import org.jaymo_lang.object.I_Object;
import org.jaymo_lang.object.atom.A_IntNumber;
import org.jaymo_lang.object.immute.A_Immutable;
import org.jaymo_lang.object.magic.var.MV_THIS;
import org.jaymo_lang.object.passthrough.Var;
import org.jaymo_lang.runtime.CallRuntime;
import org.jaymo_lang.runtime.STYPE;
import org.jaymo_lang.runtime.VarConstEnv;
import org.jaymo_lang.util.Lib_Convert;
import org.jaymo_lang.util.Lib_Error;
import org.jaymo_lang.util.Lib_Exec;

public class Instance
extends A_EventObject
implements I_AutoBlockDo {
    private final Type type;
    private final App app;
    private final Call[] args;
    private VarConstEnv main_env = null;
    private I_Object parent = null;
    private final CallRuntime parentCr;

    public Instance(CallRuntime cr, App app, Type type, Call[] args) {
        this.parentCr = cr;
        this.type = type;
        this.app = app;
        this.args = args;
    }

    @Override
    public void init(CallRuntime crOld) {
        CallRuntime crNew = new CallRuntime(this.parentCr, this, crOld.call);
        this.main_env = crNew.vce;
        I_Object[] argObjs = null;
        if (this.type.isControl()) {
            int parLen = this.type.getVars() == null ? 0 : this.type.getVars().length;
            argObjs = new I_Object[parLen];
            crNew.vce.initTypeSet(crOld, crNew);
        } else if (this.args != null) {
            argObjs = new I_Object[this.args.length];
            int i = 0;
            while (i < argObjs.length) {
                argObjs[i] = crOld.execInit(this.args[i], this);
                ++i;
            }
        } else {
            argObjs = new I_Object[]{};
        }
        this.type.getBlock().initTypeBlock(crOld, crNew, argObjs);
        this.parent = this.type.getParent();
        if (this.parent != null) {
            Call parentCall = new Call(crOld, this.parent);
            CallRuntime crParent = crNew.copyCall(parentCall, true);
            this.parent = crParent.exec(this, true);
        }
        I_Object test = this.parent;
        while (test != null && test instanceof A_EventObject) {
            Iterable<String> eventlist = this.type.getEvents().getList();
            if (eventlist != null) {
                for (String ev : eventlist) {
                    if (!((A_EventObject)test).validateEvent(crNew, String.valueOf('@') + ev)) continue;
                    throw new CodeError(crNew, "Invalid event-definition", "This event is already defined in a parent type: @" + ev);
                }
            }
            I_Object i_Object = test = test instanceof Instance ? ((Instance)test).internalGetParent() : null;
        }
        this.type.getBlock().execTypeBlock(crNew);
    }

    @Override
    protected ObjectCallResult callMethod(CallRuntime crOutside, String method) {
        switch (method) {
            case "_init": {
                return this.iInit(crOutside);
            }
            case "_sleep": {
                this.iSleep(crOutside);
                return A_Object.stdResult(this);
            }
        }
        if (!this.type.getFunctions().knows(method) && this.parent != null) {
            Call cParent = new Call(crOutside.getSurrBlock(), this.parent, method, crOutside.call.argCalls, crOutside.getDebugInfo());
            if (crOutside.call.hasBlock()) {
                cParent.setBlock(crOutside.call.getBlock());
            }
            CallRuntime crParent = new CallRuntime(crOutside, this, cParent, crOutside.vce);
            Var itVar = new Var("it");
            I_Object itValue = itVar.get(crOutside);
            itVar.let(crOutside, crParent, itValue);
            I_Object result = crParent.exec(this, true);
            return new ObjectCallResult(result, false);
        }
        CallRuntime crInside = crOutside.copyVCE(this, this.main_env, true);
        Function f = this.type.getFunctions().get(crInside, method);
        if (f.isPrivate() && !(crOutside.call.object instanceof MV_THIS)) {
            throw new RuntimeError(crOutside, "Invalid access to private function", "This function is only accessable within the type definition: " + f.getNames()[0]);
        }
        try {
            return new ObjectCallResult(f.getBlock().execFunction(crOutside, crInside, f), f.hasControl());
        }
        catch (ReturnException r) {
            Lib_Exec.checkExceptionIsEnd(crInside, r.get());
            return new ObjectCallResult(r.get().getResult(), f.hasControl());
        }
    }

    @Override
    protected final ObjectCallResult callEvent(CallRuntime cr, String event) {
        I_Object[] args = cr.argsFlex(this, 0, 1);
        cr.instance.eventRunRaw(cr, event, args.length == 1 ? args[0] : this);
        return new ObjectCallResult(this, false);
    }

    @Override
    public A_Immutable getConstant(CallRuntime cr, String name) {
        return this.type.getEnum(name, cr.getDebugInfo());
    }

    @Override
    public boolean validateEvent(CallRuntime cr, String event) {
        return this.type.getEvents().knows(event.substring(1));
    }

    private ObjectCallResult iInit(CallRuntime crOld) {
        Lib_Error.ifNotControl(crOld, this.type);
        Lib_Error.ifNotBetween(crOld, 0, 2, crOld.argCount(), "Arguments for _init");
        Group2<CallRuntime, CallRuntime> init = crOld.vce.initTypeGet();
        switch (crOld.argCount()) {
            case 0: {
                I_Object[] parObjs = null;
                if (this.args != null) {
                    parObjs = new I_Object[this.args.length];
                    int i = 0;
                    while (i < parObjs.length) {
                        parObjs[i] = ((CallRuntime)init.o1).execInit(this.args[i], this);
                        ++i;
                    }
                } else {
                    parObjs = new I_Object[]{};
                }
                this.type.getBlock().reInit((CallRuntime)init.o1, (CallRuntime)init.o2, parObjs);
                break;
            }
            case 1: {
                int parLen1 = this.type.getVars().length;
                if (parLen1 == 0) {
                    throw new RuntimeError(crOld, "Invalid call of _init", "This type has no parameters to initialize");
                }
                I_Object funcPars1 = crOld.args(this, A_IntNumber.class)[0];
                int parToInit1 = Lib_Convert.getIntValue(crOld, funcPars1);
                Lib_Error.ifArgs(parToInit1, 1, (Integer)parLen1, crOld, this);
                I_Object parObj1 = ((CallRuntime)init.o1).execInit(this.args[parToInit1 - 1], this);
                this.type.getBlock().reInit((CallRuntime)init.o1, (CallRuntime)init.o2, this.args.length, parToInit1, parObj1);
                break;
            }
            case 2: {
                int parLen2 = this.type.getVars().length;
                if (parLen2 == 0) {
                    throw new RuntimeError(crOld, "Invalid call of _init", "This type has no parameters to initialize");
                }
                I_Object[] funcPars2 = crOld.args(this, A_IntNumber.class, I_Object.class);
                int parToInit2 = Lib_Convert.getIntValue(crOld, funcPars2[0]);
                Lib_Error.ifArgs(parToInit2, 1, (Integer)parLen2, crOld, this);
                I_Object eachValue2 = funcPars2[1];
                I_Object parObj2 = ((CallRuntime)init.o1).execEachInit(this.args[parToInit2 - 1], this, eachValue2);
                this.type.getBlock().reInit((CallRuntime)init.o1, (CallRuntime)init.o2, this.args.length, parToInit2, parObj2);
            }
        }
        return new ObjectCallResult(this, false);
    }

    private void iSleep(CallRuntime cr) {
        I_Object[] oa = cr.argsFlex(this, 1, 4);
        int len = oa.length;
        int[] values = new int[len];
        int i = 0;
        while (i < len) {
            values[i] = Lib_Convert.getIntValue(cr, oa[i]);
            ++i;
        }
        int ms = 0;
        switch (len) {
            case 1: {
                ms = values[0];
                break;
            }
            case 2: {
                ms = values[0] * 1000 + values[1];
                break;
            }
            case 3: {
                ms = values[0] * 60000 + values[1] * 1000 + values[2];
                break;
            }
            case 4: {
                ms = values[0] * 3600000 + values[1] * 60000 + values[2] * 1000 + values[3];
            }
        }
        Sys.sleep(ms);
    }

    public App getApp() {
        return this.app == null ? (App)this : this.app;
    }

    public Type getType() {
        return this.type;
    }

    public VarConstEnv getMainEnv() {
        return this.main_env;
    }

    @Override
    public String toString() {
        return this.type.getName();
    }

    @Override
    public String toString(CallRuntime cr, STYPE type) {
        switch (type) {
            case REGULAR: 
            case NESTED: {
                if (this.type.getFunctions().knows("toStr")) {
                    Function f = this.getType().getFunctions().get(cr, "toStr");
                    CallRuntime cr2 = cr.copyNull();
                    I_Object result = f.getBlock().execOverwrite(cr2, this, f);
                    return Lib_Convert.getStringValue(cr, result);
                }
                return this.toString();
            }
            case IDENT: {
                if (this.type.getFunctions().knows("toIdent")) {
                    Function f = this.getType().getFunctions().get(cr, "toIdent");
                    CallRuntime cr2 = cr.copyNull();
                    I_Object result = f.getBlock().execOverwrite(cr2, this, f);
                    return Lib_Convert.getStringValue(cr, result);
                }
                return this.type.getName();
            }
            case DESCRIBE: {
                if (this.type.getFunctions().knows("toDescribe")) {
                    Function f = this.getType().getFunctions().get(cr, "toDescribe");
                    CallRuntime cr2 = cr.copyNull();
                    I_Object result = f.getBlock().execOverwrite(cr2, this, f);
                    return Lib_Convert.getStringValue(cr, result);
                }
                return this.type.getName();
            }
        }
        throw Err.impossible(new Object[]{type});
    }

    protected void setMainEnv(VarConstEnv vce) {
        if (this.main_env != null) {
            Err.forbidden("Is already set!");
        }
        this.main_env = vce;
    }

    @Override
    public I_Object autoBlockDo(CallRuntime cr) {
        if (this.type == null || this.type.getAutoBlockFunction() == null) {
            throw new RuntimeError(cr, "This type has no auto-block-function!", "Type: " + this.type.getName());
        }
        String newMethod = this.type.getAutoBlockFunction();
        Call call2 = new Call(cr.getSurrBlock(), this, newMethod, cr.call.argCalls, cr.getDebugInfo());
        if (cr.hasBlock()) {
            call2.setBlock(cr.getCallBlock());
        }
        if (cr.hasStream()) {
            call2.setStream(cr.getStream());
        }
        CallRuntime crNew = cr.copyCall(call2, false);
        return this.callMethod((CallRuntime)crNew, (String)newMethod).obj;
    }

    public I_Object internalGetParent() {
        return this.parent;
    }
}

