/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.object.immute;

import java.util.ArrayList;
import org.jaymo_lang.error.CodeError;
import org.jaymo_lang.model.ObjectCallResult;
import org.jaymo_lang.object.A_Object;
import org.jaymo_lang.object.I_Object;
import org.jaymo_lang.object.atom.A_Chars;
import org.jaymo_lang.object.atom.A_IntNumber;
import org.jaymo_lang.object.atom.A_Number;
import org.jaymo_lang.object.atom.I_Atomic;
import org.jaymo_lang.object.atom.I_Integer;
import org.jaymo_lang.object.atom.JMo_BigInt;
import org.jaymo_lang.object.atom.JMo_Long;
import org.jaymo_lang.object.atom.NOP1;
import org.jaymo_lang.object.atom.Str;
import org.jaymo_lang.object.immute.A_Immutable;
import org.jaymo_lang.object.struct.JMo_List;
import org.jaymo_lang.runtime.CallRuntime;
import org.jaymo_lang.runtime.STYPE;
import org.jaymo_lang.util.Lib_MagicVar;

public class Nil
extends A_Immutable {
    public static final Nil NIL = new Nil();
    private static final String IDENT = "nil";

    private Nil() {
    }

    @Override
    public void init(CallRuntime cr) {
    }

    @Override
    protected ObjectCallResult call2(CallRuntime cr, String method) {
        switch (method) {
            case "*": 
            case "mul": {
                return A_Object.stdResult(this.mMultiply(cr));
            }
            case "+": 
            case "add": {
                return A_Object.stdResult(this.mAdd(cr));
            }
        }
        Lib_MagicVar.checkForbiddenFuncs(cr, method);
        return null;
    }

    public static I_Object arithmetic(CallRuntime cr, NOP1 op, A_Number num) {
        if (op == NOP1.MUL) {
            if (!(num instanceof I_Integer)) {
                throw new CodeError(cr, "Invalid number for arithmetic Nil", "Only integer numbers are possible, but got: " + num.toString());
            }
            if (num instanceof JMo_Long || num instanceof JMo_BigInt) {
                throw new CodeError(cr, "Invalid number for arithmetic Nil", "Long and BigInt are not allowed here: " + num.toString());
            }
            int intValue = (Integer)num.getValue();
            ArrayList<I_Object> al = new ArrayList<I_Object>(intValue);
            int i = 0;
            while (i < intValue) {
                al.add(NIL);
                ++i;
            }
            return new JMo_List(al);
        }
        if (op == NOP1.ADD) {
            return num;
        }
        throw new CodeError(cr, "Invalid function for Nil", op.toString());
    }

    private I_Object mMultiply(CallRuntime cr) {
        A_IntNumber arg = (A_IntNumber)cr.args(this, A_IntNumber.class)[0];
        return Nil.arithmetic(cr, NOP1.MUL, arg);
    }

    private I_Object mAdd(CallRuntime cr) {
        I_Object arg = cr.args(this, I_Atomic.class)[0];
        return arg instanceof A_Chars ? new Str(IDENT + ((A_Chars)arg).getValue().toString()) : arg;
    }

    @Override
    public String toString(CallRuntime cr, STYPE type) {
        return IDENT;
    }

    @Override
    public boolean equals(Object other) {
        return other == NIL;
    }

    @Override
    public boolean equalsLazy(Object other) {
        return this.equals(other);
    }
}

