/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.object.atom;

import de.mn77.base.data.Lib_String;
import de.mn77.base.data.convert.ConvChar;
import de.mn77.base.data.form.FormNumber;
import de.mn77.base.data.numsys.Hex;
import de.mn77.base.error.Err;
import java.util.ArrayList;
import org.jaymo_lang.error.RuntimeError;
import org.jaymo_lang.model.COMPARE;
import org.jaymo_lang.model.ObjectCallResult;
import org.jaymo_lang.object.A_Object;
import org.jaymo_lang.object.I_Object;
import org.jaymo_lang.object.atom.A_Atomic;
import org.jaymo_lang.object.atom.A_Chars;
import org.jaymo_lang.object.atom.A_IntNumber;
import org.jaymo_lang.object.atom.Bool;
import org.jaymo_lang.object.atom.I_Atomic;
import org.jaymo_lang.object.atom.Int;
import org.jaymo_lang.object.atom.Str;
import org.jaymo_lang.object.immute.Nil;
import org.jaymo_lang.object.struct.JMo_List;
import org.jaymo_lang.runtime.CallRuntime;
import org.jaymo_lang.runtime.STYPE;
import org.jaymo_lang.util.ATOMIC;
import org.jaymo_lang.util.Lib_Convert;
import org.jaymo_lang.util.Lib_Sequence;

public class Char
extends A_Chars
implements I_Atomic {
    private final char value;

    public Char(char val) {
        this.value = val;
    }

    @Override
    public ATOMIC getEnum() {
        return ATOMIC.CHAR;
    }

    @Override
    protected ObjectCallResult call4(CallRuntime cr, String method) {
        switch (method) {
            case "++": 
            case "inc": {
                return A_Object.stdResult(this.mIncDec(cr, true));
            }
            case "--": 
            case "dec": {
                return A_Object.stdResult(this.mIncDec(cr, false));
            }
            case "/": 
            case "div": {
                throw new RuntimeError(cr, "One single character cannot be split.", "Dividing <Char>: " + this.toString(cr, STYPE.IDENT) + " / \u2026");
            }
            case "-": 
            case "sub": {
                throw new RuntimeError(cr, "Cannot subtract anything from a single character.", "Subtraction from <Char>: " + this.toString(cr, STYPE.IDENT) + " - \u2026");
            }
            case "ord": {
                return A_Object.stdResult(this.mOrd(cr));
            }
            case "alphabet": {
                return A_Object.stdResult(this.mAlphabet(cr));
            }
            case "toUnicode": 
            case "unicode": {
                return A_Object.stdResult(this.mUnicode(cr));
            }
            case "isLetter": {
                return A_Object.stdResult(Bool.getObject(Character.isLetter(this.value)));
            }
        }
        return null;
    }

    private I_Object mUnicode(CallRuntime cr) {
        cr.argsNone();
        return new Str(ConvChar.getUnicode(this.value));
    }

    @Override
    protected Char mCaseDown(CallRuntime cr) {
        cr.argsNone();
        return new Char(("" + this.value).toLowerCase().charAt(0));
    }

    @Override
    protected Char mCaseUp(CallRuntime cr) {
        cr.argsNone();
        return new Char(("" + this.value).toUpperCase().charAt(0));
    }

    @Override
    protected I_Object mCharAt(CallRuntime cr, boolean lazy) {
        int pos = Lib_Convert.getIntValue(cr, cr.args(this, A_IntNumber.class)[0]);
        if ((pos = Lib_Sequence.realPos(cr, pos, 1, lazy)) != 1) {
            return Nil.NIL;
        }
        return this;
    }

    @Override
    protected Char mChangeChar(CallRuntime cr) {
        I_Object[] oa = cr.args(this, A_IntNumber.class, A_Chars.class);
        int pos = Lib_Convert.getIntValue(cr, oa[0]);
        pos = Lib_Sequence.realPos(cr, pos, 1, false);
        I_Object o = oa[1];
        String n = Lib_Convert.getStringValue(cr, o);
        return new Char(n.charAt(0));
    }

    @Override
    public Integer compareTo3(I_Atomic o) {
        if (o instanceof Char) {
            return Character.valueOf(this.value).compareTo(((Char)o).getValue());
        }
        return null;
    }

    @Override
    public Character getValue() {
        return Character.valueOf(this.value);
    }

    @Override
    public String toString(CallRuntime cr, STYPE type) {
        if (type == STYPE.REGULAR) {
            return "" + this.value;
        }
        boolean quote = type != STYPE.NESTED;
        StringBuilder sb = new StringBuilder();
        if (quote) {
            sb.append('\'');
        }
        if (this.value > '\u001f' && this.value < '\ud800' || this.value == '\t' || this.value >= '\ue000') {
            sb.append(this.value);
        } else {
            sb.append("\\u");
            sb.append(FormNumber.width(4, Hex.toHex(this.value), false));
        }
        if (quote) {
            sb.append('\'');
        }
        return sb.toString();
    }

    @Override
    protected Bool mComparsion(CallRuntime cr, COMPARE m) {
        I_Object o = cr.args(this, A_Chars.class)[0];
        String arg = Lib_Convert.getStringValue(cr, o);
        String val = "" + this.value;
        switch (m) {
            case G: {
                return Bool.getObject(val.compareTo(arg) > 0);
            }
            case L: {
                return Bool.getObject(val.compareTo(arg) < 0);
            }
            case GE: {
                return Bool.getObject(val.compareTo(arg) >= 0);
            }
            case LE: {
                return Bool.getObject(val.compareTo(arg) <= 0);
            }
        }
        throw Err.impossible(new Object[]{m});
    }

    @Override
    protected Str mAdd(CallRuntime cr) {
        I_Object[] args = cr.argsVar(this, 1, 0);
        String result = "" + this.value;
        I_Object[] i_ObjectArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            I_Object arg = i_ObjectArray[n2];
            String par2 = Lib_Convert.getStringValue(cr, arg);
            result = String.valueOf(result) + par2;
            ++n2;
        }
        return new Str(result);
    }

    private Char mIncDec(CallRuntime cr, boolean inc) {
        I_Object[] oa = cr.argsFlex(this, 0, 1);
        if (oa.length == 0) {
            return new Char((char)(inc ? this.value + '\u0001' : this.value - '\u0001'));
        }
        I_Atomic o = (I_Atomic)cr.argType(oa[0], I_Atomic.class);
        int arg = Lib_Convert.getIntValue(cr, o);
        char val = this.value;
        int res = inc ? val + arg : val - arg;
        return new Char((char)res);
    }

    @Override
    protected Str mMultiply(CallRuntime cr) {
        I_Object arg = cr.args(this, A_IntNumber.class)[0];
        int i = Lib_Convert.getIntValue(cr, arg);
        String s = Lib_String.sequence(this.value, (long)i);
        return new Str(s);
    }

    @Override
    protected JMo_List mSelect(CallRuntime cr, boolean lazy) {
        I_Object[] args = cr.argsVar(this, 0, 0);
        ArrayList<I_Object> list = new ArrayList<I_Object>();
        I_Object[] i_ObjectArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            I_Object arg = i_ObjectArray[n2];
            int pos = Lib_Convert.getIntValue(cr, cr.argType(arg, A_IntNumber.class));
            pos = Lib_Sequence.realPos(cr, pos, 1, lazy);
            if (lazy && (pos < 1 || pos > 1)) {
                list.add(Nil.NIL);
            } else {
                list.add(new Char(this.value));
            }
            ++n2;
        }
        return new JMo_List(list);
    }

    @Override
    protected final Str mUpdate(CallRuntime cr, boolean lazy) {
        I_Object[] oa = cr.argsVar(this, 1, 1);
        I_Object obj = cr.argType(oa[0], null);
        char c = Lib_Convert.getCharValue(cr, obj);
        StringBuilder sb = new StringBuilder();
        sb.append(this.value);
        int i = 1;
        while (i < oa.length) {
            int pos1 = Lib_Convert.getIntValue(cr, cr.argType(oa[i], A_IntNumber.class));
            int pos2 = Lib_Sequence.realPos(cr, pos1, sb.length(), lazy);
            if (pos2 < 0 && lazy) {
                pos2 = pos1;
                while (pos2 > sb.length()) {
                    sb.append(' ');
                }
            }
            sb.setCharAt(pos2 - 1, c);
            ++i;
        }
        return new Str(sb.toString());
    }

    @Override
    protected final boolean charsIsNumber() {
        return Character.isDigit(this.value);
    }

    @Override
    protected final boolean charsIsCaseUp() {
        return Character.isUpperCase(this.value);
    }

    @Override
    protected final boolean charsIsCaseDown() {
        return Character.isLowerCase(this.value);
    }

    @Override
    protected final boolean charsIsBlank() {
        return this.value == ' ' || this.value == '\t' || Character.isWhitespace(this.value);
    }

    @Override
    protected A_Atomic getMinValue(CallRuntime cr) {
        return new Char('\u0000');
    }

    @Override
    protected A_Atomic getMaxValue(CallRuntime cr) {
        return new Char('\uffff');
    }

    private Int mOrd(CallRuntime cr) {
        cr.argsNone();
        char ord = this.value;
        return new Int(ord);
    }

    private Int mAlphabet(CallRuntime cr) {
        cr.argsNone();
        char ord = this.value;
        if (ord >= 'A' && ord <= 'Z') {
            return new Int(ord - 64);
        }
        if (ord >= 'a' && ord <= 'z') {
            return new Int(ord - 96);
        }
        return new Int(-1);
    }
}

