/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.object.atom;

import de.mn77.base.data.group.Group2;
import org.jaymo_lang.error.RuntimeError;
import org.jaymo_lang.model.COMPARE;
import org.jaymo_lang.model.ObjectCallResult;
import org.jaymo_lang.object.A_Object;
import org.jaymo_lang.object.I_Object;
import org.jaymo_lang.object.atom.Bool;
import org.jaymo_lang.object.atom.I_Atomic;
import org.jaymo_lang.object.atom.Int;
import org.jaymo_lang.object.atom.Str;
import org.jaymo_lang.object.immute.A_Immutable;
import org.jaymo_lang.object.immute.JMo_KeyValue;
import org.jaymo_lang.object.immute.Nil;
import org.jaymo_lang.object.sys.JMo_Java;
import org.jaymo_lang.runtime.CallRuntime;
import org.jaymo_lang.util.ATOMIC;
import org.jaymo_lang.util.Lib_AtomConv;
import org.jaymo_lang.util.Lib_Convert;
import org.jaymo_lang.util.Lib_StrFormat;

public abstract class A_Atomic
extends A_Immutable
implements I_Atomic {
    @Override
    public final void init(CallRuntime cr) {
    }

    @Override
    public A_Immutable getConstant(CallRuntime cr, String name) {
        switch (name) {
            case "MAX_VALUE": {
                return this.getMaxValue(cr);
            }
            case "MIN_VALUE": {
                return this.getMinValue(cr);
            }
        }
        return null;
    }

    @Override
    protected final ObjectCallResult call2(CallRuntime cr, String method) {
        switch (method) {
            case "length": 
            case "len": {
                cr.argsNone();
                return A_Object.stdResult(this.getLength(cr));
            }
            case "toBoolean": 
            case "toBool": {
                cr.argsNone();
                return A_Object.stdResult(Lib_AtomConv.convert(cr, this, ATOMIC.BOOL));
            }
            case "toChar": 
            case "toCharacter": {
                cr.argsNone();
                return A_Object.stdResult(Lib_AtomConv.convert(cr, this, ATOMIC.CHAR));
            }
            case "toDecimal": 
            case "toDec": {
                cr.argsNone();
                return A_Object.stdResult(Lib_AtomConv.convert(cr, this, ATOMIC.DEC));
            }
            case "toInt": 
            case "toInteger": {
                cr.argsNone();
                return A_Object.stdResult(Lib_AtomConv.convert(cr, this, ATOMIC.INT));
            }
            case "format": {
                return A_Object.stdResult(this.mFormat(cr));
            }
            case "toByte": {
                cr.argsNone();
                return A_Object.stdResult(Lib_AtomConv.convert(cr, this, ATOMIC.BYTE));
            }
            case "toShort": {
                cr.argsNone();
                return A_Object.stdResult(Lib_AtomConv.convert(cr, this, ATOMIC.SHORT));
            }
            case "toLong": {
                cr.argsNone();
                return A_Object.stdResult(Lib_AtomConv.convert(cr, this, ATOMIC.LONG));
            }
            case "toFloat": {
                cr.argsNone();
                return A_Object.stdResult(Lib_AtomConv.convert(cr, this, ATOMIC.FLOAT));
            }
            case "toJava": {
                return A_Object.stdResult(this.mToJava(cr));
            }
            case "isLess": 
            case "<": {
                return A_Object.stdResult(this.mComparsion(cr, COMPARE.L));
            }
            case "isGreater": 
            case ">": {
                return A_Object.stdResult(this.mComparsion(cr, COMPARE.G));
            }
            case "<=": 
            case "isLessOrEqual": {
                return A_Object.stdResult(this.mComparsion(cr, COMPARE.LE));
            }
            case "isGreaterOrEqual": 
            case ">=": {
                return A_Object.stdResult(this.mComparsion(cr, COMPARE.GE));
            }
            case "->": 
            case "toKeyValue": {
                return A_Object.stdResult(this.mToKeyValue(cr));
            }
        }
        return this.call3(cr, method);
    }

    protected abstract A_Atomic getMinValue(CallRuntime var1);

    protected abstract A_Atomic getMaxValue(CallRuntime var1);

    protected final RuntimeError newErrorMinMaxValue(CallRuntime cr) {
        return new RuntimeError(cr, "Utopian value", "The requested value requires too much memory.");
    }

    private I_Object mToKeyValue(CallRuntime cr) {
        I_Object o = cr.args(this, I_Object.class)[0];
        return new JMo_KeyValue(this, o);
    }

    protected abstract ObjectCallResult call3(CallRuntime var1, String var2);

    protected abstract Int getLength(CallRuntime var1);

    private JMo_Java mToJava(CallRuntime cr) {
        cr.argsNone();
        return new JMo_Java(this.getValue());
    }

    private Str mFormat(CallRuntime cr) {
        I_Object arg = cr.args(this, Str.class)[0];
        String format = Lib_Convert.getStringValue(cr, arg);
        int pos = 0;
        StringBuilder sb = new StringBuilder();
        while (pos < format.length()) {
            Group2<Boolean, String> part = Lib_StrFormat.getNext(format, pos);
            pos += ((String)part.o2).length();
            if (!((Boolean)part.o1).booleanValue()) {
                sb.append((String)part.o2);
                continue;
            }
            sb.append(Lib_StrFormat.format(cr, (String)part.o2, this));
        }
        return new Str(sb.toString());
    }

    @Override
    public boolean equalsStrict(Object arg) {
        if (arg == Nil.NIL || !(arg instanceof I_Atomic)) {
            return false;
        }
        arg = ((I_Atomic)arg).getValue();
        Object cur = this.getValue();
        if (arg.getClass() != cur.getClass()) {
            return false;
        }
        if (cur instanceof Double && Double.isNaN((Double)cur) && arg instanceof Double && Double.isNaN((Double)arg)) {
            return true;
        }
        return cur.equals(arg);
    }

    @Override
    public boolean equals(Object arg) {
        Object cur;
        if (arg == Nil.NIL) {
            return false;
        }
        if (arg instanceof I_Atomic) {
            arg = ((I_Atomic)arg).getValue();
        }
        if ((cur = this) instanceof I_Atomic) {
            cur = ((I_Atomic)cur).getValue();
        }
        if (cur instanceof Number && arg instanceof Number) {
            if (cur instanceof Double && Double.isNaN((Double)cur) && arg instanceof Double && Double.isNaN((Double)arg)) {
                return true;
            }
            return ((Number)cur).doubleValue() == ((Number)arg).doubleValue();
        }
        if ((cur instanceof Character || cur instanceof String) && (arg instanceof Character || arg instanceof String)) {
            return cur.toString().equals(arg.toString());
        }
        return cur.equals(arg);
    }

    @Override
    public boolean equalsLazy(Object objPar) {
        String strCurLower;
        Object objCur;
        if (objPar == Nil.NIL) {
            return false;
        }
        if (objPar instanceof I_Atomic) {
            objPar = ((I_Atomic)objPar).getValue();
        }
        if (objPar.equals(objCur = this.getValue())) {
            return true;
        }
        if ((objPar instanceof Boolean || objPar instanceof Number) && (objCur instanceof Boolean || objCur instanceof Number)) {
            Number numCur;
            Number numPar;
            Number number = objPar instanceof Boolean ? (Number)((Boolean)objPar != false ? 1 : 0) : (Number)(numPar = (Number)objPar);
            Number number2 = objCur instanceof Boolean ? (Number)((Boolean)objCur != false ? 1 : 0) : (Number)(numCur = (Number)objCur);
            if (objCur instanceof Double && Double.isNaN((Double)objCur) && objPar instanceof Double && Double.isNaN((Double)objPar)) {
                return true;
            }
            return numCur.doubleValue() == numPar.doubleValue();
        }
        String strPar = objPar.toString();
        String strCur = objCur.toString();
        String strParLower = strPar.toLowerCase();
        if (strParLower.equals("true")) {
            strPar = "1";
        }
        if (strParLower.equals("false")) {
            strPar = "0";
        }
        if ((strCurLower = strCur.toLowerCase()).equals("true")) {
            strCur = "1";
        }
        if (strCurLower.equals("false")) {
            strCur = "0";
        }
        if (strCur.endsWith(".0")) {
            strCur = strCur.substring(0, strCur.length() - 2);
        }
        if (strPar.endsWith(".0")) {
            strPar = strPar.substring(0, strPar.length() - 2);
        }
        return strPar.equals(strCur);
    }

    protected abstract Bool mComparsion(CallRuntime var1, COMPARE var2);

    @Override
    public final Integer compareTo2(I_Object o) {
        if (!(o instanceof I_Atomic)) {
            return null;
        }
        Integer result = this.compareTo3((I_Atomic)o);
        return result != null ? result : null;
    }

    protected abstract Integer compareTo3(I_Atomic var1);
}

