/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.object;

import de.mn77.base.data.Lib_Random;
import de.mn77.base.data.form.FormString;
import de.mn77.base.thread.A_Thread;
import java.util.ArrayList;
import org.jaymo_lang.error.AssertError;
import org.jaymo_lang.error.CodeError;
import org.jaymo_lang.error.ReturnException;
import org.jaymo_lang.error.RuntimeError;
import org.jaymo_lang.model.Block;
import org.jaymo_lang.model.Call;
import org.jaymo_lang.model.I_AutoBlockDo;
import org.jaymo_lang.model.ObjectCallResult;
import org.jaymo_lang.object.I_Object;
import org.jaymo_lang.object.I_ObjectToString;
import org.jaymo_lang.object.LoopHandle;
import org.jaymo_lang.object.atom.Bool;
import org.jaymo_lang.object.atom.I_Atomic;
import org.jaymo_lang.object.atom.Int;
import org.jaymo_lang.object.atom.Str;
import org.jaymo_lang.object.immute.A_Immutable;
import org.jaymo_lang.object.immute.JMo_Type;
import org.jaymo_lang.object.immute.Nil;
import org.jaymo_lang.object.passthrough.Const;
import org.jaymo_lang.object.passthrough.I_PassThrough;
import org.jaymo_lang.object.passthrough.Var;
import org.jaymo_lang.object.pseudo.A_MemLet;
import org.jaymo_lang.object.pseudo.ConstLet;
import org.jaymo_lang.object.pseudo.FuncLet;
import org.jaymo_lang.object.pseudo.JMo_Error;
import org.jaymo_lang.object.pseudo.Return;
import org.jaymo_lang.object.pseudo.VarLet;
import org.jaymo_lang.object.struct.JMo_List;
import org.jaymo_lang.object.sys.JMo_Cmd;
import org.jaymo_lang.object.sys.JMo_Java;
import org.jaymo_lang.runtime.CallRuntime;
import org.jaymo_lang.runtime.STYPE;
import org.jaymo_lang.util.Lib_Convert;
import org.jaymo_lang.util.Lib_Enum;
import org.jaymo_lang.util.Lib_Error;
import org.jaymo_lang.util.Lib_Exec;
import org.jaymo_lang.util.Lib_Output;
import org.jaymo_lang.util.Lib_Try;
import org.jaymo_lang.util.Lib_Type;

public abstract class A_Object
implements I_Object {
    private boolean init = false;

    @Override
    public void initOnce(CallRuntime cr) {
        if (this.init) {
            return;
        }
        this.init = true;
        this.init(cr);
    }

    public abstract void init(CallRuntime var1);

    public void setAlreadyInit() {
        this.init = true;
    }

    @Override
    public final ObjectCallResult call(CallRuntime cr) {
        String method = cr.call.method;
        if (method == null && this instanceof I_Atomic) {
            return new ObjectCallResult(this, false);
        }
        char c0 = method.charAt(0);
        if (c0 <= 'Z' && c0 >= 'A' && !(this instanceof JMo_Java)) {
            if (Lib_Enum.isEnum(method)) {
                A_Immutable result = Lib_Convert.getValue(cr, this).getConstant(cr, method);
                if (result == null) {
                    throw new CodeError(cr, "Unknown constant", "Constant/Enum is not defined in <" + Lib_Convert.getValue(cr, this).getTypeName() + ">: " + method);
                }
                return new ObjectCallResult(result, false);
            }
            throw new CodeError(cr, "Misplaced new object", "Maybe missing comma before: '" + method + "'");
        }
        boolean pass = this instanceof I_PassThrough;
        ObjectCallResult result = null;
        if (pass) {
            result = this.call2(cr, method);
        } else {
            result = this.iCall(cr, method);
            if (result == null && cr.getStrict().isValid_AutoProperty() && c0 >= 'a' && c0 <= 'z') {
                if (cr.argCount() == 0) {
                    String methodGet = "get" + Character.toUpperCase(c0) + method.substring(1);
                    result = this.iCall(cr, methodGet);
                } else {
                    String methodSet = "set" + Character.toUpperCase(c0) + method.substring(1);
                    result = this.iCall(cr, methodSet);
                }
            }
        }
        if (result == null || result.obj == null) {
            String typename = this instanceof JMo_Java ? this.toString() : this.getType(cr).toString();
            throw new CodeError(cr, "Unknown function", String.valueOf(typename) + "." + method);
        }
        result.obj.initOnce(cr);
        return result;
    }

    @Override
    public A_Immutable getConstant(CallRuntime cr, String name) {
        return null;
    }

    private ObjectCallResult iCall(CallRuntime cr, String method) {
        switch (method) {
            case "\\\\": 
            case "doPassMem": {
                return this.mPassMem(cr, true);
            }
            case "isEqually": 
            case "equally": 
            case "compares": 
            case "==~": {
                return A_Object.stdResult(this.mIsEqual(cr, COMPARSION.LAZY, false));
            }
            case "equals": 
            case "==": 
            case "isEqual": {
                return A_Object.stdResult(this.mIsEqual(cr, COMPARSION.NORMAL, false));
            }
            case "isSame": 
            case "===": 
            case "same": {
                return A_Object.stdResult(this.mIsEqual(cr, COMPARSION.STRICT, false));
            }
            case "diffly": 
            case "isDiffly": 
            case "!=~": {
                return A_Object.stdResult(this.mIsEqual(cr, COMPARSION.LAZY, true));
            }
            case "isDifferent": 
            case "!=": 
            case "<>": 
            case "differs": {
                return A_Object.stdResult(this.mIsEqual(cr, COMPARSION.NORMAL, true));
            }
            case "!==": 
            case "other": 
            case "isOther": {
                return A_Object.stdResult(this.mIsEqual(cr, COMPARSION.STRICT, true));
            }
            case "compareTo": 
            case "compare": {
                return A_Object.stdResult(this.mCompareTo(cr));
            }
            case "type": {
                cr.argsNone();
                return A_Object.stdResult(this.getType(cr));
            }
            case "types": {
                return A_Object.stdResult(this.mTypes(cr));
            }
            case "isType": 
            case "inherits": {
                return A_Object.stdResult(this.mInheritsType(cr));
            }
            case "assertType": {
                return A_Object.stdResult(this.mAssertType(cr));
            }
            case "assert": 
            case "assertIf": {
                return A_Object.stdResult(this.mAssertIf(cr));
            }
            case "assertIs": {
                return A_Object.stdResult(this.mAssertIs(cr));
            }
            case "isError": {
                return A_Object.stdResult(this.mIsError(cr));
            }
            case "isNil": {
                return A_Object.stdResult(this.mIsNil(cr));
            }
            case "isNotNil": {
                return A_Object.stdResult(this.mIsNotNil(cr));
            }
            case "replaceNil": {
                return A_Object.stdResult(this.mReplaceNil(cr));
            }
            case "ifExec": {
                return A_Object.stdResult(this.mIfExec(cr));
            }
            case "ifNil": {
                return this.mIfNil(cr, false);
            }
            case "ifNotNil": {
                return this.mIfNil(cr, true);
            }
            case "use": {
                return this.mUse(cr);
            }
            case "nilUse": {
                return this.mNilUse(cr);
            }
            case "typeUse": {
                return this.mTypeUse(cr);
            }
            case "which": {
                return A_Object.stdResult(this.mWhich(cr));
            }
            case "toStr": {
                return A_Object.stdResult(this.mToStr(cr));
            }
            case "toIdent": {
                return A_Object.stdResult(this.mToStrIdent(cr));
            }
            case "toDescribe": {
                return A_Object.stdResult(this.mToStrDescribe(cr));
            }
            case "print": {
                return A_Object.stdResult(this.mPrint(cr, true));
            }
            case "echo": {
                return A_Object.stdResult(this.mPrint(cr, false));
            }
            case "debug": {
                return A_Object.stdResult(this.mDebug(cr));
            }
            case "printErr": {
                return A_Object.stdResult(this.mPrintErr(cr, true));
            }
            case "echoErr": {
                return A_Object.stdResult(this.mPrintErr(cr, false));
            }
            case "ident": {
                this.mIdent(cr);
                return A_Object.stdResult(this);
            }
            case "describe": {
                this.mDescribe(cr);
                return A_Object.stdResult(this);
            }
            case "while": {
                return this.mWhile(cr, method);
            }
            case "repeat": {
                return this.mRepeat(cr, method);
            }
            case "proc": {
                return A_Object.stdResult(this.mProcTee(cr, false));
            }
            case "tee": {
                return A_Object.stdResult(this.mProcTee(cr, true));
            }
            case "pass": {
                return new ObjectCallResult(this.mPass(cr), true);
            }
            case "if": {
                return this.mDoIf(cr, false, false, false);
            }
            case "ifNot": {
                return this.mDoIf(cr, true, false, false);
            }
            case "at": 
            case "is": {
                return this.mDoIf(cr, false, false, true);
            }
            case "atNot": 
            case "isNot": {
                return this.mDoIf(cr, true, false, true);
            }
            case "passIf": {
                return this.mDoIf(cr, false, true, false);
            }
            case "passIfNot": {
                return this.mDoIf(cr, true, true, false);
            }
            case "passAt": 
            case "passIs": {
                return this.mDoIf(cr, false, true, true);
            }
            case "passAtNot": 
            case "passIsNot": {
                return this.mDoIf(cr, true, true, true);
            }
            case "breakAt": 
            case "breakIs": {
                return this.mBreakAt(cr, false);
            }
            case "breakAtNot": 
            case "breakIsNot": {
                return this.mBreakAt(cr, true);
            }
            case "breakIf": {
                return this.mBreakIf(cr, false);
            }
            case "breakIfNot": {
                return this.mBreakIf(cr, true);
            }
            case "pipeToCmdLive": {
                return this.mPipe(cr, PIPE_TYPE.LIVE);
            }
            case "pipeToCmd": {
                return this.mPipe(cr, PIPE_TYPE.PIPE);
            }
            case "pipeToCmdBuffer": {
                return this.mPipe(cr, PIPE_TYPE.BUFFER);
            }
            case "try": {
                return Lib_Try.mErrTry(cr, this);
            }
            case "tryUse": {
                return Lib_Try.mErrTryUse(cr, this);
            }
            case "catch": {
                return this.mErrCatch(cr);
            }
            case "tryLazy": {
                return Lib_Try.mTryLazy(cr, this);
            }
            case "mem": {
                return this.mMem(cr);
            }
            case "convertMem": {
                return this.mConvertMem(cr);
            }
            case "toVarLet": 
            case "toVarlet": {
                return A_Object.stdResult(this.mToVarLet(cr));
            }
            case "sync": {
                return this.mSync(cr);
            }
            case "async": {
                return this.mAsync(cr);
            }
            case "\u00b6": {
                return this.mEndMultiCall(cr);
            }
            case "%=>": 
            case "*=>": 
            case "+=>": 
            case "-=>": 
            case "/=>": {
                return this.mCalcLetRight(cr, method);
            }
            case "=>": {
                return this.mLetRight(cr, false);
            }
            case "~=>": {
                return this.mLetRight(cr, true);
            }
        }
        return this.call2(cr, method);
    }

    protected abstract ObjectCallResult call2(CallRuntime var1, String var2);

    public I_Object mPrint(CallRuntime cr, boolean newline) {
        I_Object[] args = cr.argsFlex(this, 0, 1);
        if (args != null && args.length == 1) {
            Lib_Output.out(cr, args[0], newline);
        } else {
            Lib_Output.out(cr, this, newline);
        }
        return this;
    }

    private ObjectCallResult mPassMem(CallRuntime cr, boolean useAutoBlockFunction) {
        I_Object[] args = cr.argsFlex(this, 0, 1);
        if (args.length == 1) {
            I_Object vc = cr.argType(args[0], A_MemLet.class);
            if (vc instanceof VarLet) {
                cr.call.setBlockStore(((VarLet)vc).getVar());
            } else {
                cr.call.setBlockStore(((ConstLet)vc).getConst());
            }
        }
        if (useAutoBlockFunction) {
            cr.getStrict().checkAutoBlock(cr);
            if (!(this instanceof I_AutoBlockDo)) {
                throw new RuntimeError(cr, "This object has no auto-block-function!", "Object: " + this.toString());
            }
        }
        I_Object doResult = useAutoBlockFunction ? ((I_AutoBlockDo)((Object)this)).autoBlockDo(cr) : Lib_Exec.execBlockStream(cr.copyPass(), this);
        return new ObjectCallResult(doResult, true);
    }

    public I_Object mDebug(CallRuntime cr) {
        if (!cr.getApp().isDebug()) {
            return this;
        }
        I_Object[] args = cr.argsVar(this, 0, 0);
        StringBuilder sb = new StringBuilder();
        I_Object file = cr.getDebugInfo().getFile();
        if (file != Nil.NIL) {
            sb.append(file.toString());
        }
        sb.append(":");
        sb.append(cr.getDebugInfo().getLine().toString());
        sb.append(" | ");
        sb.append(Lib_Type.toIdentWithType(cr, this));
        if (args != null && args.length > 0) {
            sb.append(" | ");
            boolean first = true;
            I_Object[] i_ObjectArray = args;
            int n = args.length;
            int n2 = 0;
            while (n2 < n) {
                I_Object arg = i_ObjectArray[n2];
                if (!first) {
                    sb.append(",");
                }
                sb.append(arg.toString());
                first = false;
                ++n2;
            }
        }
        Lib_Output.out(cr.getApp(), sb.toString().trim(), true);
        return this;
    }

    private final Int mCompareTo(CallRuntime cr) {
        I_Object arg = cr.args(this, I_Object.class)[0];
        int result = this.compareTo(cr, arg);
        if (result > 1) {
            result = 1;
        }
        if (result < -1) {
            result = -1;
        }
        return new Int(result);
    }

    @Override
    public final int compareTo(CallRuntime cr, I_Object o) {
        if (o.hashCode() == this.hashCode() || this.equals(o)) {
            return 0;
        }
        Integer result = this.compareTo2(o);
        if (result == null) {
            throw new RuntimeError(cr, "Not comparable", String.valueOf(this.toString()) + " <---> " + o.toString());
        }
        return result;
    }

    protected Integer compareTo2(I_Object o) {
        return null;
    }

    @Override
    public final JMo_Type getType(CallRuntime cr) {
        Class<?> cl = this.getClass();
        String name = Lib_Type.getName(cl, this);
        return new JMo_Type(name, cr);
    }

    @Override
    public final String getTypeName() {
        Class<?> cl = this.getClass();
        return Lib_Type.getName(cl, this);
    }

    @Override
    public final String[] getTypeNames() {
        return Lib_Type.getTypeNames(this);
    }

    public static ObjectCallResult stdResult(I_Object result) {
        return new ObjectCallResult(result, false);
    }

    private I_Object mIsEqual(CallRuntime cr, COMPARSION comparsion, boolean not) {
        boolean result;
        I_Object arg = cr.args(this, I_Object.class)[0];
        boolean bl = comparsion == COMPARSION.NORMAL ? this.equals(arg) : (result = comparsion == COMPARSION.LAZY ? this.equalsLazy(arg) : this.equalsStrict(arg));
        if (not) {
            result = !result;
        }
        return Bool.getObject(result);
    }

    @Override
    public boolean equalsLazy(Object obj) {
        return this.equals(obj);
    }

    @Override
    public boolean equalsStrict(Object obj) {
        return this == obj;
    }

    private ObjectCallResult mAsync(final CallRuntime cr) {
        cr.getStrict().checkSandbox(cr, ".async");
        cr.argsNone();
        final A_Object this2 = this;
        cr.getApp().registerFork();
        A_Thread t = new A_Thread(){

            @Override
            public void task() {
                try {
                    try {
                        Lib_Exec.execBlockStream(cr, this2);
                    }
                    catch (Throwable t) {
                        Lib_Error.handleThreadErrorEnd(cr, t);
                        cr.getApp().checkExit(true);
                    }
                }
                finally {
                    cr.getApp().checkExit(true);
                }
            }
        };
        t.start();
        return new ObjectCallResult(Nil.NIL, true);
    }

    private ObjectCallResult mEndMultiCall(CallRuntime cr) {
        Int multiCallKey = (Int)cr.args(this, Int.class)[0];
        cr.vce.useMultiCall().add(multiCallKey.getValue(), this);
        return new ObjectCallResult(this, true);
    }

    private ObjectCallResult mErrCatch(CallRuntime cr) {
        cr.argsNone();
        Call stream = cr.getStream();
        Block block = cr.getCallBlock();
        I_Object result = this;
        if (this instanceof JMo_Error) {
            if (block != null) {
                try {
                    result = block.exec(cr, result);
                }
                catch (ReturnException e) {
                    return new ObjectCallResult(e.get(), true);
                }
            }
            if (stream != null) {
                result = cr.execInit(stream, result);
            }
        }
        return new ObjectCallResult(result, true);
    }

    private Str mToStr(CallRuntime cr) {
        cr.argsNone();
        return new Str(this.toString(cr, STYPE.REGULAR));
    }

    @Override
    public String toString() {
        return this.getTypeName();
    }

    @Override
    public String toString(CallRuntime cr, STYPE type) {
        return this.getTypeName();
    }

    private Str mToStrIdent(CallRuntime cr) {
        cr.argsNone();
        return new Str(this.toString(cr, STYPE.IDENT));
    }

    private Str mToStrDescribe(CallRuntime cr) {
        cr.argsNone();
        return new Str(this.toString(cr, STYPE.DESCRIBE));
    }

    private final void mIdent(CallRuntime cr) {
        cr.argsNone();
        String s = this.toString(cr, STYPE.IDENT);
        Lib_Output.out(cr.getApp(), s, true);
    }

    private final void mDescribe(CallRuntime cr) {
        cr.argsNone();
        String s = this.toString(cr, STYPE.DESCRIBE);
        Lib_Output.out(cr.getApp(), s, true);
    }

    private I_Object mReplaceNil(CallRuntime cr) {
        I_Object o = cr.args(this, I_Object.class)[0];
        return this == Nil.NIL ? o : this;
    }

    private Bool mIsNil(CallRuntime cr) {
        cr.argsNone();
        return Bool.getObject(this == Nil.NIL);
    }

    private Bool mIsError(CallRuntime cr) {
        cr.argsNone();
        return Bool.getObject(this instanceof JMo_Error);
    }

    private Bool mIsNotNil(CallRuntime cr) {
        cr.argsNone();
        return Bool.getObject(this != Nil.NIL);
    }

    private ObjectCallResult mIfNil(CallRuntime cr, boolean not) {
        boolean check;
        cr.argsNone();
        Call stream = cr.getStream();
        Block block = cr.getCallBlock();
        if (stream == null && block == null) {
            return new ObjectCallResult(this, true);
        }
        boolean bl = check = this == Nil.NIL;
        if (not) {
            check = !check;
        }
        I_Object res = Bool.getObject(check);
        res = Lib_Exec.execIf(cr, check, res, false);
        return new ObjectCallResult(res, true);
    }

    private ObjectCallResult mUse(CallRuntime cr) {
        Lib_Error.ifArgs(cr.argCount(), 2, (Integer)3, cr, this);
        I_Object result = null;
        if (cr.argCount() == 3) {
            Bool b = (Bool)cr.argsOneAdvance(this, 0, Bool.class);
            boolean hit = Lib_Convert.getBoolValue(cr, b);
            result = cr.argsOneAdvance(this, hit ? 1 : 2, I_Object.class);
        } else {
            if (!Lib_Type.typeIs(cr, this, Bool.class)) {
                throw new RuntimeError(cr, "Invalid type of current object", "If current object isn't a 'Bool' value, use 3 arguments 'use(Bool, Object, Object)'");
            }
            result = ((Bool)this).getValue() != false ? cr.argsOneAdvance(this, 0, I_Object.class) : cr.argsOneAdvance(this, 1, I_Object.class);
        }
        CallRuntime crNew = cr.copyPass();
        result = Lib_Exec.execBlockStream(crNew, result);
        return new ObjectCallResult(result, true);
    }

    private ObjectCallResult mNilUse(CallRuntime cr) {
        Lib_Error.ifArgs(cr.argCount(), 2, (Integer)2, cr, this);
        I_Object result = cr.argsOneAdvance(this, this == Nil.NIL ? 0 : 1, I_Object.class);
        CallRuntime crNew = cr.copyPass();
        result = Lib_Exec.execBlockStream(crNew, result);
        return new ObjectCallResult(result, true);
    }

    private ObjectCallResult mTypeUse(CallRuntime cr) {
        Lib_Error.ifArgs(cr.argCount(), 3, (Integer)3, cr, this);
        I_Object typeNeeded = cr.argsOneAdvanceExt(this, 0, Str.class, JMo_Type.class);
        String typeNeeded2 = typeNeeded instanceof Str ? Lib_Convert.getStringValue(cr, typeNeeded) : ((JMo_Type)typeNeeded).getName();
        Lib_Type.checkValidity(typeNeeded2, cr);
        boolean hit = Lib_Type.isInstanceOf(this, typeNeeded2);
        I_Object result = cr.argsOneAdvance(this, hit ? 1 : 2, I_Object.class);
        CallRuntime crNew = cr.copyPass();
        result = Lib_Exec.execBlockStream(crNew, result);
        return new ObjectCallResult(result, true);
    }

    private I_Object mWhich(CallRuntime cr) {
        int parIdx = 0;
        while (parIdx < cr.argCount()) {
            Bool b1 = (Bool)cr.argsOneAdvance(this, parIdx, Bool.class);
            if (b1 == Bool.TRUE) {
                return new Int(parIdx + 1);
            }
            ++parIdx;
        }
        return Nil.NIL;
    }

    private I_Object mIfExec(CallRuntime cr) {
        if (this instanceof FuncLet) {
            return ((FuncLet)this).exec(cr);
        }
        return this;
    }

    private ObjectCallResult mConvertMem(CallRuntime cr) {
        I_Object[] args = cr.getArgs(this);
        if (args.length != 1) {
            throw new CodeError(cr, "Invalid amount of arguments", "Got " + args.length + " arguments, expected only one <Var>");
        }
        I_Object arg = cr.argType(args[0], VarLet.class);
        Var var = ((VarLet)arg).getVar();
        var.let(cr, cr, this, true);
        return new ObjectCallResult(var, false);
    }

    private ObjectCallResult mMem(CallRuntime cr) {
        I_Object[] args = cr.getArgs(this);
        if (args.length != 1) {
            throw new CodeError(cr, "Invalid amount of arguments", "Got " + args.length + " arguments, expected only one <Var>");
        }
        I_Object arg = cr.argType(args[0], A_MemLet.class);
        if (arg instanceof VarLet) {
            Var var = ((VarLet)arg).getVar();
            var.let(cr, cr, this, false);
            return new ObjectCallResult(this, false);
        }
        Const con = ((ConstLet)arg).getConst();
        con.set(cr, cr, this);
        return new ObjectCallResult(this, false);
    }

    private I_Object mProcTee(CallRuntime cr, boolean tee) {
        I_Object result = null;
        if (cr.argCount() == 2) {
            VarLet v = (VarLet)cr.argsOneAdvance(this, 0, VarLet.class);
            v.getVar().let(cr, cr, this);
            result = cr.argsOneAdvance(this, 1, I_Object.class);
        } else {
            result = cr.args(this, I_Object.class)[0];
        }
        if (result instanceof FuncLet) {
            result = ((FuncLet)result).eachExec(cr, this);
        }
        return tee ? this : result;
    }

    protected I_Object mPass(CallRuntime crOld) {
        crOld.argsNone();
        CallRuntime crNew = crOld.copyPass();
        return Lib_Exec.execBlockStream(crNew, this);
    }

    public ObjectCallResult mDoIf(CallRuntime cr, boolean not, boolean passToStream, boolean equals) {
        I_Object[] args = equals ? cr.argsVar(this, 1, 0) : cr.argsFlex(this, 0, 1);
        Call stream = cr.getStream();
        Block block = cr.getCallBlock();
        if (args != null && args.length == 0) {
            args = null;
        }
        if (args == null && stream == null && block == null) {
            return new ObjectCallResult(this, true);
        }
        boolean check = false;
        if (equals) {
            I_Object[] i_ObjectArray = args;
            int n = args.length;
            int n2 = 0;
            while (n2 < n) {
                I_Object arg = i_ObjectArray[n2];
                check = this.equals(arg);
                if (!check) {
                    ++n2;
                    continue;
                }
                break;
            }
        } else {
            I_Object base = this;
            if (args != null && args.length == 1) {
                base = cr.argType(args[0], Bool.class);
            } else if (!(this instanceof Bool)) {
                throw new RuntimeError(cr, "Invalid type of object for if-function", "Type must be <Bool>, but is: " + this.getType(cr).toString());
            }
            check = ((Bool)base).getValue();
        }
        if (not) {
            check = !check;
        }
        I_Object res = passToStream ? this : Bool.getObject(check);
        res = Lib_Exec.execIf(cr, check, res, passToStream);
        return new ObjectCallResult(res, true);
    }

    private ObjectCallResult mBreakAt(CallRuntime cr, boolean not) {
        I_Object arg;
        I_Object[] args = cr.argsVar(this, 1, 0);
        boolean valid = false;
        if (!not) {
            I_Object[] i_ObjectArray = args;
            int n = args.length;
            int n2 = 0;
            while (n2 < n) {
                arg = i_ObjectArray[n2];
                if (this.equals(arg)) {
                    Return rb = new Return(Return.LEVEL.BREAK, this);
                    return new ObjectCallResult(rb, true);
                }
                ++n2;
            }
            valid = true;
        } else {
            I_Object[] i_ObjectArray = args;
            int n = args.length;
            int n3 = 0;
            while (n3 < n) {
                arg = i_ObjectArray[n3];
                if (this.equals(arg)) {
                    valid = true;
                    break;
                }
                ++n3;
            }
        }
        if (valid) {
            I_Object result = Lib_Exec.execBlockStream(cr, this);
            return new ObjectCallResult(result, true);
        }
        Return rb = new Return(Return.LEVEL.BREAK, this);
        return new ObjectCallResult(rb, true);
    }

    private ObjectCallResult mBreakIf(CallRuntime cr, boolean not) {
        Bool arg = (Bool)cr.argsEach(this, 0, new I_Object[]{this}, Bool.class);
        if (not ? arg == Bool.FALSE : arg == Bool.TRUE) {
            Return rb = new Return(Return.LEVEL.BREAK, this);
            return new ObjectCallResult(rb, true);
        }
        I_Object result = Lib_Exec.execBlockStream(cr, this);
        return new ObjectCallResult(result, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ObjectCallResult mSync(CallRuntime cr) {
        cr.getStrict().checkSandbox(cr, ".sync");
        A_Object a_Object = this;
        synchronized (a_Object) {
            A_Object it;
            I_Object[] args = cr.argsFlex(this, 0, 1);
            Call stream = cr.getStream();
            Block block = cr.getCallBlock();
            int parlen = args.length;
            if (parlen == 0 && stream == null && block == null) {
                throw new CodeError(cr, "Invalid call", "No argument, no stream, no block, for 'times' ... what to do?");
            }
            I_Object res = this;
            I_Object i_Object = it = parlen == 0 ? this : args[0];
            if (block != null) {
                try {
                    res = block.exec(cr, it);
                }
                catch (ReturnException e) {
                    Return temp = e.get();
                    res = temp.getResult();
                    switch (temp.getLevel()) {
                        case BREAK: {
                            return temp.getLoopResult();
                        }
                    }
                    throw new CodeError(cr, "Invalid exit for block", "Got " + (Object)((Object)temp.getLevel()) + ", need " + (Object)((Object)Return.LEVEL.BREAK));
                }
            }
            if (stream != null) {
                res = cr.execInit(stream, it);
            }
            return new ObjectCallResult(res, true);
        }
    }

    private JMo_List mTypes(CallRuntime cr) {
        cr.argsNone();
        String[] types = Lib_Type.getTypeNames(this);
        ArrayList<I_Object> list = new ArrayList<I_Object>(types.length);
        String[] stringArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            String type = stringArray[n2];
            list.add(new JMo_Type(type, cr));
            ++n2;
        }
        return new JMo_List(list);
    }

    private Bool mInheritsType(CallRuntime cr) {
        I_Object arg = cr.argsExt(this, new Class[][]{{Str.class, JMo_Type.class}})[0];
        if (arg instanceof Str) {
            String s = Lib_Convert.getStringValue(cr, arg);
            Lib_Type.checkValidity(s, cr);
            return Bool.getObject(Lib_Type.isInstanceOf(this, s));
        }
        String s = ((JMo_Type)arg).getName();
        return Bool.getObject(Lib_Type.isInstanceOf(this, s));
    }

    private I_Object mAssertType(CallRuntime cr) {
        I_Object arg = cr.argsExt(this, new Class[][]{{Str.class, JMo_Type.class}})[0];
        String s = arg instanceof Str ? Lib_Convert.getStringValue(cr, arg) : ((JMo_Type)arg).getName();
        Lib_Type.checkValidity(s, cr);
        if (Lib_Type.isInstanceOf(this, s)) {
            return this;
        }
        throw new AssertError(cr, "Invalid type of current object!", "Type should be <" + s + ">, but is " + this.getType(cr).toString(cr, STYPE.REGULAR));
    }

    private I_Object mAssertIf(CallRuntime cr) {
        I_Object[] args = cr.argsFlex(this, 1, 2);
        boolean b = Lib_Convert.getBoolValue(cr, cr.argType(args[0], Bool.class));
        if (b) {
            return this;
        }
        String message = args.length == 2 ? Lib_Convert.getStringValue(cr, args[1]) : "Invalid assertion, current object is: " + this.toString();
        throw new AssertError(cr, "Assert-Error!", message);
    }

    private I_Object mAssertIs(CallRuntime cr) {
        I_ObjectToString[] args;
        I_ObjectToString[] i_ObjectToStringArray = args = cr.argsVar(this, 1, 0);
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            I_Object arg = i_ObjectToStringArray[n2];
            if (this.equals(arg)) {
                return this;
            }
            ++n2;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("Current object should be [");
        sb.append(Lib_Convert.toString(cr, false, ",", args));
        sb.append("] but is: ");
        sb.append(this.toString(cr, STYPE.REGULAR));
        throw new AssertError(cr, "Assert-Error!", sb.toString());
    }

    private I_Object mToVarLet(CallRuntime cr) {
        cr.argsNone();
        Var tmpVar = new Var("handle_" + Lib_Random.getString(10, true, true, true, ""));
        tmpVar.let(cr, cr, this);
        return new VarLet(tmpVar);
    }

    private ObjectCallResult mWhile(CallRuntime crOld, String method) {
        boolean varlet = false;
        if (crOld.argCount() == 0) {
            varlet = true;
            if (!(this instanceof VarLet)) {
                throw new RuntimeError(crOld, "Invalid condition for 'while'!", "Got no arguments and current object isn't a VarLet.");
            }
        }
        if (crOld.getStream() == null && crOld.getCallBlock() == null) {
            return new ObjectCallResult(this, true);
        }
        LoopHandle handle = new LoopHandle(this);
        CallRuntime crNew = crOld.copyLoop(handle);
        I_Object result = this;
        boolean b = false;
        I_Object check = Nil.NIL;
        check = varlet ? ((VarLet)this).getVar().get(crOld) : crOld.copyEach(method).argsEach(this, 0, new I_Object[]{result}, Bool.class);
        b = Lib_Convert.getBoolValue(crNew, check);
        while (b) {
            handle.startLap();
            result = Lib_Exec.execBlockStream(crNew, result);
            result = Lib_Exec.loopResult(result);
            if (result instanceof Return) {
                return ((Return)result).getLoopResult();
            }
            check = varlet ? ((VarLet)this).getVar().get(crOld) : crOld.copyEach(method).argsEach(this, 0, new I_Object[]{result}, Bool.class);
            b = Lib_Convert.getBoolValue(crNew, check);
        }
        return new ObjectCallResult(result, true);
    }

    private ObjectCallResult mRepeat(CallRuntime crOld, String method) {
        if (crOld.getStream() == null && crOld.getCallBlock() == null) {
            return new ObjectCallResult(this, true);
        }
        boolean varlet = false;
        if (crOld.argCount() == 0) {
            varlet = true;
            if (!(this instanceof VarLet)) {
                throw new RuntimeError(crOld, "Invalid condition for 'while'!", "Got no arguments and current object isn't a VarLet.");
            }
        }
        LoopHandle handle = new LoopHandle(this);
        CallRuntime crNew = crOld.copyLoop(handle);
        I_Object result = this;
        I_Object check = Nil.NIL;
        check = varlet ? ((VarLet)this).getVar().get(crOld) : crOld.copyEach(method).argsEach(this, 0, new I_Object[]{result}, Bool.class);
        boolean b = Lib_Convert.getBoolValue(crNew, check);
        do {
            handle.startLap();
            result = Lib_Exec.execBlockStream(crNew, result);
            result = Lib_Exec.loopResult(result);
            if (!(result instanceof Return)) continue;
            return ((Return)result).getLoopResult();
        } while (b = Lib_Convert.getBoolValue(crNew, check = varlet ? ((VarLet)this).getVar().get(crOld) : crOld.copyEach(method).argsEach(this, 0, new I_Object[]{result}, Bool.class)));
        return new ObjectCallResult(result, true);
    }

    private ObjectCallResult mCalcLetRight(CallRuntime cr, String method) {
        I_Object[] args = cr.getArgs(this);
        Lib_Error.ifArgs(cr.argCount(), 1, (Integer)1, cr, this);
        if (!(args[0] instanceof Var)) {
            cr.argType(args[0], Var.class);
        }
        Var v = (Var)args[0];
        method = method.substring(0, 2);
        Call thisCall = new Call(cr, this);
        Call callx = new Call(cr.getSurrBlock(), v, method, new Call[]{thisCall}, cr.getDebugInfo());
        CallRuntime cr2 = cr.copyCall(callx, false);
        I_Object newObject = v.call2((CallRuntime)cr2, (String)method).obj;
        CallRuntime crNew = cr.copyPass();
        I_Object result = Lib_Exec.execBlockStream(crNew, newObject);
        return new ObjectCallResult(result, true);
    }

    private ObjectCallResult mLetRight(CallRuntime cr, boolean convert) {
        CallRuntime crNew = cr.copyPass();
        CallRuntime crLet = cr.hasBlock() ? crNew : cr;
        I_Object[] args = cr.getArgs(this);
        Lib_Error.ifArgs(cr.argCount(), 1, (Integer)1, cr, this);
        I_Object arg = cr.argType(args[0], A_MemLet.class);
        A_Object newObject = null;
        if (arg instanceof VarLet) {
            Var v = ((VarLet)arg).getVar();
            v.let(crLet, crLet, this, convert);
            newObject = convert ? v.get(crLet) : this;
        } else {
            Const c = ((ConstLet)arg).getConst();
            c.set(crLet, crLet, this);
            newObject = this;
        }
        I_Object result = Lib_Exec.execBlockStream(crNew, newObject);
        return new ObjectCallResult(result, true);
    }

    private final I_Object mPrintErr(CallRuntime cr, boolean newline) {
        I_Object[] args = cr.argsFlex(this, 0, 1);
        if (args != null && args.length == 1) {
            Lib_Output.stdErr(cr, args[0], newline);
        } else {
            Lib_Output.stdErr(cr, this, newline);
        }
        return this;
    }

    private final ObjectCallResult mPipe(CallRuntime cr, PIPE_TYPE type) {
        I_Object arg = cr.args(this, Str.class)[0];
        String argStr = this.toString(cr, STYPE.REGULAR);
        String argQuoteStr = FormString.quote(argStr, '\"', '\\', false);
        String cmd = String.valueOf(Lib_Convert.getStringValue(cr, arg)) + ' ' + argQuoteStr;
        String cmdMet = type == PIPE_TYPE.LIVE ? "live" : (type == PIPE_TYPE.PIPE ? "pipe" : "buffer");
        Call cmdArgCall = new Call(cr, new Str(cmd));
        JMo_Cmd cmdObj = new JMo_Cmd(cmdArgCall);
        Call cmdCall = new Call(cr.getSurrBlock(), cmdObj, cmdMet, null, cr.getDebugInfo());
        CallRuntime cmdCR = cr.copyCall(cmdCall, false);
        I_Object result = cmdCR.exec(this, true);
        return new ObjectCallResult(result, false);
    }

    private static enum COMPARSION {
        STRICT,
        NORMAL,
        LAZY;

    }

    private static enum PIPE_TYPE {
        LIVE,
        PIPE,
        BUFFER;

    }
}

