/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.model;

import de.mn77.base.data.search.SearchArray;
import de.mn77.base.data.struct.sort.Sort;
import java.util.ArrayList;
import java.util.ServiceLoader;
import org.jaymo_lang.CoreTypes;
import org.jaymo_lang.api.JMo_Object;
import org.jaymo_lang.api.SandBox;
import org.jaymo_lang.api.TypeDictionary;
import org.jaymo_lang.error.CodeError;
import org.jaymo_lang.error.DebugInfo;
import org.jaymo_lang.error.ErrorBaseDebug;
import org.jaymo_lang.model.App;
import org.jaymo_lang.model.Block;
import org.jaymo_lang.model.Call;
import org.jaymo_lang.model.Type;
import org.jaymo_lang.object.A_Object;
import org.jaymo_lang.object.I_Object;
import org.jaymo_lang.object.atom.Str;
import org.jaymo_lang.object.pseudo.NonAtomic;
import org.jaymo_lang.object.pseudo.NonAtomicJava;
import org.jaymo_lang.object.pseudo.NonAtomicSelf;
import org.jaymo_lang.object.struct.JMo_List;
import org.jaymo_lang.runtime.CallRuntime;
import org.jaymo_lang.util.ATOMIC;
import org.jaymo_lang.util.BLOCKED;
import org.jaymo_lang.util.ClassFinder;
import org.jaymo_lang.util.Lib_Java;
import org.jaymo_lang.util.Lib_Prefix;

public class ObjectManager {
    private static final String JAVA_TYPE = "Java";
    private static final TypeDictionary coreTypes = new CoreTypes();

    public static I_Object createNew(App app, Block current, String name, Call[] args, DebugInfo debugInfo) {
        if (name.charAt(0) == 'J' && name.startsWith(JAVA_TYPE)) {
            int len = name.length();
            if (len == 4) {
                return ObjectManager.iJava(app, args, debugInfo);
            }
            if (len >= 5 && name.charAt(4) == '_') {
                String javaclass = null;
                javaclass = len >= 6 && name.charAt(5) == '{' ? Lib_Java.packConv_FullToClass(name) : Lib_Prefix.cutJava(name);
                Call[] args2 = new Call[]{new Call(current, new Str(javaclass), debugInfo), new Call(current, args == null ? new JMo_List() : new JMo_List(args), debugInfo)};
                return ObjectManager.iJava(app, args2, debugInfo);
            }
        }
        boolean nameWithPrefix = Lib_Prefix.isNameWithPrefix(name);
        return ObjectManager.createNew(app, name, nameWithPrefix, args, debugInfo);
    }

    private static I_Object createNew(App app, String name, boolean withPrefix, Call[] args, DebugInfo debugInfo) {
        Class<? extends A_Object> c;
        int n;
        if (!withPrefix) {
            String r;
            String[] stringArray = ATOMIC.LITERAL_TYPENAMES;
            n = ATOMIC.LITERAL_TYPENAMES.length;
            int n2 = 0;
            while (n2 < n) {
                r = stringArray[n2];
                if (name.equals(r)) {
                    throw ObjectManager.errorType(name, debugInfo);
                }
                ++n2;
            }
            stringArray = ATOMIC.ABSTRACT_TYPES;
            n = ATOMIC.ABSTRACT_TYPES.length;
            n2 = 0;
            while (n2 < n) {
                r = stringArray[n2];
                if (name.equals(r)) {
                    throw ObjectManager.errorType(name, debugInfo);
                }
                ++n2;
            }
        }
        if ((c = coreTypes.lookup(name)) != null) {
            return new NonAtomic(c, args);
        }
        String[] stringArray = BLOCKED.TYPE_NAME;
        int n3 = BLOCKED.TYPE_NAME.length;
        n = 0;
        while (n < n3) {
            String block = stringArray[n];
            if (block.equals(name)) {
                throw new CodeError("Invalid type", "Type is private or forbidden: " + name, debugInfo);
            }
            ++n;
        }
        Class<?> c2 = ObjectManager.searchJavaJMoClass(name);
        if (c2 != null) {
            if (I_Object.class.isAssignableFrom(c2)) {
                return new NonAtomic(c2, args);
            }
            if (JMo_Object.class.isAssignableFrom(c2)) {
                return new NonAtomic(SandBox.class, c2, args);
            }
            throw new CodeError("Invalid type hierarchy", "JayMo-Types must implements I_Object.class of JMo_Object.class: " + name, debugInfo);
        }
        Type t = app.getType().getType(name);
        if (t != null) {
            return new NonAtomicSelf(t, args);
        }
        throw new CodeError("Unknown type", name, debugInfo);
    }

    private static I_Object iJava(App app, Call[] args, DebugInfo debugInfo) {
        app.strict.checkSandbox(debugInfo, JAVA_TYPE);
        return new NonAtomicJava(args);
    }

    public static Class<?> searchJavaJMoClass(String search) {
        Class<? extends A_Object> result = coreTypes.lookup(search);
        if (result != null) {
            return result;
        }
        ServiceLoader<TypeDictionary> services = ServiceLoader.load(TypeDictionary.class);
        for (TypeDictionary service : services) {
            result = service.lookup(search);
            if (result == null) continue;
            return result;
        }
        return ClassFinder.getInstance().searchJMoClass("JMo_" + search);
    }

    private static ErrorBaseDebug errorType(String type, DebugInfo debugInfo) {
        return new CodeError("This type cannot be created via typename!", type, debugInfo);
    }

    public static boolean isTypeKnown(CallRuntime cr, String type) {
        int len;
        if (SearchArray.knows(ATOMIC.LITERAL_TYPENAMES, type, true) || SearchArray.knows(ATOMIC.ABSTRACT_TYPES, type, true)) {
            return true;
        }
        Type t = cr.getApp().getType().getType(type);
        if (t != null) {
            return true;
        }
        if (type.startsWith(JAVA_TYPE) && (len = type.length()) >= 5 && type.charAt(4) == '_') {
            Class<?> c3 = null;
            if (len >= 6 && type.charAt(5) == '{') {
                String javaType = Lib_Java.packConv_FullToClass(type);
                c3 = ClassFinder.getInstance().searchJavaClassPath(javaType);
            } else {
                String javaType = Lib_Prefix.cutJava(type);
                c3 = ClassFinder.getInstance().searchJavaClass(javaType);
            }
            if (c3 != null) {
                return true;
            }
        }
        return ObjectManager.searchJavaJMoClass(type) != null;
    }

    public static ArrayList<String> allTypes(CallRuntime cr) {
        String[] allTypes;
        ArrayList<String> result = new ArrayList<String>();
        String[] stringArray = ATOMIC.LITERAL_TYPENAMES;
        int n = ATOMIC.LITERAL_TYPENAMES.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            result.add(s);
            ++n2;
        }
        ArrayList<String> self = cr.getApp().getType().getAllTypeNames();
        result.addAll(self);
        String[] stringArray2 = allTypes = coreTypes.allTypes();
        int n3 = allTypes.length;
        int n4 = 0;
        while (n4 < n3) {
            String s = stringArray2[n4];
            result.add(s);
            ++n4;
        }
        ServiceLoader<TypeDictionary> services = ServiceLoader.load(TypeDictionary.class);
        for (TypeDictionary service : services) {
            String[] stringArray3 = allTypes = service.allTypes();
            int n5 = allTypes.length;
            int n6 = 0;
            while (n6 < n5) {
                String s = stringArray3[n6];
                result.add(s);
                ++n6;
            }
        }
        for (String s : ClassFinder.getInstance().allJMoClasses()) {
            result.add(s);
        }
        Sort.sort(result, false);
        int i = result.size() - 1;
        while (i >= 1) {
            if (result.get(i).equals(result.get(i - 1))) {
                result.remove(i);
            }
            --i;
        }
        return result;
    }
}

