/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.model;

import de.mn77.base.data.group.Group2;
import de.mn77.base.error.Err;
import org.jaymo_lang.error.DebugInfo;
import org.jaymo_lang.model.Block;
import org.jaymo_lang.object.A_ObjectToString;
import org.jaymo_lang.object.I_Object;
import org.jaymo_lang.object.passthrough.I_VarConst;
import org.jaymo_lang.runtime.CallRuntime;
import org.jaymo_lang.runtime.STYPE;
import org.jaymo_lang.util.Lib_Convert;
import org.jaymo_lang.util.Lib_Function;
import org.jaymo_lang.util.Lib_Output;
import org.jaymo_lang.util.Lib_Prio;

public class Call
extends A_ObjectToString {
    public final DebugInfo debugInfo;
    public final I_Object object;
    public final String method;
    public final byte prio;
    public final Call[] argCalls;
    public final Block surrounding;
    private Block ownBlock = null;
    private Call stream = null;
    private I_VarConst blockStore = null;

    public Call(CallRuntime cr, I_Object obj) {
        this(cr.getSurrBlock(), obj, null, null, cr.getDebugInfo());
    }

    public Call(Block surrBlock, I_Object obj, DebugInfo debugInfo) {
        this(surrBlock, obj, null, null, debugInfo);
    }

    public Call(Block surrBlock, I_Object obj, String met, Call[] args, DebugInfo debugInfo) {
        if (met != null && met.length() == 0) {
            Err.invalid(met);
        }
        Err.ifNull(surrBlock);
        this.surrounding = surrBlock;
        this.object = obj;
        this.method = met;
        this.argCalls = args;
        this.prio = (byte)(met == null || args != null && args.length != 1 ? 99 : (int)Lib_Prio.streamPrio(met, debugInfo));
        this.debugInfo = debugInfo;
    }

    public Call searchLastCall() {
        if (this.method != null && Lib_Function.isVarFunction(this.method) > -1 && this.argCalls != null && this.argCalls.length > 0) {
            return this.argCalls[0].searchLastCall();
        }
        if (this.stream == null) {
            return this;
        }
        return this.stream.searchLastCall();
    }

    public int getArgCount() {
        return this.argCalls == null ? 0 : this.argCalls.length;
    }

    public void setBlock(Block b) {
        Err.ifNull(b);
        if (this.ownBlock != null) {
            Err.invalid(this.ownBlock, b);
        }
        this.ownBlock = b;
    }

    public Block getBlock() {
        return this.ownBlock;
    }

    public void setStream(Call c) {
        Err.ifNull(c);
        if (this.stream != null) {
            throw Err.invalid(this.toString(), this.stream, c);
        }
        this.stream = c;
    }

    public Call getStream() {
        return this.stream;
    }

    public boolean hasBlock() {
        return this.ownBlock != null;
    }

    public boolean hasStream() {
        return this.stream != null;
    }

    public boolean hasObject() {
        return this.object != null;
    }

    @Override
    public String toString() {
        Group2<String, Boolean> g = Lib_Output.toObjectWithFunction(null, this.object, this.method, false, STYPE.IDENT);
        String p = Lib_Output.toString(this.argCalls);
        if (p.length() != 0) {
            p = (Boolean)g.o2 != false ? " " + p : "(" + p + ")";
        }
        String a = this.ownBlock != null || this.stream != null ? "\u2026" : "";
        return String.valueOf((String)g.o1) + p + a;
    }

    @Override
    public String toString(CallRuntime cr, STYPE type) {
        return this.toString(cr, type, false);
    }

    public String toStringReplace(CallRuntime cr, STYPE type) {
        return this.toString(cr, type, true);
    }

    public String toString(CallRuntime cr, STYPE type, boolean replace) {
        switch (type) {
            case REGULAR: 
            case NESTED: {
                return this.toString();
            }
            case IDENT: {
                return this.toStringIdent(cr, true, replace);
            }
            case DESCRIBE: {
                return this.toStringDescribe(cr, replace);
            }
        }
        throw Err.impossible(new Object[]{type});
    }

    private String toStringDescribe(CallRuntime cr, boolean replace) {
        StringBuilder sb = new StringBuilder();
        I_Object obj = this.object;
        if (replace && obj instanceof I_VarConst && ((I_VarConst)obj).isInitialized(cr)) {
            obj = Lib_Convert.getValue(cr, obj);
        }
        Group2<String, Boolean> g = Lib_Output.toObjectWithFunction(cr, obj, this.method, false, STYPE.DESCRIBE);
        String p = "";
        if (this.argCalls != null) {
            CharSequence[] argIdent = new String[this.argCalls.length];
            int i = 0;
            while (i < this.argCalls.length) {
                argIdent[i] = this.argCalls[i].toStringIdent(cr, true, replace);
                ++i;
            }
            p = String.join((CharSequence)",", argIdent);
        }
        if (p.length() != 0) {
            p = (Boolean)g.o2 != false ? " " + p : "(" + p + ")";
        }
        sb.append((String)g.o1);
        sb.append(p);
        if (this.ownBlock != null) {
            sb.append("{<Block>}");
        }
        if (this.stream != null) {
            String s = this.stream.toStringDescribe(cr, replace);
            sb.append(s);
        }
        Lib_Output.removeEnd(sb, '\n');
        return sb.toString();
    }

    private String toStringIdent(CallRuntime cr, boolean addBlockStreamChar, boolean replace) {
        I_Object obj = this.object;
        if (replace && obj instanceof I_VarConst && ((I_VarConst)obj).isInitialized(cr)) {
            obj = Lib_Convert.getValue(cr, obj);
        }
        Group2<String, Boolean> g = Lib_Output.toObjectWithFunction(cr, obj, this.method, false, STYPE.IDENT);
        String p = "";
        if (this.argCalls != null) {
            CharSequence[] argIdent = new String[this.argCalls.length];
            int i = 0;
            while (i < this.argCalls.length) {
                argIdent[i] = this.argCalls[i].toStringIdent(cr, true, replace);
                ++i;
            }
            p = String.join((CharSequence)",", argIdent);
        }
        if (p.length() != 0) {
            p = (Boolean)g.o2 != false ? " " + p : "(" + p + ")";
        }
        String bs = addBlockStreamChar && (this.ownBlock != null || this.stream != null) ? "\u2026" : "";
        return String.valueOf((String)g.o1) + p + bs;
    }

    public void setBlockStore(I_VarConst vc) {
        this.blockStore = vc;
    }

    public I_VarConst getBlockStore() {
        return this.blockStore;
    }

    public Call copy(I_Object obj, String method, Call[] args) {
        Call c2 = new Call(this.surrounding, obj, method, args, this.debugInfo);
        if (this.hasBlock()) {
            c2.setBlock(this.getBlock());
        }
        if (this.hasStream()) {
            c2.setStream(this.getStream());
        }
        if (this.blockStore != null) {
            c2.setBlockStore(this.blockStore);
        }
        return c2;
    }
}

