/*
 * Decompiled with CFR 0.152.
 */
package de.mn77.base.sys.file;

import de.mn77.base.error.Err;
import de.mn77.base.error.Err_FileSys;
import de.mn77.base.error.Err_Runtime;
import de.mn77.base.stream.Lib_Stream;
import de.mn77.base.sys.MOut;
import de.mn77.base.sys.file.MFile;
import de.mn77.base.sys.file.MFileSys;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import javax.swing.ImageIcon;

public class Lib_Jar {
    public static String getAbsolutePath(String jarPath) throws Err_FileSys {
        jarPath = Lib_Jar.iCheckLeadingSlash(jarPath, true);
        try {
            URL url = Lib_Jar.class.getResource(jarPath);
            if (url == null) {
                Err.fsAccess("File is missing", jarPath);
            }
            String decoded = URLDecoder.decode(url.getPath(), "UTF-8");
            return decoded;
        }
        catch (Err_FileSys e) {
            throw Lib_Jar.iError(e, jarPath);
        }
        catch (UnsupportedEncodingException e) {
            throw Err.exit(e);
        }
    }

    public static InputStream getStream(String jarPath) throws Err_FileSys {
        jarPath = Lib_Jar.iCheckLeadingSlash(jarPath, true);
        try {
            URL url = Lib_Jar.class.getResource(jarPath);
            if (url == null) {
                Err.fsAccess("File is missing", jarPath);
            }
            return Lib_Jar.class.getResourceAsStream(jarPath);
        }
        catch (Err_FileSys e) {
            throw Lib_Jar.iError(e, jarPath);
        }
    }

    public static File getFileCopy(String jarPath, String jarFilename, String jarSuffix) throws IOException, Err_FileSys {
        if (jarPath.endsWith("/")) {
            jarPath = jarPath.substring(0, jarPath.length() - 1);
        }
        InputStream is = Lib_Jar.getStream(String.valueOf(jarPath) + "/" + jarFilename + "." + jarSuffix);
        MFile tempFile = MFileSys.createTemp(jarFilename, jarSuffix);
        Lib_Stream.connect(is, tempFile.write(), false, true);
        return tempFile.getFile();
    }

    public static ImageIcon getImageIcon(String jarPath) {
        jarPath = Lib_Jar.iCheckLeadingSlash(jarPath, false);
        URL res = Lib_Jar.class.getClassLoader().getResource(jarPath);
        if (res == null) {
            throw new Err_Runtime("Image read error", jarPath);
        }
        return new ImageIcon(res);
    }

    private static String iCheckLeadingSlash(String jarPath, boolean leadingSlash) {
        boolean hasLeadingSlash;
        Err.ifEmpty(jarPath);
        boolean bl = hasLeadingSlash = jarPath.charAt(0) == '/';
        if (!hasLeadingSlash) {
            Err.invalid(jarPath, "Jar-Path must start with a '/'!");
        }
        return leadingSlash ? jarPath : jarPath.substring(1);
    }

    private static Err_FileSys iError(Err_FileSys e, String file) {
        MOut.print("File-Error: " + file);
        if (file.indexOf(47) < 0) {
            MOut.print("Maybe used '.' instead of '/' for pathseparator?!");
        }
        e.addDetail(file);
        return e;
    }
}

