/*
 * Decompiled with CFR 0.152.
 */
package de.mn77.base.data.bigcalc;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.IntStream;

public class BigRational
implements Comparable<BigRational> {
    public static final BigRational ONE = new BigRational(1);
    public static final BigRational TEN = new BigRational(10);
    public static final BigRational TWO = new BigRational(2);
    public static final BigRational ZERO = new BigRational(0);
    private static List<BigRational> bernoulliCache = new ArrayList<BigRational>();
    private final BigDecimal denominator;
    private final BigDecimal numerator;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BigRational bernoulli(int n) {
        if (n < 0) {
            throw new ArithmeticException("Illegal bernoulli(n) for n < 0: n = " + n);
        }
        if (n == 1) {
            return BigRational.valueOf(-1, 2);
        }
        if (n % 2 == 1) {
            return ZERO;
        }
        List<BigRational> list = bernoulliCache;
        synchronized (list) {
            int index = n / 2;
            if (bernoulliCache.size() <= index) {
                int i = bernoulliCache.size();
                while (i <= index) {
                    BigRational b = BigRational.calculateBernoulli(i * 2);
                    bernoulliCache.add(b);
                    ++i;
                }
            }
            return bernoulliCache.get(index);
        }
    }

    public static BigRational max(BigRational ... values) {
        if (values.length == 0) {
            return ZERO;
        }
        BigRational result = values[0];
        int i = 1;
        while (i < values.length) {
            result = result.max(values[i]);
            ++i;
        }
        return result;
    }

    public static BigRational min(BigRational ... values) {
        if (values.length == 0) {
            return ZERO;
        }
        BigRational result = values[0];
        int i = 1;
        while (i < values.length) {
            result = result.min(values[i]);
            ++i;
        }
        return result;
    }

    public static BigRational valueOf(BigDecimal value) {
        if (value.compareTo(BigDecimal.ZERO) == 0) {
            return ZERO;
        }
        if (value.compareTo(BigDecimal.ONE) == 0) {
            return ONE;
        }
        int scale = value.scale();
        if (scale == 0) {
            return new BigRational(value, BigDecimal.ONE);
        }
        if (scale < 0) {
            BigDecimal n = new BigDecimal(value.unscaledValue()).multiply(BigDecimal.ONE.movePointLeft(value.scale()));
            return new BigRational(n, BigDecimal.ONE);
        }
        BigDecimal n = new BigDecimal(value.unscaledValue());
        BigDecimal d = BigDecimal.ONE.movePointRight(value.scale());
        return new BigRational(n, d);
    }

    public static BigRational valueOf(BigDecimal numerator, BigDecimal denominator) {
        return BigRational.valueOf(numerator).divide(BigRational.valueOf(denominator));
    }

    public static BigRational valueOf(BigInteger value) {
        if (value.compareTo(BigInteger.ZERO) == 0) {
            return ZERO;
        }
        if (value.compareTo(BigInteger.ONE) == 0) {
            return ONE;
        }
        return BigRational.valueOf(value, BigInteger.ONE);
    }

    public static BigRational valueOf(BigInteger numerator, BigInteger denominator) {
        return BigRational.of(new BigDecimal(numerator), new BigDecimal(denominator));
    }

    public static BigRational valueOf(boolean positive, String integerPart, String fractionPart, String fractionRepeatPart, String exponentPart) {
        BigRational result = ZERO;
        if (fractionRepeatPart != null && fractionRepeatPart.length() > 0) {
            BigInteger lotsOfNines = BigInteger.TEN.pow(fractionRepeatPart.length()).subtract(BigInteger.ONE);
            result = BigRational.valueOf(new BigInteger(fractionRepeatPart), lotsOfNines);
        }
        if (fractionPart != null && fractionPart.length() > 0) {
            result = result.add(BigRational.valueOf(new BigInteger(fractionPart)));
            result = result.divide(BigInteger.TEN.pow(fractionPart.length()));
        }
        if (integerPart != null && integerPart.length() > 0) {
            result = result.add(new BigInteger(integerPart));
        }
        if (exponentPart != null && exponentPart.length() > 0) {
            int exponent = Integer.parseInt(exponentPart);
            BigInteger powerOfTen = BigInteger.TEN.pow(Math.abs(exponent));
            BigRational bigRational = result = exponent >= 0 ? result.multiply(powerOfTen) : result.divide(powerOfTen);
        }
        if (!positive) {
            result = result.negate();
        }
        return result;
    }

    public static BigRational valueOf(double value) {
        if (value == 0.0) {
            return ZERO;
        }
        if (value == 1.0) {
            return ONE;
        }
        if (Double.isInfinite(value)) {
            throw new NumberFormatException("Infinite");
        }
        if (Double.isNaN(value)) {
            throw new NumberFormatException("NaN");
        }
        return BigRational.valueOf(new BigDecimal(String.valueOf(value)));
    }

    public static BigRational valueOf(int value) {
        if (value == 0) {
            return ZERO;
        }
        if (value == 1) {
            return ONE;
        }
        return new BigRational(value);
    }

    public static BigRational valueOf(int numerator, int denominator) {
        return BigRational.of(BigDecimal.valueOf(numerator), BigDecimal.valueOf(denominator));
    }

    public static BigRational valueOf(int integer, int fractionNumerator, int fractionDenominator) {
        if (fractionNumerator < 0 || fractionDenominator < 0) {
            throw new ArithmeticException("Negative value");
        }
        BigRational integerPart = BigRational.valueOf(integer);
        BigRational fractionPart = BigRational.valueOf(fractionNumerator, fractionDenominator);
        return integerPart.isPositive() ? integerPart.add(fractionPart) : integerPart.subtract(fractionPart);
    }

    public static BigRational valueOf(String string) {
        String[] strings = string.split("/");
        BigRational result = BigRational.valueOfSimple(strings[0]);
        int i = 1;
        while (i < strings.length) {
            result = result.divide(BigRational.valueOfSimple(strings[i]));
            ++i;
        }
        return result;
    }

    private static BigRational calculateBernoulli(int n) {
        return IntStream.rangeClosed(0, n).parallel().mapToObj(k -> {
            BigRational jSum = ZERO;
            BigRational bin = ONE;
            int j = 0;
            while (j <= k) {
                BigRational jPowN = BigRational.valueOf(j).pow(n);
                jSum = j % 2 == 0 ? jSum.add(bin.multiply(jPowN)) : jSum.subtract(bin.multiply(jPowN));
                bin = bin.multiply(BigRational.valueOf(k - j).divide(BigRational.valueOf(j + 1)));
                ++j;
            }
            return jSum.divide(BigRational.valueOf(k + 1));
        }).reduce(ZERO, BigRational::add);
    }

    private static int countDigits(BigInteger number) {
        double factor = Math.log(2.0) / Math.log(10.0);
        int digitCount = (int)(factor * (double)number.bitLength() + 1.0);
        if (BigInteger.TEN.pow(digitCount - 1).compareTo(number) > 0) {
            return digitCount - 1;
        }
        return digitCount;
    }

    private static BigRational of(BigDecimal numerator, BigDecimal denominator) {
        if (numerator.signum() == 0 && denominator.signum() != 0) {
            return ZERO;
        }
        if (numerator.compareTo(BigDecimal.ONE) == 0 && denominator.compareTo(BigDecimal.ONE) == 0) {
            return ONE;
        }
        return new BigRational(numerator, denominator);
    }

    private static BigRational valueOfSimple(String string) {
        return BigRational.valueOf(new BigDecimal(string));
    }

    private BigRational(BigDecimal num, BigDecimal denom) {
        BigDecimal n = num;
        BigDecimal d = denom;
        if (d.signum() == 0) {
            throw new ArithmeticException("Divide by zero");
        }
        if (d.signum() < 0) {
            n = n.negate();
            d = d.negate();
        }
        this.numerator = n;
        this.denominator = d;
    }

    private BigRational(int value) {
        this(BigDecimal.valueOf(value), BigDecimal.ONE);
    }

    public BigRational abs() {
        return this.isPositive() ? this : this.negate();
    }

    public BigRational add(BigInteger value) {
        if (value.equals(BigInteger.ZERO)) {
            return this;
        }
        return this.add(new BigDecimal(value));
    }

    public BigRational add(BigRational value) {
        if (this.denominator.equals(value.denominator)) {
            return BigRational.of(this.numerator.add(value.numerator), this.denominator);
        }
        BigDecimal n = this.numerator.multiply(value.denominator).add(value.numerator.multiply(this.denominator));
        BigDecimal d = this.denominator.multiply(value.denominator);
        return BigRational.of(n, d);
    }

    public BigRational add(int value) {
        if (value == 0) {
            return this;
        }
        return this.add(BigInteger.valueOf(value));
    }

    @Override
    public int compareTo(BigRational other) {
        if (this == other) {
            return 0;
        }
        return this.numerator.multiply(other.denominator).compareTo(this.denominator.multiply(other.numerator));
    }

    public BigRational decrement() {
        return BigRational.of(this.numerator.subtract(this.denominator), this.denominator);
    }

    public BigRational divide(BigInteger value) {
        if (value.equals(BigInteger.ONE)) {
            return this;
        }
        return this.divide(new BigDecimal(value));
    }

    public BigRational divide(BigRational value) {
        if (value.equals(ONE)) {
            return this;
        }
        BigDecimal n = this.numerator.multiply(value.denominator);
        BigDecimal d = this.denominator.multiply(value.numerator);
        return BigRational.of(n, d);
    }

    public BigRational divide(int value) {
        return this.divide(BigInteger.valueOf(value));
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof BigRational)) {
            return false;
        }
        BigRational other = (BigRational)obj;
        if (!this.numerator.equals(other.numerator)) {
            return false;
        }
        return this.denominator.equals(other.denominator);
    }

    public BigRational fractionPart() {
        return BigRational.of(this.numerator.remainder(this.denominator), this.denominator);
    }

    public BigDecimal getDenominator() {
        return this.denominator;
    }

    public BigInteger getDenominatorBigInteger() {
        return this.denominator.toBigInteger();
    }

    public BigDecimal getNumerator() {
        return this.numerator;
    }

    public BigInteger getNumeratorBigInteger() {
        return this.numerator.toBigInteger();
    }

    public int hashCode() {
        if (this.isZero()) {
            return 0;
        }
        return this.numerator.hashCode() + this.denominator.hashCode();
    }

    public BigRational increment() {
        return BigRational.of(this.numerator.add(this.denominator), this.denominator);
    }

    public BigRational integerPart() {
        return BigRational.of(this.numerator.subtract(this.numerator.remainder(this.denominator)), this.denominator);
    }

    public boolean isInteger() {
        return this.isIntegerInternal() || this.reduce().isIntegerInternal();
    }

    public boolean isZero() {
        return this.numerator.signum() == 0;
    }

    public BigRational multiply(BigInteger value) {
        if (this.isZero() || value.signum() == 0) {
            return ZERO;
        }
        if (this.equals(ONE)) {
            return BigRational.valueOf(value);
        }
        if (value.equals(BigInteger.ONE)) {
            return this;
        }
        return this.multiply(new BigDecimal(value));
    }

    public BigRational multiply(BigRational value) {
        if (this.isZero() || value.isZero()) {
            return ZERO;
        }
        if (this.equals(ONE)) {
            return value;
        }
        if (value.equals(ONE)) {
            return this;
        }
        BigDecimal n = this.numerator.multiply(value.numerator);
        BigDecimal d = this.denominator.multiply(value.denominator);
        return BigRational.of(n, d);
    }

    public BigRational multiply(int value) {
        return this.multiply(BigInteger.valueOf(value));
    }

    public BigRational negate() {
        if (this.isZero()) {
            return this;
        }
        return BigRational.of(this.numerator.negate(), this.denominator);
    }

    public BigRational pow(int exponent) {
        BigInteger d;
        BigInteger n;
        if (exponent == 0) {
            return ONE;
        }
        if (exponent == 1) {
            return this;
        }
        if (exponent > 0) {
            n = this.numerator.toBigInteger().pow(exponent);
            d = this.denominator.toBigInteger().pow(exponent);
        } else {
            n = this.denominator.toBigInteger().pow(-exponent);
            d = this.numerator.toBigInteger().pow(-exponent);
        }
        return BigRational.valueOf(n, d);
    }

    public BigRational reciprocal() {
        return BigRational.of(this.denominator, this.numerator);
    }

    public BigRational reduce() {
        BigInteger n = this.numerator.toBigInteger();
        BigInteger d = this.denominator.toBigInteger();
        BigInteger gcd = n.gcd(d);
        n = n.divide(gcd);
        d = d.divide(gcd);
        return BigRational.valueOf(n, d);
    }

    public int signum() {
        return this.numerator.signum();
    }

    public BigRational subtract(BigInteger value) {
        if (value.equals(BigInteger.ZERO)) {
            return this;
        }
        return this.subtract(new BigDecimal(value));
    }

    public BigRational subtract(BigRational value) {
        if (this.denominator.equals(value.denominator)) {
            return BigRational.of(this.numerator.subtract(value.numerator), this.denominator);
        }
        BigDecimal n = this.numerator.multiply(value.denominator).subtract(value.numerator.multiply(this.denominator));
        BigDecimal d = this.denominator.multiply(value.denominator);
        return BigRational.of(n, d);
    }

    public BigRational subtract(int value) {
        if (value == 0) {
            return this;
        }
        return this.subtract(BigInteger.valueOf(value));
    }

    public BigDecimal toBigDecimal() {
        int precision = Math.max(this.precision(), MathContext.DECIMAL128.getPrecision());
        return this.toBigDecimal(new MathContext(precision));
    }

    public BigDecimal toBigDecimal(MathContext mc) {
        return this.numerator.divide(this.denominator, mc);
    }

    public double toDouble() {
        return this.numerator.doubleValue() / this.denominator.doubleValue();
    }

    public float toFloat() {
        return this.numerator.floatValue() / this.denominator.floatValue();
    }

    public String toIntegerRationalString() {
        BigDecimal fractionNumerator = this.numerator.remainder(this.denominator);
        BigDecimal integerNumerator = this.numerator.subtract(fractionNumerator);
        BigDecimal integerPart = integerNumerator.divide(this.denominator);
        StringBuilder result = new StringBuilder();
        if (integerPart.signum() != 0) {
            result.append(integerPart);
        }
        if (fractionNumerator.signum() != 0) {
            if (result.length() > 0) {
                result.append(' ');
            }
            result.append(fractionNumerator.abs());
            result.append('/');
            result.append(this.denominator);
        }
        if (result.length() == 0) {
            result.append('0');
        }
        return result.toString();
    }

    public String toPlainString() {
        if (this.isZero()) {
            return "0";
        }
        if (this.isIntegerInternal()) {
            return this.numerator.toPlainString();
        }
        return this.toBigDecimal().toPlainString();
    }

    public String toRationalString() {
        if (this.isZero()) {
            return "0";
        }
        if (this.isIntegerInternal()) {
            return this.numerator.toString();
        }
        return this.numerator + "/" + this.denominator;
    }

    public String toString() {
        if (this.isZero()) {
            return "0";
        }
        if (this.isIntegerInternal()) {
            return this.numerator.toString();
        }
        return this.toBigDecimal().toString();
    }

    public BigRational withPrecision(int precision) {
        return BigRational.valueOf(this.toBigDecimal(new MathContext(precision)));
    }

    public BigRational withScale(int scale) {
        return BigRational.valueOf(this.toBigDecimal().setScale(scale, RoundingMode.HALF_UP));
    }

    private BigRational add(BigDecimal value) {
        return BigRational.of(this.numerator.add(value.multiply(this.denominator)), this.denominator);
    }

    private BigRational divide(BigDecimal value) {
        BigDecimal n = this.numerator;
        BigDecimal d = this.denominator.multiply(value);
        return BigRational.of(n, d);
    }

    private boolean isIntegerInternal() {
        return this.denominator.compareTo(BigDecimal.ONE) == 0;
    }

    private boolean isPositive() {
        return this.numerator.signum() > 0;
    }

    private BigRational max(BigRational value) {
        return this.compareTo(value) >= 0 ? this : value;
    }

    private BigRational min(BigRational value) {
        return this.compareTo(value) <= 0 ? this : value;
    }

    private BigRational multiply(BigDecimal value) {
        BigDecimal n = this.numerator.multiply(value);
        BigDecimal d = this.denominator;
        return BigRational.of(n, d);
    }

    private int precision() {
        return BigRational.countDigits(this.numerator.toBigInteger()) + BigRational.countDigits(this.denominator.toBigInteger());
    }

    private BigRational subtract(BigDecimal value) {
        return BigRational.of(this.numerator.subtract(value.multiply(this.denominator)), this.denominator);
    }
}

