/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.util;

import de.mn77.base.error.Err;
import java.util.ArrayList;
import java.util.Collections;
import org.jaymo_lang.error.CodeError;
import org.jaymo_lang.error.DebugInfo;
import org.jaymo_lang.error.RuntimeError;
import org.jaymo_lang.model.App;
import org.jaymo_lang.model.Function;
import org.jaymo_lang.object.I_Object;
import org.jaymo_lang.object.I_ObjectToString;
import org.jaymo_lang.object.LoopHandle;
import org.jaymo_lang.object.magic.var.A_MagicVar;
import org.jaymo_lang.object.magic.var.MV_APP;
import org.jaymo_lang.object.magic.var.MV_JAYMO;
import org.jaymo_lang.object.passthrough.Const;
import org.jaymo_lang.object.passthrough.Var;
import org.jaymo_lang.object.pseudo.ConstLet;
import org.jaymo_lang.object.pseudo.VarLet;
import org.jaymo_lang.object.sys.JMo_Java;
import org.jaymo_lang.parser.Parser_Script;
import org.jaymo_lang.runtime.CallRuntime;
import org.jaymo_lang.runtime.Instance;
import org.jaymo_lang.runtime.STYPE;
import org.jaymo_lang.util.Lib_AtomConv;
import org.jaymo_lang.util.Lib_Convert;
import org.jaymo_lang.util.Lib_Java;
import org.jaymo_lang.util.Lib_Prefix;

public class Lib_Type {
    public static void checkValidity(String typeName, Parser_Script parser) {
        Lib_Type.checkTypeValidity(typeName, parser, null);
    }

    public static void checkValidity(String typeName, CallRuntime cr) {
        Lib_Type.checkTypeValidity(typeName, null, cr);
    }

    private static void checkTypeValidity(String typeName, Parser_Script parser, CallRuntime cr) {
        char cl;
        DebugInfo debug;
        boolean parsetime = parser != null;
        DebugInfo debugInfo = debug = parsetime ? parser.getDebugInfo() : cr.getDebugInfo();
        if (typeName.length() == 0) {
            Lib_Type.invalidTypename("Type can't be empty!", parsetime, cr, debug);
        }
        if ((cl = typeName.charAt(typeName.length() - 1)) == '_') {
            Lib_Type.invalidTypename("Type can't end with underline! Got: " + typeName, parsetime, cr, debug);
        }
        int underlines = 0;
        boolean nextCapital = true;
        boolean openSub = false;
        char[] cArray = typeName.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char cx = cArray[n2];
            if (cx == '{') {
                openSub = true;
                nextCapital = false;
            } else if (cx == '}') {
                openSub = false;
            } else {
                if (nextCapital) {
                    nextCapital = false;
                    if (cx == '_' && parser != null && parser.getCurrentPrefix() != null) {
                        nextCapital = true;
                    } else if (cx < 'A' || cx > 'Z') {
                        Lib_Type.invalidTypename("Type must start with a capital letter! Got: '" + typeName + "'", parsetime, cr, debug);
                    }
                }
                if (!(cx >= 'A' && cx <= 'Z' || cx >= 'a' && cx <= 'z' || cx >= '0' && cx <= '9' || openSub && (cx == '.' || cx == '$'))) {
                    if (cx == '_') {
                        ++underlines;
                        nextCapital = true;
                    } else {
                        Lib_Type.invalidTypename("Invalid char '" + cx + "'! Got: " + typeName, parsetime, cr, debug);
                    }
                }
            }
            ++n2;
        }
        if (underlines > 1) {
            Lib_Type.invalidTypename("Type can't have multiple underlines and namespaces: " + typeName, parsetime, cr, debug);
        }
    }

    private static void invalidTypename(String detail, boolean parsetime, CallRuntime cr, DebugInfo debug) {
        if (parsetime) {
            throw new CodeError("Invalid Type-Name!", detail, debug);
        }
        throw new RuntimeError(cr, "Invalid Type-Name!", detail);
    }

    public static Class<?> getType(CallRuntime cr, I_Object o) {
        o = Lib_Convert.getValue(cr, o);
        return o.getClass();
    }

    public static boolean typeIs(CallRuntime cr, I_Object o, Class<?> ... ta) {
        o = Lib_Convert.getValue(cr, o);
        Class<?> typ = o.getClass();
        Class<?>[] classArray = ta;
        int n = ta.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> t = classArray[n2];
            if (t.isAssignableFrom(typ)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static String getTypeString(I_Object obj) {
        return "<" + Lib_Type.getName(obj) + ">";
    }

    public static String getTypeString(Class<?> objClass, I_Object obj) {
        return "<" + Lib_Type.getName(objClass, obj) + ">";
    }

    public static String getName(I_Object obj) {
        return Lib_Type.getName(obj.getClass(), obj);
    }

    public static String getName(Class<?> objClass, I_ObjectToString obj) {
        Err.ifNull(objClass);
        if (objClass == App.class || objClass == MV_APP.class) {
            return "Root";
        }
        if (objClass == Function.class) {
            return "Function";
        }
        if (objClass == LoopHandle.class) {
            return "Loop";
        }
        if (objClass == Var.class) {
            return "Var";
        }
        if (objClass == Const.class) {
            return "Const";
        }
        if (objClass == VarLet.class) {
            return "VarLet";
        }
        if (objClass == ConstLet.class) {
            return "ConstLet";
        }
        if (obj != null && objClass == JMo_Java.class) {
            return ((JMo_Java)obj).getFullTypeName();
        }
        if (A_MagicVar.class.isAssignableFrom(objClass) || A_MagicVar.class.isAssignableFrom(objClass)) {
            Err.ifNull(obj);
            return ((A_MagicVar)obj).getID();
        }
        String s = objClass.getSimpleName();
        if (objClass == Instance.class) {
            String string = s = obj == null ? Instance.class.getSimpleName() : ((Instance)obj).getType().getName();
        }
        if (s.startsWith("JMo_")) {
            return s.substring(4);
        }
        if (s.startsWith("A_")) {
            return s.substring(2);
        }
        if (s.equals("I_Atomic")) {
            return "Atomic";
        }
        if (s.startsWith("I_")) {
            return s.substring(2);
        }
        return s;
    }

    public static String toIdentWithType(CallRuntime cr, I_Object obj) {
        I_Object objReal = Lib_Convert.getValue(cr, obj);
        StringBuilder sb = new StringBuilder();
        sb.append(Lib_Type.getTypeString(objReal));
        sb.append(' ');
        sb.append(objReal.toString(cr, STYPE.IDENT));
        return sb.toString();
    }

    public static boolean isInstanceOf(I_Object o, String type) {
        if (type.startsWith("Java_{")) {
            return o instanceof JMo_Java && ((JMo_Java)o).getFullTypeName().equals(type);
        }
        if (type.startsWith("Java_")) {
            return o instanceof JMo_Java && ((JMo_Java)o).getJavaClassName().equals(Lib_Prefix.cutJava(type));
        }
        String[] stringArray = Lib_Type.getTypeNames(o);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String t = stringArray[n2];
            if (t.equals(type)) {
                return true;
            }
            ++n2;
        }
        I_Object inst = o;
        while (inst != null && inst instanceof Instance) {
            I_Object parent = ((Instance)inst).internalGetParent();
            if (parent != null && Lib_Type.isInstanceOf(parent, type)) {
                return true;
            }
            inst = parent;
        }
        return false;
    }

    public static String typesToString(I_Object obj) {
        String[] types = Lib_Type.getTypeNames(obj);
        StringBuilder sb = new StringBuilder();
        if (types.length > 1) {
            sb.append("(");
        }
        int tc = 0;
        while (tc < types.length) {
            String typename = types[tc];
            if (tc != 0) {
                sb.append(", ");
            }
            sb.append(typename);
            ++tc;
        }
        if (types.length > 1) {
            sb.append(")");
        }
        return sb.toString();
    }

    public static final String[] getTypeNames(I_Object obj) {
        if (obj instanceof JMo_Java) {
            return Lib_Type.getJavaTypeNames((JMo_Java)obj);
        }
        if (obj instanceof MV_JAYMO) {
            return new String[]{"Object", "JayMo"};
        }
        if (obj instanceof MV_APP) {
            return new String[]{"Object", "App"};
        }
        ArrayList<Class<?>> list = Lib_Type.getTypeClassesList(obj);
        ArrayList<String> names = new ArrayList<String>();
        for (Class<?> cl : list) {
            String name = Lib_Type.getName(cl, obj);
            if (names.size() != 0 && name.equals(names.get(names.size() - 1))) continue;
            names.add(name);
        }
        int len = names.size();
        String[] result = new String[len];
        int i = 0;
        while (i < len) {
            result[len - 1 - i] = (String)names.get(i);
            ++i;
        }
        return result;
    }

    public static final Class<?>[] getTypeClasses(I_Object obj) {
        ArrayList<Class<?>> list = Lib_Type.getTypeClassesList(obj);
        int len = list.size();
        Class[] result = new Class[len];
        int i = 0;
        while (i < len) {
            result[len - 1 - i] = list.get(i);
            ++i;
        }
        return result;
    }

    public static final String[] getJavaTypeNames(JMo_Java javaObj) {
        Object obj = javaObj.getJavaInstance();
        ArrayList<String> list = new ArrayList<String>();
        Class<?> cl = obj.getClass();
        while (cl != null) {
            list.add(Lib_Java.packConv_classToFull(cl));
            cl = cl.getSuperclass();
        }
        list.add("Java");
        list.add("Object");
        Collections.reverse(list);
        return list.toArray(new String[list.size()]);
    }

    private static final ArrayList<Class<?>> getTypeClassesList(I_Object obj) {
        ArrayList list = new ArrayList();
        Class<?> cl = obj.getClass();
        while (cl != null && I_Object.class.isAssignableFrom(cl)) {
            list.add(cl);
            cl = cl.getSuperclass();
        }
        return list;
    }

    public static I_Object typeCheck(CallRuntime cr, I_Object obj, String objTypeName, String safedTypeName, String targetInfo) {
        I_Object objUpgraded;
        if (Lib_Type.isInstanceOf(obj, safedTypeName)) {
            return obj;
        }
        I_Object i_Object = objUpgraded = cr.getStrict().isValid_AtomicAutoUpgrade() ? Lib_AtomConv.autoUpgrade(cr, obj, objTypeName, safedTypeName) : null;
        if (objUpgraded != null) {
            return objUpgraded;
        }
        throw new RuntimeError(cr, "Invalid type for " + targetInfo, "Object must be <" + safedTypeName + ">, but got: " + Lib_Type.toIdentWithType(cr, obj));
    }
}

