/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.util;

import de.mn77.base.data.convert.ConvString;
import de.mn77.base.data.group.Group2;
import de.mn77.base.error.Err;
import de.mn77.base.error.Err_FileSys;
import de.mn77.base.sys.MOut;
import de.mn77.base.sys.file.I_File;
import de.mn77.base.sys.file.Lib_TextFile;
import java.util.ArrayList;
import org.jaymo_lang.model.App;
import org.jaymo_lang.model.Call;
import org.jaymo_lang.model.Function;
import org.jaymo_lang.object.I_Object;
import org.jaymo_lang.runtime.CallRuntime;
import org.jaymo_lang.runtime.Instance;
import org.jaymo_lang.runtime.STYPE;
import org.jaymo_lang.util.Lib_Convert;
import org.jaymo_lang.util.Lib_Function;
import org.jaymo_lang.util.Lib_Parser;
import org.jaymo_lang.util.Lib_Type;

public class Lib_Output {
    private static void iOutput(App app, String s, boolean error, boolean newline) {
        String st = s;
        if (app.writeOutput(s, newline)) {
            return;
        }
        I_File outFile = app.getOutputFile();
        if (outFile != null) {
            try {
                StringBuilder sb = new StringBuilder();
                if (error) {
                    sb.append("<Err>\n");
                }
                sb.append(s);
                if (newline) {
                    sb.append('\n');
                }
                if (error) {
                    sb.append("</Err>\n");
                }
                Lib_TextFile.append(outFile.getFile(), sb.toString(), true);
            }
            catch (Err_FileSys e) {
                Err.show(e);
            }
        } else if (newline) {
            if (app.terminalRawMode) {
                st = String.valueOf(st) + '\r';
            }
            if (error) {
                MOut.printErr(st);
            } else {
                MOut.print(st);
            }
        } else if (error) {
            MOut.echoErr(st);
        } else {
            MOut.echo(st);
        }
    }

    public static void out(App app, String s, boolean newline) {
        Lib_Output.iOutput(app, s, false, newline);
    }

    public static void out(CallRuntime cr, I_Object arg, boolean newline) {
        Lib_Output.iOutput(cr.getApp(), Lib_Output.iObjToString(cr, arg), false, newline);
    }

    public static void stdErr(CallRuntime cr, String s, boolean newline) {
        Lib_Output.iOutput(cr.getApp(), s, true, newline);
    }

    public static void stdErr(CallRuntime cr, I_Object o, boolean newline) {
        Lib_Output.iOutput(cr.getApp(), Lib_Output.iObjToString(cr, o), true, newline);
    }

    public static String toString(Call[] calls) {
        if (calls == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        Call[] callArray = calls;
        int n = calls.length;
        int n2 = 0;
        while (n2 < n) {
            Call s = callArray[n2];
            Lib_Output.iAdd_toString(sb, s);
            ++n2;
        }
        return sb.toString();
    }

    public static Group2<String, Boolean> toObjectWithFunction(CallRuntime cr, I_Object obj, String function, boolean showType, STYPE stype) {
        String o = "";
        if (obj != null) {
            o = showType ? Lib_Type.getTypeString(Lib_Convert.getValue(cr, obj)) : obj.toString(cr, stype);
        }
        boolean mathFunc = Lib_Function.isMathematicFunction(function);
        String m = function == null ? "" : String.valueOf(mathFunc ? " " : ".") + function;
        return new Group2<String, Boolean>(String.valueOf(o) + m, mathFunc);
    }

    public static String indentLines(String in, boolean isEndOfLine) {
        boolean multiline;
        boolean bl = multiline = in.indexOf(10) >= 0;
        if (!multiline) {
            return in;
        }
        ArrayList<String> lines = ConvString.toLines(in);
        String space = Lib_Parser.space(1);
        StringBuilder sb = new StringBuilder();
        if (multiline) {
            sb.append('\n');
        }
        for (String s : lines) {
            sb.append(space);
            sb.append(s);
            sb.append('\n');
        }
        if (isEndOfLine) {
            Lib_Output.removeEnd(sb, '\n');
        }
        return sb.toString();
    }

    public static String appShowPart(String title, String s) {
        StringBuilder sb = new StringBuilder();
        String space = Lib_Parser.space(1);
        ArrayList<String> lines = ConvString.toLines(s);
        if (title != null) {
            sb.append(String.valueOf(title) + '\n');
        }
        for (String s2 : lines) {
            if (s2.length() <= 0) continue;
            sb.append(space);
            sb.append(s2);
            sb.append('\n');
        }
        Lib_Output.removeEnd(sb, '\n');
        return sb.toString();
    }

    public static void removeEnd(StringBuilder sb, char c) {
        int len = sb.length();
        if (len > 0 && sb.charAt(len - 1) == c) {
            sb.setLength(len - 1);
        }
    }

    private static void iAdd_toString(StringBuilder sb, Object o) {
        if (o == null) {
            return;
        }
        if (sb.length() != 0) {
            sb.append(',');
        }
        sb.append(o.toString());
    }

    private static String iObjToString(CallRuntime cr, I_Object arg) {
        if (arg instanceof Instance && ((Instance)arg).getType().getFunctions().knows("toStr")) {
            Function f = ((Instance)arg).getType().getFunctions().get(cr, "toStr");
            I_Object result = f.getBlock().execOverwrite(cr, (Instance)arg, f);
            return Lib_Convert.getStringValue(cr, result);
        }
        return arg.toString(cr, STYPE.REGULAR);
    }
}

