/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.util;

import java.math.BigInteger;
import org.jaymo_lang.error.RuntimeError;
import org.jaymo_lang.runtime.CallRuntime;

public class Lib_ConvertExact {
    public static int doubleToInt(CallRuntime cr, double value) {
        if (value > 2.147483647E9) {
            throw new RuntimeError(cr, "Value too big", "Maximum for Int is 2147483647");
        }
        if (value < -2.147483648E9) {
            throw new RuntimeError(cr, "Value too small", "Minimum for Int is -2147483648");
        }
        return (int)Math.round(value);
    }

    public static long doubleToLong(CallRuntime cr, double value) {
        if (value > 9.223372036854776E18) {
            throw new RuntimeError(cr, "Value too big", "Maximum for Long is 9223372036854775807");
        }
        if (value < -9.223372036854776E18) {
            throw new RuntimeError(cr, "Value too small", "Minimum for Long is -9223372036854775808");
        }
        return Math.round(value);
    }

    public static byte longToByte(CallRuntime cr, long value) {
        if (value > 127L) {
            throw new RuntimeError(cr, "Value too big", "Maximum for Byte is 127");
        }
        if (value < -128L) {
            throw new RuntimeError(cr, "Value too small", "Minimum for Byte is -128");
        }
        return (byte)value;
    }

    public static short longToShort(CallRuntime cr, long value) {
        if (value > 32767L) {
            throw new RuntimeError(cr, "Value too big", "Maximum for Short is 32767");
        }
        if (value < -32768L) {
            throw new RuntimeError(cr, "Value too small", "Minimum for Short is -32768");
        }
        return (short)value;
    }

    public static int longToInt(CallRuntime cr, long value) {
        if (value > Integer.MAX_VALUE) {
            throw new RuntimeError(cr, "Value too big", "Maximum for Int is 2147483647");
        }
        if (value < Integer.MIN_VALUE) {
            throw new RuntimeError(cr, "Value too small", "Minimum for Int is -2147483648");
        }
        return (int)value;
    }

    public static int bigIntegerToInt(CallRuntime cr, BigInteger big) {
        try {
            return big.intValueExact();
        }
        catch (ArithmeticException ae) {
            throw new RuntimeError(cr, "Value out of reach", "Value to big/small for Int: " + big);
        }
    }

    public static byte intToByte(CallRuntime cr, int value) {
        if (value > 127) {
            throw new RuntimeError(cr, "Value too big", "Maximum for Byte is 127");
        }
        if (value < -128) {
            throw new RuntimeError(cr, "Value too small", "Minimum for Byte is -128");
        }
        return (byte)value;
    }

    public static short intToShort(CallRuntime cr, int value) {
        if (value > Short.MAX_VALUE) {
            throw new RuntimeError(cr, "Value too big", "Maximum for Short is 32767");
        }
        if (value < Short.MIN_VALUE) {
            throw new RuntimeError(cr, "Value too small", "Minimum for Short is -32768");
        }
        return (short)value;
    }

    public static float doubleToFloat(CallRuntime cr, double value) {
        if (value > 3.4028234663852886E38) {
            throw new RuntimeError(cr, "Value too big", "Maximum for Float is 3.4028235E38");
        }
        if (value < (double)1.4E-45f) {
            throw new RuntimeError(cr, "Value too small", "Minimum for Float is 1.4E-45");
        }
        return (float)value;
    }
}

