/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.parser.obj;

import de.mn77.base.data.filter.FilterString;
import de.mn77.base.data.group.Group2;
import de.mn77.base.error.Err;
import org.jaymo_lang.error.CodeError;
import org.jaymo_lang.model.Block;
import org.jaymo_lang.object.I_Object;
import org.jaymo_lang.object.passthrough.Const;
import org.jaymo_lang.object.pseudo.ConstLet;
import org.jaymo_lang.parser.Parser_Script;
import org.jaymo_lang.parser.obj.I_ParseObject;
import org.jaymo_lang.util.Lib_Comply;

public class ParseObj_ConstLet
implements I_ParseObject {
    private static final String matching = "ABCDEFGHIJKLMNOPQRSTUVWXYZ_0123456789";

    @Override
    public boolean hits(char c0, Block current, String s) {
        if (c0 != ':' || s.length() <= 1) {
            return false;
        }
        char c1 = s.charAt(1);
        return c1 >= 'A' && c1 <= 'Z';
    }

    @Override
    public Group2<I_Object, String> parse(Parser_Script parser, Block current, String s) {
        Err.ifNull(current);
        String con = FilterString.matchingLeft(matching, s.substring(1));
        if (!Lib_Comply.checkConstName(con)) {
            throw new CodeError("Invalid constant name", "This constant name can't be used: " + con, parser);
        }
        String rem = s.substring(con.length() + 1);
        Const co = (Const)current.getConstManager().use_ParseTime(parser, con, false);
        ConstLet vl = new ConstLet(co);
        return new Group2<I_Object, String>(vl, rem);
    }
}

