/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.object.sys;

import java.util.Scanner;
import java.util.function.Function;
import org.jaymo_lang.model.ObjectCallResult;
import org.jaymo_lang.object.A_Object;
import org.jaymo_lang.object.atom.Bool;
import org.jaymo_lang.object.atom.Dec;
import org.jaymo_lang.object.atom.Int;
import org.jaymo_lang.object.atom.Str;
import org.jaymo_lang.object.immute.A_Immutable;
import org.jaymo_lang.object.immute.Nil;
import org.jaymo_lang.runtime.CallRuntime;

public class JMo_Input
extends A_Object {
    private static Scanner sc = new Scanner(System.in);
    private static Function<Class<?>, String> alternateSource = null;

    @Override
    public void init(CallRuntime cr) {
        cr.getApp().strict.checkSandbox(cr, "Input");
        if (alternateSource == null) {
            cr.getStrict().checkWebstart(cr, "Input");
        }
    }

    @Override
    protected ObjectCallResult call2(CallRuntime cr, String method) {
        switch (method) {
            case "str": 
            case "readStr": {
                return A_Object.stdResult(this.mReadStr(cr));
            }
            case "int": 
            case "readInt": {
                return A_Object.stdResult(this.mReadInt(cr));
            }
            case "readBool": 
            case "bool": {
                return A_Object.stdResult(this.mReadBool(cr));
            }
            case "dec": 
            case "readDec": {
                return A_Object.stdResult(this.mReadDec(cr));
            }
        }
        return null;
    }

    public static void setSource(Function<Class<?>, String> f) {
        alternateSource = f;
    }

    private A_Immutable mReadDec(CallRuntime cr) {
        cr.argsNone();
        try {
            String s = this.iRead(Dec.class);
            if (s == null) {
                return Nil.NIL;
            }
            s = s.replace(',', '.');
            double d = Double.parseDouble(s);
            return new Dec(d);
        }
        catch (NumberFormatException e) {
            return Nil.NIL;
        }
    }

    private A_Immutable mReadInt(CallRuntime cr) {
        cr.argsNone();
        try {
            String s = this.iRead(Int.class);
            if (s == null) {
                return Nil.NIL;
            }
            s = s.replace(',', '.');
            int i = Integer.parseInt(s);
            return new Int(i);
        }
        catch (NumberFormatException e) {
            return Nil.NIL;
        }
    }

    private A_Immutable mReadStr(CallRuntime cr) {
        cr.argsNone();
        String s = this.iRead(Str.class);
        return s == null ? Nil.NIL : new Str(s);
    }

    private A_Immutable mReadBool(CallRuntime cr) {
        cr.argsNone();
        String s = this.iRead(Bool.class);
        if (s == null) {
            return Nil.NIL;
        }
        switch (s = s.trim().toLowerCase()) {
            case "1": 
            case "true": {
                return Bool.TRUE;
            }
            case "0": 
            case "false": {
                return Bool.FALSE;
            }
        }
        return Nil.NIL;
    }

    private String iRead(Class<?> type) {
        return alternateSource == null ? sc.nextLine() : alternateSource.apply(type);
    }
}

