/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.object.struct;

import de.mn77.base.data.Lib_Array;
import de.mn77.base.data.constant.position.POSITION;
import de.mn77.base.data.constant.position.POSITION_H;
import de.mn77.base.data.struct.I_Sequence;
import de.mn77.base.data.struct.list.I_List;
import de.mn77.base.data.struct.list.MList;
import de.mn77.base.data.struct.table.I_Table;
import de.mn77.base.data.struct.table.MTable;
import de.mn77.base.error.Err;
import java.util.ArrayList;
import java.util.Collection;
import org.jaymo_lang.error.RuntimeError;
import org.jaymo_lang.model.ArgCallBuffer;
import org.jaymo_lang.model.Call;
import org.jaymo_lang.model.I_AutoBlockDo;
import org.jaymo_lang.model.I_AutoBlockList;
import org.jaymo_lang.model.ObjectCallResult;
import org.jaymo_lang.object.A_Object;
import org.jaymo_lang.object.I_Object;
import org.jaymo_lang.object.LoopHandle;
import org.jaymo_lang.object.atom.A_Atomic;
import org.jaymo_lang.object.atom.A_IntNumber;
import org.jaymo_lang.object.atom.Bool;
import org.jaymo_lang.object.atom.I_Atomic;
import org.jaymo_lang.object.atom.Int;
import org.jaymo_lang.object.immute.Nil;
import org.jaymo_lang.object.magic.con.MagicPosition;
import org.jaymo_lang.object.pseudo.Return;
import org.jaymo_lang.object.struct.A_Sequence;
import org.jaymo_lang.object.struct.JMo_List;
import org.jaymo_lang.object.struct.JMo_Map;
import org.jaymo_lang.runtime.CallRuntime;
import org.jaymo_lang.runtime.STYPE;
import org.jaymo_lang.util.Lib_Convert;
import org.jaymo_lang.util.Lib_Error;
import org.jaymo_lang.util.Lib_Exec;
import org.jaymo_lang.util.Lib_Sequence;
import org.jaymo_lang.util.Lib_Table;
import org.jaymo_lang.util.Lib_Type;

public class JMo_Table
extends A_Sequence
implements I_AutoBlockDo,
I_AutoBlockList {
    private I_Table<I_Object> tab;
    private final ArgCallBuffer width;
    private final ArgCallBuffer rows;
    private final ArgCallBuffer fill;
    private I_Object[] titles = null;

    public JMo_Table(Call width) {
        this.width = new ArgCallBuffer(0, width);
        this.rows = null;
        this.fill = null;
    }

    public JMo_Table(Call width, Call rows, Call fill) {
        this.width = new ArgCallBuffer(0, width);
        this.rows = new ArgCallBuffer(1, rows);
        this.fill = new ArgCallBuffer(2, fill);
    }

    public JMo_Table(I_Table<I_Object> init_tab) {
        this.tab = init_tab;
        this.width = null;
        this.rows = null;
        this.fill = null;
    }

    @Override
    public void init(CallRuntime cr) {
        if (this.width != null) {
            int w;
            this.width.init(cr, this, A_IntNumber.class);
            if (this.tab != null) {
                Err.invalid(this.tab);
            }
            if ((w = Lib_Convert.getIntValue(cr, this.width.get())) < 1) {
                throw new RuntimeError(cr, "Invalid table width", "Minimum amount of columns is 1, but got " + w);
            }
            this.tab = new MTable<I_Object>(w);
            if (this.rows != null) {
                int r = Lib_Convert.getIntValue(cr, this.rows.init(cr, this, A_IntNumber.class));
                Object f = this.fill.init(cr, this, null);
                int ir = 1;
                while (ir <= r) {
                    MList l = new MList();
                    int iw = 1;
                    while (iw <= w) {
                        l.add(f);
                        ++iw;
                    }
                    this.tab.add(l);
                    ++ir;
                }
            }
        }
    }

    @Override
    protected ObjectCallResult call3(CallRuntime cr, String method) {
        switch (method) {
            case "init": {
                this.mInit(cr);
                return A_Object.stdResult(this);
            }
            case "row": {
                return A_Object.stdResult(this.mGetRow(cr, false));
            }
            case "rowMap": {
                return A_Object.stdResult(this.mGetRow(cr, true));
            }
            case "column": {
                return A_Object.stdResult(this.mGetColumn(cr));
            }
            case "getTitles": {
                return this.mGetTitles(cr);
            }
            case "setTitles": {
                this.mSetTitles(cr);
                return A_Object.stdResult(this);
            }
            case "firstRowTitles": {
                this.mSetFirstRowTitles(cr);
                return A_Object.stdResult(this);
            }
            case "+": 
            case "add": {
                return A_Object.stdResult(this.mAdd(cr));
            }
            case "addRow": 
            case "addRows": {
                return A_Object.stdResult(this.mAddRows(cr));
            }
            case "concat": 
            case "++": {
                return A_Object.stdResult(this.mConcat(cr));
            }
            case "addAll": {
                return A_Object.stdResult(this.mAddAll(cr));
            }
            case "each": {
                return this.mEach(cr, false);
            }
            case "eachMap": {
                return this.mEach(cr, true);
            }
            case "search": {
                return A_Object.stdResult(this.mSearch(cr));
            }
            case "searchFirst": {
                return A_Object.stdResult(this.mSearchFirst(cr));
            }
            case "width": {
                cr.argsNone();
                return A_Object.stdResult(new Int(this.tab.getWidth()));
            }
            case "sort": {
                return A_Object.stdResult(this.mSort(cr));
            }
            case "reverse": {
                return A_Object.stdResult(this.mReverse(cr));
            }
            case "rotate": {
                return A_Object.stdResult(this.mRotate(cr));
            }
            case "columns": {
                return A_Object.stdResult(this.mColumns(cr));
            }
            case "rows": {
                return A_Object.stdResult(this.mRows(cr));
            }
            case "deleteRow": 
            case "deleteRows": {
                return A_Object.stdResult(this.mDelete(cr));
            }
            case "contains": {
                return A_Object.stdResult(this.mContains(cr));
            }
        }
        return null;
    }

    private void mInit(CallRuntime cr) {
        I_Object[] args = cr.args(this, Int.class, I_Object.class);
        int r = Lib_Convert.getIntValue(cr, args[0]);
        I_Object f = args[1];
        int ir = 1;
        while (ir <= r) {
            MList<I_Object> l = new MList<I_Object>();
            int iw = 1;
            while (iw <= this.tab.getWidth()) {
                l.add(f);
                ++iw;
            }
            this.tab.add((I_Sequence<I_Object>)l);
            ++ir;
        }
    }

    private ObjectCallResult mGetTitles(CallRuntime cr) {
        ArrayList<I_Object> al = new ArrayList<I_Object>(this.titles.length);
        I_Object[] i_ObjectArray = this.titles;
        int n = this.titles.length;
        int n2 = 0;
        while (n2 < n) {
            I_Object o = i_ObjectArray[n2];
            al.add(o);
            ++n2;
        }
        return A_Object.stdResult(new JMo_List(al));
    }

    @Override
    public I_Object autoBlockDo(CallRuntime cr) {
        return this.mEach((CallRuntime)cr, (boolean)false).obj;
    }

    @Override
    public ArrayList<I_Object> autoBlockToList(CallRuntime cr) {
        ArrayList<I_Object> result = new ArrayList<I_Object>();
        for (I_Sequence i_Sequence : this.tab) {
            ArrayList<I_Object> row = new ArrayList<I_Object>();
            for (I_Object si : i_Sequence) {
                row.add(si);
            }
            result.add(new JMo_List(row));
        }
        return result;
    }

    public I_Table<I_Object> getInternalObject() {
        return this.tab;
    }

    public I_Object[] getInternalColumnNames() {
        return this.titles;
    }

    @Override
    public String toString() {
        return this.tab == null ? "Table" : "Table<" + this.tab.getWidth() + ',' + this.tab.size() + '>';
    }

    @Override
    public String toString(CallRuntime cr, STYPE type) {
        switch (type) {
            case REGULAR: {
                return Lib_Table.toText(false, cr, this, this.tab, this.titles);
            }
            case NESTED: 
            case IDENT: {
                return this.toString();
            }
        }
        return Lib_Table.toText(true, cr, this, this.tab, this.titles);
    }

    @Override
    protected JMo_Table copy(CallRuntime cr) {
        return new JMo_Table((I_Table<I_Object>)this.tab.copy());
    }

    @Override
    protected int sequenceSize() {
        return this.tab.size();
    }

    @Override
    protected boolean sequenceEmpty() {
        return this.tab.isEmpty();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof JMo_Table) {
            I_Table<I_Object> other = ((JMo_Table)obj).tab;
            if (this.tab.size() != other.size() || this.tab.getWidth() != other.getWidth()) {
                return false;
            }
            int y = 1;
            while (y <= this.tab.size()) {
                int x = 1;
                while (x <= this.tab.getWidth()) {
                    if (!this.tab.get(x, y).equals(other.get(x, y))) {
                        return false;
                    }
                    ++x;
                }
                ++y;
            }
            I_Object[] otherTitles = ((JMo_Table)obj).titles;
            if (this.titles == null) {
                return otherTitles == null;
            }
            if (otherTitles == null || this.titles.length != otherTitles.length) {
                return false;
            }
            int i = 0;
            while (i < this.titles.length) {
                if (!this.titles[i].equals(otherTitles[i])) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean equalsLazy(Object obj) {
        return this.equals(obj);
    }

    @Override
    protected I_Object getFirst(CallRuntime cr) {
        return this.tab.size() == 0 ? Nil.NIL : this.iToList((I_Sequence)this.tab.get(1));
    }

    @Override
    protected I_Object getLast(CallRuntime cr) {
        int len = this.tab.size();
        return len == 0 ? Nil.NIL : this.iToList((I_Sequence)this.tab.get(len));
    }

    @Override
    protected I_Object mSequenceGetPull(CallRuntime cr, boolean lazy) {
        if (cr.argCount() == 1) {
            return this.mGetRow(cr, false);
        }
        I_Object[] xy = cr.argsVar(this, 2, 2);
        if (xy.length > 2) {
            return this.sequenceDeepGet(cr, xy, 0, lazy);
        }
        int iRow = Lib_Convert.getIntValue(cr, xy[0]);
        int iCol = Lib_Convert.getIntValue(cr, xy[1]);
        if (lazy && (iCol > this.tab.getWidth() || iRow > this.tab.size())) {
            return Nil.NIL;
        }
        Lib_Error.ifNotBetween(cr, 1, this.tab.getWidth(), iCol, "column");
        Lib_Error.ifNotBetween(cr, 1, this.tab.size(), iRow, "row");
        return this.tab.get(iCol, iRow);
    }

    @Override
    protected void mSequenceSetPut(CallRuntime cr, boolean lazy) {
        I_Object[] orc = cr.argsVar(this, 2, 2);
        if (orc.length > 3) {
            this.sequenceDeepSet(cr, orc, 1, orc[0], lazy);
            return;
        }
        int row = Lib_Convert.getIntValue(cr, orc[1]);
        int col = Lib_Convert.getIntValue(cr, orc[2]);
        if (lazy) {
            while (this.tab.size() < row) {
                MList newRow = new MList();
                int i = 1;
                while (i <= this.tab.getWidth()) {
                    newRow.add(Nil.NIL);
                    ++i;
                }
                this.tab.add(newRow);
            }
            if (col > this.tab.getWidth()) {
                throw new RuntimeError(cr, "Can't add columns to Table", "Table has a fixed width, so I can't add/access column " + col);
            }
        }
        this.tab.set(col, row, orc[0]);
    }

    @Override
    public I_Object sequenceDeepGet(CallRuntime cr, I_Object[] keys, int offset, boolean lazy) {
        A_IntNumber oi = (A_IntNumber)cr.argType(keys[offset], A_IntNumber.class);
        int i = Lib_Convert.getIntValue(cr, oi);
        int pos = Lib_Sequence.realPos(cr, i, this.tab.size(), lazy);
        if (pos == -1 || pos > this.tab.size()) {
            if (lazy) {
                return Nil.NIL;
            }
            Lib_Error.ifNotBetween(cr, 1, this.tab.size(), pos, "position in list");
        }
        if (offset == keys.length - 1) {
            I_Sequence it = (I_Sequence)this.tab.get(pos);
            return this.iToList(it);
        }
        I_Sequence it = (I_Sequence)this.tab.get(pos);
        I_Object deeper = this.iToList(it);
        if (!(deeper instanceof A_Sequence)) {
            throw new RuntimeError(cr, "Invalid type of item.", "Item " + (offset + 1) + " isn't a sequence, so I can't go into it!");
        }
        A_Sequence deeper2 = (A_Sequence)deeper;
        return deeper2.sequenceDeepGet(cr, keys, offset + 1, lazy);
    }

    @Override
    public void sequenceDeepSet(CallRuntime cr, I_Object[] keys, int offset, I_Object value, boolean lazy) {
        A_IntNumber oiy = (A_IntNumber)cr.argType(keys[offset], A_IntNumber.class);
        int wantedY = Lib_Convert.getIntValue(cr, oiy);
        int posY = Lib_Sequence.realPos(cr, wantedY, this.tab.size(), lazy);
        if (lazy) {
            while ((posY = Lib_Sequence.realPos(cr, wantedY, this.tab.size(), lazy)) == -1) {
                MList<Nil> emptyRow = new MList<Nil>();
                int i = 1;
                while (i <= this.tab.getWidth()) {
                    emptyRow.add(Nil.NIL);
                    ++i;
                }
                this.tab.add((I_Sequence<I_Object>)emptyRow);
            }
        }
        Lib_Error.ifNotBetween(cr, 1, this.tab.size(), posY, "row");
        if (keys.length - offset == 1) {
            if (!Lib_Type.typeIs(cr, value, JMo_List.class)) {
                throw new RuntimeError(cr, "Invalid type of value", "Value must be a List");
            }
            JMo_List valueList = (JMo_List)value;
            Collection valueArrayList = valueList.getInternalCollection();
            Lib_Error.ifNot(cr, this.tab.getWidth(), ((ArrayList)valueArrayList).size(), "row-size");
            int col = 1;
            while (col <= this.tab.getWidth()) {
                this.tab.set(col, posY, (I_Object)((ArrayList)valueArrayList).get(col - 1));
                ++col;
            }
            return;
        }
        A_IntNumber oix = (A_IntNumber)cr.argType(keys[offset + 1], A_IntNumber.class);
        int wantedX = Lib_Convert.getIntValue(cr, oix);
        int posX = Lib_Sequence.realPos(cr, wantedX, this.tab.size(), lazy);
        Lib_Error.ifNotBetween(cr, 1, this.tab.getWidth(), wantedX, "column");
        if (offset == keys.length - 2) {
            this.tab.set(posX, posY, value);
        } else {
            I_Object deeper = this.tab.get(posX, posY);
            if (deeper == Nil.NIL && lazy) {
                deeper = new JMo_List();
                this.tab.set(posX, posY, deeper);
            }
            if (!(deeper instanceof A_Sequence)) {
                throw new RuntimeError(cr, "Invalid type of item.", "Item " + (offset + 1) + " isn't a sequence, so I can't go into it!");
            }
            A_Sequence deeper2 = (A_Sequence)deeper;
            deeper2.sequenceDeepSet(cr, keys, offset + 2, value, lazy);
        }
    }

    @Override
    protected I_Object sequenceSelectGet(CallRuntime cr, I_Object key, boolean lazy) {
        int oi = Lib_Convert.getIntValue(cr, key);
        int pos = Lib_Sequence.realPos(cr, oi, this.tab.size(), lazy);
        return pos == -1 ? Nil.NIL : this.iToList(this.tab.getRow(pos));
    }

    private JMo_Table mAdd(CallRuntime cr) {
        I_Object[] args = cr.argsVar(this, 1, 0);
        if (args.length != this.tab.getWidth()) {
            throw new RuntimeError(cr, "Invalid amount of items to add.", "Width of table is " + this.tab.getWidth() + ", but got " + cr.argCount() + " items.");
        }
        this.tab.add((I_Object[])args);
        return this;
    }

    private JMo_Table mAddRows(CallRuntime cr) {
        I_Object[] args;
        I_Object[] i_ObjectArray = args = cr.argsVar(this, 1, 1);
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            I_Object arg = i_ObjectArray[n2];
            JMo_List pl = (JMo_List)cr.argType(arg, JMo_List.class);
            Collection list = pl.getInternalCollection();
            if (((ArrayList)list).size() != this.tab.getWidth()) {
                throw new RuntimeError(cr, "Invalid size of row", "Table width is " + this.tab.getWidth() + ", but should add a row with " + ((ArrayList)list).size() + " items.");
            }
            I_Object[] row = ((ArrayList)list).toArray(new I_Object[((ArrayList)list).size()]);
            this.tab.add((I_Object[])row);
            ++n2;
        }
        return this;
    }

    private JMo_Table mConcat(CallRuntime cr) {
        JMo_Table tab2 = (JMo_Table)cr.args(this, JMo_Table.class)[0];
        MTable<I_Object> newTab = new MTable<I_Object>(this.tab.getWidth());
        this.tab.forEach(a -> newTab.add((I_Sequence<I_Object>)a));
        tab2.getInternalObject().forEach(a -> newTab.add((I_Sequence<I_Object>)a));
        return new JMo_Table(newTab);
    }

    private JMo_Table mAddAll(CallRuntime cr) {
        JMo_Table tab2 = (JMo_Table)cr.args(this, JMo_Table.class)[0];
        tab2.getInternalObject().forEach(a -> this.tab.add((I_Sequence<I_Object>)a));
        return this;
    }

    private ObjectCallResult mEach(CallRuntime crOld, boolean map) {
        crOld.argsNone();
        if (crOld.getStream() == null && crOld.getCallBlock() == null) {
            Err.impossible("No block, no stream, what should I do?");
        }
        LoopHandle handle = new LoopHandle(this);
        CallRuntime crNew = crOld.copyLoop(handle);
        I_Object result = Nil.NIL;
        for (I_Sequence i_Sequence : this.tab) {
            handle.startLap();
            I_Object itO = map ? this.iToMap(i_Sequence) : this.iToList(i_Sequence);
            result = Lib_Exec.execBlockStream(crNew, itO);
            result = Lib_Exec.loopResult(result);
            if (!(result instanceof Return)) continue;
            return ((Return)result).getLoopResult();
        }
        return new ObjectCallResult(result, true);
    }

    private I_Object mGetRow(CallRuntime cr, boolean map) {
        I_Object y = cr.args(this, A_IntNumber.class)[0];
        int iy = Lib_Convert.getIntValue(cr, y);
        Lib_Error.ifNotBetween(cr, 1, this.tab.size(), iy, "row");
        I_Sequence it = (I_Sequence)this.tab.get(iy);
        return map ? this.iToMap(it) : this.iToList(it);
    }

    private I_Object mGetColumn(CallRuntime cr) {
        I_Object x = cr.args(this, A_IntNumber.class)[0];
        int ix = Lib_Convert.getIntValue(cr, x);
        Lib_Error.ifNotBetween(cr, 1, this.tab.getWidth(), ix, "column");
        return this.iToList(this.tab.getCol(ix));
    }

    private I_Object iToList(I_Sequence<I_Object> it) {
        ArrayList<I_Object> al = new ArrayList<I_Object>();
        for (I_Object item : it) {
            al.add(item);
        }
        return new JMo_List(al);
    }

    private I_Object iToMap(I_Sequence<I_Object> it) {
        ArrayList<I_Object> objects = new ArrayList<I_Object>(it.size());
        for (I_Object item : it) {
            objects.add(item);
        }
        if (this.titles != null) {
            ArrayList<I_Object> keys = new ArrayList<I_Object>(this.titles.length);
            I_Object[] i_ObjectArray = this.titles;
            int n = this.titles.length;
            int n2 = 0;
            while (n2 < n) {
                I_Object title = i_ObjectArray[n2];
                keys.add(title);
                ++n2;
            }
            return new JMo_Map(keys, objects);
        }
        ArrayList<I_Object> t2 = new ArrayList<I_Object>();
        int col = 1;
        while (col <= this.tab.getWidth()) {
            t2.add(new Int(col));
            ++col;
        }
        return new JMo_Map(t2, objects);
    }

    private Bool mContains(CallRuntime cr) {
        I_Object arg = cr.args(this, A_Object.class)[0];
        int x = 1;
        while (x <= this.tab.getWidth()) {
            if (this.tab.getCol(x).contains(arg)) {
                return Bool.TRUE;
            }
            ++x;
        }
        return Bool.FALSE;
    }

    private JMo_Table mSearch(CallRuntime cr) {
        I_Atomic searcho = (I_Atomic)cr.args(this, I_Atomic.class)[0];
        String search = Lib_Convert.getStringValue(cr, searcho);
        MTable<I_Object> res = new MTable<I_Object>(this.tab.getWidth());
        int y = 1;
        while (y <= this.tab.size()) {
            boolean add = false;
            int x = 1;
            while (x <= this.tab.getWidth()) {
                I_Object o = this.tab.get(x, y);
                String s = Lib_Convert.getStringValue(cr, o);
                if (s.equals(search)) {
                    add = true;
                    break;
                }
                ++x;
            }
            if (add) {
                I_Sequence row = (I_Sequence)this.tab.get(y);
                res.add(row);
            }
            ++y;
        }
        return new JMo_Table(res);
    }

    private I_Object mSearchFirst(CallRuntime cr) {
        I_Atomic searcho = (I_Atomic)cr.args(this, I_Atomic.class)[0];
        String search = Lib_Convert.getStringValue(cr, searcho);
        int y = 1;
        while (y <= this.tab.size()) {
            int x = 1;
            while (x <= this.tab.getWidth()) {
                I_Object o = this.tab.get(x, y);
                String s = Lib_Convert.getStringValue(cr, o);
                if (s.equals(search)) {
                    I_Sequence row = (I_Sequence)this.tab.get(y);
                    ArrayList<I_Object> row2 = new ArrayList<I_Object>();
                    for (I_Object item : row) {
                        row2.add(item);
                    }
                    return new JMo_List(row2);
                }
                ++x;
            }
            ++y;
        }
        return Nil.NIL;
    }

    private I_Object mSort(CallRuntime cr) {
        int tabWidth;
        I_Object[] args = cr.argsVar(this, 0, 0);
        int parLen = args.length;
        if (parLen > (tabWidth = this.tab.getWidth())) {
            throw new RuntimeError(cr, "Too much parameters", "This table has only " + tabWidth + " colums. Got " + parLen + " columns to sort.");
        }
        int[] colOrder = new int[parLen];
        int i = 0;
        while (i < parLen) {
            colOrder[i] = Lib_Convert.getIntValue(cr, cr.argType(args[i], A_IntNumber.class));
            ++i;
        }
        int[] nArray = colOrder;
        int n = colOrder.length;
        int n2 = 0;
        while (n2 < n) {
            i = nArray[n2];
            Lib_Error.ifNotBetween(cr, 1, this.tab.getWidth(), Math.abs(i), "column");
            ++n2;
        }
        this.tab.sort(colOrder);
        return this;
    }

    private I_Object mReverse(CallRuntime cr) {
        cr.argsNone();
        int size = this.tab.size();
        int[] order = new int[size];
        int i = 0;
        while (i < size) {
            order[i] = size - i;
            ++i;
        }
        this.tab.sortLike(order);
        return this;
    }

    private I_Object mRotate(CallRuntime cr) {
        I_Object[] args = cr.argsVar(this, 0, 1);
        MTable<I_Object> newTab = new MTable<I_Object>(this.tab.size());
        POSITION_H dir = POSITION_H.RIGHT;
        if (args.length == 1) {
            POSITION p = ((MagicPosition)cr.argType(args[0], MagicPosition.class)).get();
            if (p != POSITION.LEFT && p != POSITION.RIGHT) {
                throw new RuntimeError(cr, "Invalid direction", "The table can only rotate to _LEFT and _RIGHT.");
            }
            dir = (POSITION_H)((Object)p);
        }
        if (dir == POSITION_H.LEFT) {
            int col = this.tab.getWidth();
            while (col >= 1) {
                newTab.add((I_Sequence<I_Object>)this.tab.getCol(col));
                --col;
            }
        } else {
            int col = 1;
            while (col <= this.tab.getWidth()) {
                I_List<I_Object> row = this.tab.getCol(col);
                row.reverse();
                newTab.add((I_Sequence<I_Object>)row);
                ++col;
            }
        }
        return new JMo_Table(newTab);
    }

    private JMo_Table mColumns(CallRuntime cr) {
        I_Object[] args = cr.argsVar(this, 1, 0);
        int parLen = args.length;
        int[] parsi = new int[parLen];
        int i = 0;
        while (i < parLen) {
            parsi[i] = Lib_Convert.getIntValue(cr, cr.argType(args[i], A_IntNumber.class));
            ++i;
        }
        MTable<I_Object> newTab = new MTable<I_Object>(parLen);
        int row = 1;
        while (row <= this.tab.size()) {
            I_Object[] items = new I_Object[parLen];
            int i2 = 0;
            while (i2 < parLen) {
                items[i2] = this.tab.get(parsi[i2], row);
                ++i2;
            }
            newTab.add((I_Object[])items);
            ++row;
        }
        return new JMo_Table(newTab);
    }

    private JMo_Table mRows(CallRuntime cr) {
        I_Object[] args = cr.argsVar(this, 1, 0);
        MTable<I_Object> newTab = new MTable<I_Object>(this.tab.getWidth());
        I_Object[] i_ObjectArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            I_Object arg = i_ObjectArray[n2];
            int parRow = Lib_Convert.getIntValue(cr, cr.argType(arg, A_IntNumber.class));
            newTab.add((I_Sequence<I_Object>)this.tab.getRow(parRow));
            ++n2;
        }
        return new JMo_Table(newTab);
    }

    private JMo_Table mDelete(CallRuntime cr) {
        I_Object[] args = cr.argsVar(this, 1, 0);
        int len = args.length;
        int[] rows = new int[len];
        int i = 0;
        while (i < len) {
            rows[i] = Lib_Convert.getIntValue(cr, args[i]);
            ++i;
        }
        Integer duplicate = Lib_Array.getNextDuplicate(rows);
        if (duplicate != null) {
            throw new RuntimeError(cr, "Duplicated row position", "Same row can't removed twice: " + duplicate);
        }
        Lib_Array.sortGnome(rows, true);
        int[] nArray = rows;
        int n = rows.length;
        int n2 = 0;
        while (n2 < n) {
            int row = nArray[n2];
            Lib_Error.ifNotBetween(cr, 1, this.tab.size(), row, "row");
            this.tab.remove(row);
            ++n2;
        }
        return this;
    }

    private void mSetTitles(CallRuntime cr) {
        I_Object[] args = cr.argsVar(this, 1, 0);
        this.setTitles(cr, args);
    }

    private void mSetFirstRowTitles(CallRuntime cr) {
        cr.argsNone();
        if (this.tab.size() == 0) {
            throw new RuntimeError(cr, "Invalid amount of rows", "The table must contain at least one row to be set as titles.");
        }
        I_List<I_Object> row1 = this.tab.remove(1);
        I_Object[] headers = row1.toArray(I_Object.class);
        this.setTitles(cr, headers);
    }

    public void setTitles(CallRuntime cr, I_Object[] titles) {
        if (titles.length != this.tab.getWidth()) {
            throw new RuntimeError(cr, "Invalid amount of titles for table", "Column count is " + this.tab.getWidth() + ", but got " + titles.length + " title(s).");
        }
        I_Object[] i_ObjectArray = titles;
        int n = titles.length;
        int n2 = 0;
        while (n2 < n) {
            I_Object title = i_ObjectArray[n2];
            cr.argType(title, A_Atomic.class);
            ++n2;
        }
        this.titles = titles;
    }

    @Override
    protected void sequenceSet(CallRuntime cr, I_Object key, I_Object value, boolean lazy) {
        Collection cols = ((JMo_List)cr.argType(value, JMo_List.class)).getInternalCollection();
        int row = Lib_Convert.getIntValue(cr, key);
        if (lazy) {
            while (this.tab.size() < row) {
                MList newRow = new MList();
                int i = 1;
                while (i <= this.tab.getWidth()) {
                    newRow.add(Nil.NIL);
                    ++i;
                }
                this.tab.add(newRow);
            }
        }
        Lib_Error.ifNotBetween(cr, 1, this.tab.size(), row, "row");
        Lib_Error.ifNotBetween(cr, 1, this.tab.getWidth(), ((ArrayList)cols).size(), "columns");
        int col = 1;
        while (col <= this.tab.getWidth()) {
            this.tab.set(col, row, (I_Object)((ArrayList)cols).get(col - 1));
            ++col;
        }
    }

    @Override
    protected Collection<? extends I_Object> getInternalCollection() {
        throw Err.impossible(new Object[0]);
    }
}

