/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.object.filesys;

import de.mn77.base.data.type.datetime.MDateTime;
import de.mn77.base.error.Err;
import de.mn77.base.error.Err_FileSys;
import de.mn77.base.sys.Sys;
import de.mn77.base.sys.cmd.SYSCMD_IO;
import de.mn77.base.sys.cmd.SysCmd;
import de.mn77.base.sys.cmd.SysCmdData;
import de.mn77.base.sys.cmd.SysCmdResult;
import de.mn77.base.sys.file.Lib_FileSys;
import de.mn77.base.sys.file.Lib_TextFile;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import org.jaymo_lang.error.ExternalError;
import org.jaymo_lang.model.Call;
import org.jaymo_lang.model.ObjectCallResult;
import org.jaymo_lang.object.A_Object;
import org.jaymo_lang.object.I_Object;
import org.jaymo_lang.object.atom.A_Atomic;
import org.jaymo_lang.object.atom.A_IntNumber;
import org.jaymo_lang.object.atom.Int;
import org.jaymo_lang.object.atom.JMo_Long;
import org.jaymo_lang.object.atom.Str;
import org.jaymo_lang.object.filesys.JMo_Dir;
import org.jaymo_lang.object.filesys.JMo_Path;
import org.jaymo_lang.object.filesys.JMo_RandomAccessFile;
import org.jaymo_lang.object.immute.Nil;
import org.jaymo_lang.object.immute.datetime.JMo_DateTime;
import org.jaymo_lang.object.struct.JMo_ByteArray;
import org.jaymo_lang.object.struct.JMo_List;
import org.jaymo_lang.object.sys.JMo_Cmd;
import org.jaymo_lang.runtime.CallRuntime;
import org.jaymo_lang.runtime.STYPE;
import org.jaymo_lang.util.Lib_Convert;
import org.jaymo_lang.util.Lib_Error;

public class JMo_File
extends JMo_Path
implements I_Object {
    public JMo_File(Call arg) {
        super(arg);
    }

    public JMo_File(File file) {
        super(file);
    }

    @Override
    protected ObjectCallResult call2(CallRuntime cr, String method) {
        ObjectCallResult result = super.call2(cr, method);
        if (result != null) {
            return result;
        }
        switch (method) {
            case "suffix": {
                return A_Object.stdResult(this.mSuffix(cr));
            }
            case "directory": 
            case "dir": {
                return A_Object.stdResult(this.mDirectory(cr));
            }
            case "size": {
                return A_Object.stdResult(this.mSize(cr));
            }
            case "created": {
                return A_Object.stdResult(this.mCreated(cr));
            }
            case "modified": {
                return A_Object.stdResult(this.mModified(cr));
            }
            case "exec": {
                return A_Object.stdResult(this.mExec(cr));
            }
            case "open": {
                return A_Object.stdResult(this.mOpen(cr));
            }
            case "cmd": {
                return A_Object.stdResult(this.mCmd(cr));
            }
            case "create": 
            case "touch": {
                return A_Object.stdResult(this.mCreate(cr));
            }
            case "clear": {
                return A_Object.stdResult(this.mClear(cr));
            }
            case "readLines": 
            case "lines": {
                return A_Object.stdResult(this.mReadLines(cr));
            }
            case "read": {
                return A_Object.stdResult(this.mRead(cr));
            }
            case "readBytes": {
                return A_Object.stdResult(this.mReadBytes(cr));
            }
            case "append": {
                return A_Object.stdResult(this.mAppend(cr));
            }
            case "set": 
            case "write": {
                return A_Object.stdResult(this.mWrite(cr));
            }
            case "writeBytes": {
                return A_Object.stdResult(this.mWriteBytes(cr));
            }
            case "rename": {
                return A_Object.stdResult(this.mRename(cr));
            }
            case "move": {
                return A_Object.stdResult(this.mMove(cr));
            }
            case "delete": {
                return A_Object.stdResult(this.mDelete(cr));
            }
            case "directRead": {
                return A_Object.stdResult(this.mRandomAccess(cr, "r"));
            }
            case "toRandomAccess": 
            case "directWrite": 
            case "directReadWrite": {
                return A_Object.stdResult(this.mRandomAccess(cr, "rw"));
            }
        }
        return null;
    }

    @Override
    public String toString(CallRuntime cr, STYPE type) {
        File f = this.getInternalFile();
        if (f == null) {
            return "File";
        }
        switch (type) {
            case REGULAR: {
                return f.getAbsolutePath().toString();
            }
            case NESTED: 
            case IDENT: {
                return "File";
            }
        }
        return "File(\"" + f.getAbsolutePath().toString() + '\"' + ")";
    }

    private I_Object mRandomAccess(CallRuntime cr, String mode) {
        cr.argsNone();
        JMo_RandomAccessFile raf = new JMo_RandomAccessFile(this.getInternalFile(), mode);
        return raf;
    }

    private JMo_File mRename(CallRuntime cr) {
        File newFile;
        Str arg = (Str)cr.args(this, Str.class)[0];
        String newName = Lib_Convert.getStringValue(cr, arg);
        if (newName.contains(Sys.getSeperatorDir())) {
            throw new ExternalError(cr, "File-Rename failed", "No target-path allowed");
        }
        File oldFile = this.getInternalFile();
        boolean done = oldFile.renameTo(newFile = new File(newName = String.valueOf(oldFile.getParent()) + Sys.getSeperatorDir() + newName));
        if (!done) {
            throw new ExternalError(cr, "File-Rename failed", String.valueOf(oldFile.getAbsolutePath()) + " --> " + newFile.getAbsolutePath());
        }
        this.changeFile(newFile);
        return this;
    }

    private Nil mDelete(CallRuntime cr) {
        boolean deleted;
        cr.argsNone();
        File f = this.getInternalFile();
        if (f.exists() && !(deleted = f.delete())) {
            throw new ExternalError(cr, "File-Delete-Error", this.getInternalFile().getAbsolutePath());
        }
        return Nil.NIL;
    }

    private JMo_File mMove(CallRuntime cr) {
        I_Object arg = cr.argsExt(this, new Class[][]{{Str.class, JMo_Dir.class}})[0];
        Path source = this.getInternalFile().toPath();
        File target = null;
        if (arg instanceof Str) {
            Str str = (Str)arg;
            String newNamePath = Lib_Convert.getStringValue(cr, str);
            target = new File(newNamePath);
        } else {
            target = ((JMo_Dir)arg).getInternalFile();
        }
        try {
            boolean isDir = target.isDirectory();
            if (isDir) {
                target = target.toPath().resolve(source.getFileName()).toFile();
                Files.move(source, target.toPath(), new CopyOption[0]);
            } else {
                Files.move(source, target.toPath(), new CopyOption[0]);
            }
            this.changeFile(target);
            return this;
        }
        catch (NoSuchFileException e) {
            throw new ExternalError(cr, "File-Move-Error", "Source file doesn't exist: \"" + source.toFile().getAbsolutePath() + "\"");
        }
        catch (FileAlreadyExistsException e) {
            throw new ExternalError(cr, "File-Move-Error", "Target already exist: \"" + target.getAbsolutePath() + "\"");
        }
        catch (IOException e) {
            Err.show(e);
            throw new ExternalError(cr, "File-Move-Error", "Can't move \"" + source.toFile().getAbsolutePath() + "\" --> \"" + target.getAbsolutePath() + '\"');
        }
    }

    private JMo_File mCreate(CallRuntime cr) {
        cr.argsNone();
        boolean ok = false;
        try {
            File f = this.getInternalFile();
            if (f.exists()) {
                throw new ExternalError(cr, "Can't create File", "File already exists: " + this.getInternalFile().getAbsolutePath());
            }
            ok = f.createNewFile();
        }
        catch (IOException e) {
            ok = false;
        }
        if (!ok) {
            throw new ExternalError(cr, "Can't create File", this.getInternalFile().getAbsolutePath());
        }
        return this;
    }

    private JMo_File mClear(CallRuntime cr) {
        cr.argsNone();
        RandomAccessFile raf = null;
        try {
            raf = new RandomAccessFile(this.getInternalFile(), "rw");
            raf.setLength(0L);
            JMo_File jMo_File = this;
            return jMo_File;
        }
        catch (Exception err) {
            throw new ExternalError(cr, "File access error", this.getInternalFile().getAbsolutePath());
        }
        finally {
            try {
                if (raf != null) {
                    raf.close();
                }
            }
            catch (Exception e) {
                throw new ExternalError(cr, "File close error", this.getInternalFile().getAbsolutePath());
            }
        }
    }

    private JMo_Long mSize(CallRuntime cr) {
        cr.argsNone();
        return new JMo_Long(this.getInternalFile().length());
    }

    private JMo_DateTime mModified(CallRuntime cr) {
        cr.argsNone();
        long l = this.getInternalFile().lastModified();
        return new JMo_DateTime(new MDateTime(l));
    }

    private JMo_DateTime mCreated(CallRuntime cr) {
        BasicFileAttributes attr;
        cr.argsNone();
        try {
            attr = Files.readAttributes(this.getInternalFile().toPath(), BasicFileAttributes.class, new LinkOption[0]);
        }
        catch (IOException e) {
            throw new ExternalError(cr, "File-Read-Error", e.getMessage());
        }
        long l = attr.creationTime().toMillis();
        return new JMo_DateTime(new MDateTime(l));
    }

    private Str mSuffix(CallRuntime cr) {
        cr.argsNone();
        String suffix = Lib_FileSys.getSuffix(this.getInternalFile());
        return new Str(suffix);
    }

    private JMo_Dir mDirectory(CallRuntime cr) {
        cr.argsNone();
        String path = this.getInternalFile().getParent();
        return new JMo_Dir(new File(path));
    }

    private Int mExec(CallRuntime cr) {
        I_Object[] args = cr.argsVar(this, 0, 0);
        try {
            String[] execArgs = new String[args.length];
            int i = 0;
            while (i < args.length) {
                execArgs[i] = Lib_Convert.getStringValue(cr, args[i]);
                ++i;
            }
            SysCmdData data = new SysCmdData(false, true, SYSCMD_IO.LIVE, this.getInternalFile().getAbsolutePath(), execArgs);
            SysCmdResult result = new SysCmd().start(data);
            return new Int(result.result);
        }
        catch (Exception e) {
            throw new ExternalError(cr, "Can't execute File", this.getInternalFile().getAbsolutePath());
        }
    }

    private I_Object mCmd(CallRuntime cr) {
        I_Object[] args = cr.argsVar(this, 0, 0);
        StringBuilder sb = new StringBuilder();
        sb.append(this.getInternalFile().getAbsolutePath());
        I_Object[] i_ObjectArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            I_Object arg = i_ObjectArray[n2];
            sb.append(' ');
            sb.append(Lib_Convert.getStringValue(cr, arg));
            ++n2;
        }
        Str s = new Str(sb.toString());
        Call c = new Call(cr, s);
        return new JMo_Cmd(c);
    }

    private JMo_File mOpen(CallRuntime cr) {
        cr.argsNone();
        try {
            Lib_FileSys.defaultOpen(this.getInternalFile());
        }
        catch (Err_FileSys e) {
            throw new ExternalError(cr, "Can't open file", this.getInternalFile().getAbsolutePath());
        }
        return this;
    }

    private Str mRead(CallRuntime cr) {
        cr.argsNone();
        try {
            String content = Lib_TextFile.read(this.getInternalFile(), true);
            return new Str(content);
        }
        catch (Err_FileSys e) {
            throw new ExternalError(cr, "File-Access-Error", "File: \"" + this.getInternalFile().getAbsolutePath() + '\"');
        }
    }

    private JMo_ByteArray mReadBytes(CallRuntime cr) {
        cr.argsNone();
        RandomAccessFile raf = null;
        try {
            raf = new RandomAccessFile(this.getInternalFile(), "r");
            long len = raf.length();
            if (len > Integer.MAX_VALUE) {
                throw new ExternalError(cr, "File-Access-Error", "File is too big: \"" + this.getInternalFile().getAbsolutePath() + '\"');
            }
            byte[] ba = new byte[(int)len];
            int got = raf.read(ba);
            if ((long)got != len) {
                throw new ExternalError(cr, "File-Access-Error", "Can't read full file: \"" + this.getInternalFile().getAbsolutePath() + '\"');
            }
            JMo_ByteArray jMo_ByteArray = new JMo_ByteArray(ba);
            return jMo_ByteArray;
        }
        catch (IOException e) {
            throw new ExternalError(cr, "File-Access-Error", "File: \"" + this.getInternalFile().getAbsolutePath() + '\"');
        }
        finally {
            try {
                if (raf != null) {
                    raf.close();
                }
            }
            catch (Exception e) {
                Err.show(e);
            }
        }
    }

    private JMo_List mReadLines(CallRuntime cr) {
        cr.argsNone();
        ArrayList<I_Object> list = this.iReadLines(cr);
        return new JMo_List(list);
    }

    private ArrayList<I_Object> iReadLines(CallRuntime cr) {
        ArrayList<I_Object> list = new ArrayList<I_Object>();
        try {
            ArrayList<String> lines = Lib_TextFile.readLines(this.getInternalFile(), true);
            for (String line : lines) {
                list.add(new Str(line));
            }
        }
        catch (Err_FileSys e) {
            throw new ExternalError(cr, "File read error", e.getMessage());
        }
        return list;
    }

    private JMo_File mAppend(CallRuntime cr) {
        I_Object o = cr.args(this, A_Atomic.class)[0];
        String s = Lib_Convert.getStringValue(cr, o);
        try {
            Lib_TextFile.append(this.getInternalFile(), s, true);
        }
        catch (Err_FileSys e) {
            throw new ExternalError(cr, "File-Access-Error", "File: \"" + this.getInternalFile().getAbsolutePath() + '\"');
        }
        return this;
    }

    private JMo_File mWrite(CallRuntime cr) {
        I_Object[] oa = cr.argsFlex(this, 1, 2);
        I_Object so = cr.argType(oa[0], A_Atomic.class);
        Long pos = null;
        if (oa.length == 2) {
            I_Object po = cr.argType(oa[1], A_IntNumber.class);
            pos = Lib_Convert.getLongValue(cr, po);
            Lib_Error.ifTooSmall(cr, 1L, pos);
        }
        try {
            String s = Lib_Convert.getStringValue(cr, so);
            if (pos == null) {
                Lib_TextFile.set(this.getInternalFile(), s, true);
            } else {
                Lib_TextFile.set(this.getInternalFile(), pos - 1L, s, true);
            }
        }
        catch (Exception err) {
            throw new ExternalError(cr, "File-Access-Error", "File: \"" + this.getInternalFile().getAbsolutePath() + '\"');
        }
        return this;
    }

    private JMo_File mWriteBytes(CallRuntime cr) {
        I_Object[] oa = cr.argsFlex(this, 1, 2);
        I_Object so = cr.argType(oa[0], JMo_ByteArray.class);
        Long pos = null;
        RandomAccessFile raf = null;
        if (oa.length == 2) {
            I_Object po = cr.argType(oa[1], A_IntNumber.class);
            pos = Lib_Convert.getLongValue(cr, po);
            Lib_Error.ifTooSmall(cr, 1L, pos);
        }
        try {
            try {
                byte[] ba = ((JMo_ByteArray)so).getValue();
                raf = new RandomAccessFile(this.getInternalFile(), "rw");
                if (pos == null) {
                    raf.setLength(0L);
                } else {
                    raf.seek(pos - 1L);
                }
                raf.write(ba);
            }
            catch (Exception err) {
                throw new ExternalError(cr, "File-Access-Error", "File: \"" + this.getInternalFile().getAbsolutePath() + '\"');
            }
        }
        finally {
            try {
                if (raf != null) {
                    raf.close();
                }
            }
            catch (Exception e) {
                Err.show(e);
            }
        }
        return this;
    }
}

