/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.object.atom;

import de.mn77.base.error.Err;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import org.jaymo_lang.model.ObjectCallResult;
import org.jaymo_lang.object.atom.A_Atomic;
import org.jaymo_lang.object.atom.A_IntNumber;
import org.jaymo_lang.object.atom.A_Number;
import org.jaymo_lang.object.atom.Dec;
import org.jaymo_lang.object.atom.I_Atomic;
import org.jaymo_lang.object.atom.I_Integer;
import org.jaymo_lang.object.atom.Int;
import org.jaymo_lang.object.atom.JMo_BigDec;
import org.jaymo_lang.object.atom.JMo_BigInt;
import org.jaymo_lang.object.atom.JMo_Long;
import org.jaymo_lang.object.atom.NOP0;
import org.jaymo_lang.object.atom.NOP1;
import org.jaymo_lang.object.struct.JMo_ByteArray;
import org.jaymo_lang.runtime.CallRuntime;
import org.jaymo_lang.runtime.STYPE;
import org.jaymo_lang.util.ATOMIC;
import org.jaymo_lang.util.Lib_AtomicCalc;
import org.jaymo_lang.util.Lib_Convert;

public class JMo_Short
extends A_IntNumber
implements I_Integer,
I_Atomic {
    private final short value;

    public JMo_Short(short val) {
        this.value = val;
    }

    @Override
    public ATOMIC getEnum() {
        return ATOMIC.SHORT;
    }

    @Override
    protected ObjectCallResult call5(CallRuntime cr, String method) {
        return null;
    }

    @Override
    public Short getValue() {
        return this.value;
    }

    @Override
    public int getIntValue(CallRuntime cr) {
        return this.value;
    }

    @Override
    public String toString(CallRuntime cr, STYPE type) {
        switch (type) {
            case REGULAR: 
            case NESTED: {
                return "" + this.value;
            }
        }
        return String.valueOf(this.value) + "s";
    }

    @Override
    protected A_Number numberCalc0(CallRuntime cr, NOP0 op) {
        switch (op) {
            case NEG: {
                return new Int(~this.value);
            }
            case ABS: {
                return new Int(Math.abs(this.value));
            }
            case EXP: {
                return new Dec(Math.exp(this.value));
            }
            case INC: {
                return new JMo_Short((short)(this.value + 1));
            }
            case DEC: {
                return new JMo_Short((short)(this.value - 1));
            }
            case POW: {
                return new Int(this.value * this.value);
            }
            case ROOT: {
                return new Dec(Math.sqrt(this.value));
            }
            case LOG10: {
                return new Dec(Math.log10(this.value));
            }
            case LOGN: {
                return new Dec(Math.log(this.value));
            }
        }
        throw Err.invalid(new Object[]{cr, op});
    }

    @Override
    protected A_Number numberCalcSame(CallRuntime cr, A_Number num, boolean inc) {
        int arg = Lib_Convert.getIntValue(cr, num);
        return new JMo_Short((short)(inc ? this.value + arg : this.value - arg));
    }

    @Override
    protected A_Number numberCalc1(CallRuntime cr, NOP1 op, A_Number paro) {
        if (paro instanceof I_Integer) {
            if (paro instanceof JMo_BigInt) {
                return Lib_AtomicCalc.numberCalcBigInt(cr, op, BigInteger.valueOf(this.value), ((JMo_BigInt)paro).getValue());
            }
            if (paro instanceof JMo_Long) {
                return Lib_AtomicCalc.numberCalcLong(cr, op, this.value, ((JMo_Long)paro).getValue());
            }
            return Lib_AtomicCalc.numberCalcInt(cr, op, this.value, Lib_Convert.getIntValue(cr, paro));
        }
        if (paro instanceof JMo_BigDec) {
            return Lib_AtomicCalc.numberCalcBigDec(cr, op, BigDecimal.valueOf(this.value), ((JMo_BigDec)paro).getValue());
        }
        return Lib_AtomicCalc.numberCalcDec(cr, op, this.value, Lib_Convert.getDoubleValue(cr, paro));
    }

    @Override
    protected JMo_ByteArray toByteArray(CallRuntime cr) {
        byte[] bytes = ByteBuffer.allocate(2).putShort(this.value).array();
        return new JMo_ByteArray(bytes);
    }

    @Override
    protected A_Atomic getMinValue(CallRuntime cr) {
        return new JMo_Short(Short.MIN_VALUE);
    }

    @Override
    protected A_Atomic getMaxValue(CallRuntime cr) {
        return new JMo_Short(Short.MAX_VALUE);
    }
}

