/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.model;

import de.mn77.base.data.Lib_Array;
import de.mn77.base.data.group.Group2;
import de.mn77.base.error.Err;
import java.util.ArrayList;
import org.jaymo_lang.error.CodeError;
import org.jaymo_lang.error.DebugInfo;
import org.jaymo_lang.model.App;
import org.jaymo_lang.model.MODIFIER;
import org.jaymo_lang.object.I_Object;
import org.jaymo_lang.parser.Parser_Script;
import org.jaymo_lang.runtime.CallRuntime;
import org.jaymo_lang.runtime.STYPE;
import org.jaymo_lang.util.BLOCKED;
import org.jaymo_lang.util.Lib_Output;

public abstract class A_VarConstManager<T extends I_Object> {
    private final A_VarConstManager<T> parent;
    private final ArrayList<MODIFIER> varsModifier = new ArrayList();
    private final ArrayList<String> varsRaw = new ArrayList();
    private final ArrayList<T> varsObject = new ArrayList();

    public A_VarConstManager(A_VarConstManager<T> parent) {
        this.parent = parent;
    }

    public T define(String name, DebugInfo debug) {
        Group2<String, MODIFIER> g = this.iSplitName(name, debug);
        char c0 = name.charAt(0);
        if (c0 >= 'a' && c0 <= 'z' && Lib_Array.knows(BLOCKED.VAR_CONST_LOWER, (String)g.o1)) {
            throw new CodeError("Invalid variable!", "This name can't be used: " + (String)g.o1, debug);
        }
        if (c0 >= 'A' && c0 <= 'Z' && Lib_Array.knows(BLOCKED.VAR_CONST_UPPER, (String)g.o1)) {
            throw new CodeError("Invalid constant!", "This name can't be used: " + (String)g.o1, debug);
        }
        if (g.o2 == MODIFIER.OPEN && c0 >= 'A' && c0 <= 'Z') {
            throw new CodeError("Invalid constant!", "Modifiers ?? and \u00bf are not allowed: " + name, debug);
        }
        this.varsRaw.add((String)g.o1);
        this.varsModifier.add((MODIFIER)((Object)g.o2));
        T vo = this.pCreateNew(name);
        this.varsObject.add(vo);
        return vo;
    }

    public T use_ParseTime(Parser_Script parser, String name, boolean onlyDefine) {
        T vo = this.iUse(parser.app, name, false, parser.getDebugInfo());
        if (vo != null) {
            if (onlyDefine) {
                throw new CodeError("Variable/Const already defined", "Name: " + name, parser);
            }
            return vo;
        }
        return this.define(name, parser.getDebugInfo());
    }

    public T use_RunTime(CallRuntime cr, String name) {
        return this.iUse(cr.getApp(), name, true, cr.getDebugInfo());
    }

    public boolean knowsRaw(String rawname) {
        return this.varsRaw.contains(rawname) || this.parent != null && this.parent.knowsRaw(rawname);
    }

    public boolean parentKnowsRaw(String rawname) {
        return this.parent != null && this.parent.knowsRaw(rawname);
    }

    public int getCount() {
        return this.varsRaw.size();
    }

    public String toString(CallRuntime cr, STYPE type) {
        if (type != STYPE.DESCRIBE) {
            return this.toString();
        }
        StringBuilder sb = new StringBuilder();
        for (I_Object t : this.varsObject) {
            String s = t.toString(cr, STYPE.DESCRIBE);
            sb.append(String.valueOf(s) + '\n');
        }
        if (this.parent != null) {
            String s = this.parent.toString(cr, STYPE.DESCRIBE);
            sb.append(s);
        }
        Lib_Output.removeEnd(sb, '\n');
        return sb.toString();
    }

    protected abstract T pCreateNew(String var1);

    protected T iUse(App app, String name, boolean isRuntime, DebugInfo debug) {
        if (this.parent == this) {
            Err.invalid(name);
        }
        Group2<String, MODIFIER> g = this.iSplitName(name, debug);
        int idx = this.varsRaw.indexOf(g.o1);
        if (idx >= 0) {
            MODIFIER modifOriginal;
            if (!isRuntime && (modifOriginal = this.varsModifier.get(idx)) != g.o2) {
                if (g.o2 != MODIFIER.SAFE) {
                    char c0 = ((String)g.o1).charAt(0);
                    String vc = c0 >= 'A' && c0 <= 'Z' ? "Const" : "Var";
                    throw new CodeError("Invalid modifier for Var/Const", String.valueOf(vc) + " '" + (String)g.o1 + "' is '" + modifOriginal.title + "' but the query is: '" + ((MODIFIER)((Object)g.o2)).title + "'", debug);
                }
                if (g.o2 == MODIFIER.SAFE) {
                    String full = String.valueOf((String)g.o1) + (modifOriginal == MODIFIER.NILABLE ? "?" : "??");
                    app.strict.checkVarConstShortcut(debug, name, full);
                }
            }
            return (T)((I_Object)this.varsObject.get(idx));
        }
        if (this.parent != null && this.parent.knowsRaw((String)g.o1)) {
            return this.parent.iUse(app, name, false, debug);
        }
        if (isRuntime) {
            throw Err.forbidden("Access to unknown variable: " + name);
        }
        return null;
    }

    private Group2<String, MODIFIER> iSplitName(String name, DebugInfo debug) {
        char c_l2;
        int len = name.length();
        boolean unsafe = false;
        boolean nilable = false;
        if (len == 0) {
            throw new CodeError("Invalid variable/constant", "Missing name of variable/constant", debug);
        }
        char c_l1 = name.charAt(len - 1);
        if (c_l1 == '?') {
            --len;
            nilable = true;
        }
        if (c_l1 == '\u00bf') {
            --len;
            unsafe = true;
        }
        if (!unsafe && len > 0 && (c_l2 = name.charAt(len - 1)) == '?') {
            --len;
            unsafe = true;
        }
        String rawname = name.substring(0, len);
        MODIFIER modifier = unsafe ? MODIFIER.OPEN : (nilable ? MODIFIER.NILABLE : MODIFIER.SAFE);
        return new Group2<String, MODIFIER>(rawname, modifier);
    }
}

