/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.lib.properties;

import de.mn77.base.error.Err_FileSys;
import de.mn77.lib.config.PropertiesFile;
import java.io.File;
import org.jaymo_lang.error.ExternalError;
import org.jaymo_lang.error.RuntimeError;
import org.jaymo_lang.model.ArgCallBuffer;
import org.jaymo_lang.model.Call;
import org.jaymo_lang.object.A_ObjectSimple;
import org.jaymo_lang.object.I_Object;
import org.jaymo_lang.object.atom.Bool;
import org.jaymo_lang.object.atom.Int;
import org.jaymo_lang.object.atom.Str;
import org.jaymo_lang.object.filesys.JMo_File;
import org.jaymo_lang.runtime.CallRuntime;
import org.jaymo_lang.util.Lib_Convert;

public class JMo_PropertiesFile
extends A_ObjectSimple {
    private PropertiesFile properties;
    private final ArgCallBuffer argTitle;
    private final ArgCallBuffer argFile;

    public JMo_PropertiesFile(Call title, Call file) {
        this.argTitle = new ArgCallBuffer(0, title);
        this.argFile = new ArgCallBuffer(1, file);
    }

    @Override
    public void init(CallRuntime cr) {
        Str title = this.argTitle.init(cr, this, Str.class);
        I_Object file = this.argFile.initExt(cr, this, Str.class, JMo_File.class);
        String titleString = Lib_Convert.getStringValue(cr, title);
        File f = null;
        if (file instanceof Str) {
            String fileString = Lib_Convert.getStringValue(cr, file);
            f = new File(fileString);
        } else {
            f = ((JMo_File)file).getInternalFile();
        }
        this.properties = new PropertiesFile(titleString, f);
    }

    @Override
    protected I_Object call3(CallRuntime cr, String method) {
        switch (method) {
            case "read": {
                return this.mRead(cr);
            }
            case "write": {
                return this.mWrite(cr);
            }
            case "close": {
                return this.mClose(cr);
            }
            case "removeKey": {
                return this.mRemoveKey(cr);
            }
            case "getBool": {
                return this.mGetBool(cr);
            }
            case "getInt": {
                return this.mGetInt(cr);
            }
            case "getStr": {
                return this.mGetStr(cr);
            }
            case "setBool": {
                return this.mSetBool(cr);
            }
            case "setInt": {
                return this.mSetInt(cr);
            }
            case "setStr": {
                return this.mSetStr(cr);
            }
        }
        return null;
    }

    private I_Object mRead(CallRuntime cr) {
        cr.argsNone();
        try {
            this.properties.read();
        }
        catch (Err_FileSys e) {
            throw new ExternalError(cr, "Properties file read error", e.getMessage());
        }
        return this;
    }

    private I_Object mWrite(CallRuntime cr) {
        cr.argsNone();
        try {
            this.properties.write();
        }
        catch (Err_FileSys e) {
            throw new ExternalError(cr, "Properties file write error", e.getMessage());
        }
        return this;
    }

    private I_Object mClose(CallRuntime cr) {
        cr.argsNone();
        try {
            this.properties.close();
        }
        catch (Err_FileSys e) {
            throw new ExternalError(cr, "Properties file write error", e.getMessage());
        }
        return this;
    }

    private I_Object mRemoveKey(CallRuntime cr) {
        Str key = (Str)cr.args(this, Str.class)[0];
        String keyString = Lib_Convert.getStringValue(cr, key);
        this.properties.removeKey(keyString);
        return this;
    }

    private Bool mGetBool(CallRuntime cr) {
        I_Object[] args = cr.argsFlex(this, 1, 2);
        String key = Lib_Convert.getStringValue(cr, args[0]);
        if (args.length == 1) {
            Boolean value = this.properties.getBoolean(key);
            if (value == null) {
                throw new RuntimeError(cr, "Invalid key", "Key not known: " + key);
            }
            return Bool.getObject(value);
        }
        boolean defaultValue = Lib_Convert.getBoolValue(cr, args[1]);
        return Bool.getObject(this.properties.getBooleanOrDefault(key, defaultValue));
    }

    private Int mGetInt(CallRuntime cr) {
        I_Object[] args = cr.argsFlex(this, 1, 2);
        String key = Lib_Convert.getStringValue(cr, args[0]);
        if (args.length == 1) {
            Integer value = this.properties.getInteger(key);
            if (value == null) {
                throw new RuntimeError(cr, "Invalid key", "Key not known: " + key);
            }
            return new Int(value);
        }
        int defaultValue = Lib_Convert.getIntValue(cr, args[1]);
        return new Int(this.properties.getIntegerOrDefault(key, defaultValue));
    }

    private Str mGetStr(CallRuntime cr) {
        I_Object[] args = cr.argsFlex(this, 1, 2);
        String key = Lib_Convert.getStringValue(cr, args[0]);
        if (args.length == 1) {
            String value = this.properties.getString(key);
            if (value == null) {
                throw new RuntimeError(cr, "Invalid key", "Key not known: " + key);
            }
            return new Str(value);
        }
        String defaultValue = Lib_Convert.getStringValue(cr, args[1]);
        return new Str(this.properties.getStringOrDefault(key, defaultValue));
    }

    private I_Object mSetBool(CallRuntime cr) {
        I_Object[] args = cr.args(this, Str.class, Bool.class);
        String key = Lib_Convert.getStringValue(cr, args[0]);
        boolean value = Lib_Convert.getBoolValue(cr, args[1]);
        this.properties.setBoolean(key, value);
        return this;
    }

    private I_Object mSetInt(CallRuntime cr) {
        I_Object[] args = cr.args(this, Str.class, Int.class);
        String key = Lib_Convert.getStringValue(cr, args[0]);
        int value = Lib_Convert.getIntValue(cr, args[1]);
        this.properties.setInteger(key, value);
        return this;
    }

    private I_Object mSetStr(CallRuntime cr) {
        I_Object[] args = cr.args(this, Str.class, Str.class);
        String key = Lib_Convert.getStringValue(cr, args[0]);
        String value = Lib_Convert.getStringValue(cr, args[1]);
        this.properties.setString(key, value);
        return this;
    }
}

