/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.lib.ntp;

import de.mn77.base.error.Err_Network;
import de.mn77.lib.ntp.NTP_Client;
import org.jaymo_lang.error.ExternalError;
import org.jaymo_lang.model.Call;
import org.jaymo_lang.model.VarArgsCallBuffer;
import org.jaymo_lang.object.A_ObjectSimple;
import org.jaymo_lang.object.I_Object;
import org.jaymo_lang.object.atom.JMo_Long;
import org.jaymo_lang.object.immute.datetime.JMo_Date;
import org.jaymo_lang.object.immute.datetime.JMo_DateTime;
import org.jaymo_lang.object.immute.datetime.JMo_Time;
import org.jaymo_lang.runtime.CallRuntime;
import org.jaymo_lang.util.Lib_Convert;
import org.jaymo_lang.util.Lib_Error;

public class JMo_NtpClient
extends A_ObjectSimple {
    private final VarArgsCallBuffer args;
    private NTP_Client client;

    public JMo_NtpClient(Call ... servers) {
        this.args = new VarArgsCallBuffer(servers);
    }

    @Override
    public void init(CallRuntime cr) {
        I_Object[] oa = this.args.init(cr, this);
        Lib_Error.ifTooSmall(cr, 3L, oa.length);
        String[] sa = new String[oa.length];
        int i = 0;
        while (i < sa.length) {
            sa[i] = Lib_Convert.getStringValue(cr, oa[i]);
            ++i;
        }
        this.client = new NTP_Client(sa);
    }

    @Override
    protected I_Object call3(CallRuntime cr, String method) {
        switch (method) {
            case "update": {
                cr.argsNone();
                try {
                    this.client.update();
                }
                catch (Err_Network e) {
                    throw new ExternalError(cr, "NTP-Error", e.getMessage());
                }
                return this;
            }
            case "time": {
                cr.argsNone();
                return new JMo_Time(this.client.getTime());
            }
            case "date": {
                cr.argsNone();
                return new JMo_Date(this.client.getDate());
            }
            case "dateTime": {
                cr.argsNone();
                return new JMo_DateTime(this.client.getDateTime());
            }
            case "diff": {
                cr.argsNone();
                return new JMo_Long(this.client.getDifferenceMSek());
            }
        }
        return null;
    }
}

