/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.lib.json;

import de.mn77.lib.json.Lib_JsonDeserialize;
import de.mn77.lib.json.Lib_JsonSerialize;
import java.text.ParseException;
import org.jaymo_lang.error.RuntimeError;
import org.jaymo_lang.lib.json.JMo_JsonObject;
import org.jaymo_lang.object.A_ObjectSimple;
import org.jaymo_lang.object.I_Object;
import org.jaymo_lang.object.atom.Str;
import org.jaymo_lang.runtime.CallRuntime;
import org.jaymo_lang.util.Lib_Convert;
import org.jaymo_lang.util.Lib_Java;

public class JMo_Json
extends A_ObjectSimple {
    @Override
    protected I_Object call3(CallRuntime cr, String method) {
        switch (method) {
            case "decode": 
            case "parse": 
            case "deserialize": {
                return this.mParse(cr);
            }
            case "object": {
                return this.mCreate(cr);
            }
            case "encode": 
            case "serialize": {
                return this.mSerialize(cr);
            }
        }
        return null;
    }

    private I_Object mCreate(CallRuntime cr) {
        cr.argsNone();
        return new JMo_JsonObject();
    }

    private Str mSerialize(CallRuntime cr) {
        I_Object arg = cr.args(this, I_Object.class)[0];
        try {
            Object obj = Lib_Java.jmoToJava(cr, arg, null);
            return new Str(Lib_JsonSerialize.encode(obj));
        }
        catch (RuntimeError e) {
            throw new RuntimeError(cr, "Conversion failed", "Object from type <" + arg.getTypeName() + "> could not be converted to JSON.");
        }
    }

    private I_Object mParse(CallRuntime cr) {
        I_Object arg = cr.args(this, Str.class)[0];
        String s = Lib_Convert.getStringValue(cr, arg);
        try {
            Object obj = Lib_JsonDeserialize.parse(s);
            return Lib_Java.javaToJmo(obj);
        }
        catch (ParseException e) {
            throw new RuntimeError(cr, "JSON parse error", e.getMessage());
        }
    }
}

