/*
 * Decompiled with CFR 0.152.
 */
package de.mn77.miniconf.result;

import de.mn77.miniconf.result.Lib_Result;
import de.mn77.miniconf.result.MIniConfObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class MIniConfResult {
    private final HashMap<String, String> entrys = new HashMap();

    public void addEntry(String path, String value) {
        this.entrys.put(path, value);
    }

    public Set<String> getKeys() {
        return this.entrys.keySet();
    }

    public Set<Map.Entry<String, String>> getItems() {
        return this.entrys.entrySet();
    }

    public String getString(String path) {
        return this.getString(path, null);
    }

    public String getString(String path, String ifAbsent) {
        String key = Lib_Result.normalizePath(path);
        if (!this.entrys.containsKey(key)) {
            return ifAbsent;
        }
        String value = this.entrys.get(key);
        return Lib_Result.parseString(value);
    }

    public Boolean getBoolean(String path) {
        return this.getBoolean(path, null);
    }

    public Boolean getBoolean(String path, Boolean ifAbsent) {
        String value = this.getString(path, null);
        if (value == null) {
            return ifAbsent;
        }
        if ((value = value.toLowerCase()).length() == 0 || value.equals("0") || value.equals("false") || value.equals("no")) {
            return false;
        }
        if (value.startsWith("0.") && value.matches("0\\.[0]*")) {
            return false;
        }
        return true;
    }

    public Double getDouble(String path) {
        return this.getDouble(path, null);
    }

    public Double getDouble(String path, Double ifAbsent) {
        String value = this.getString(path, null);
        if (value == null) {
            return ifAbsent;
        }
        try {
            return Double.parseDouble(value);
        }
        catch (NumberFormatException t) {
            return ifAbsent;
        }
    }

    public Integer getInteger(String path) {
        return this.getInteger(path, null);
    }

    public Integer getInteger(String path, Integer ifAbsent) {
        String value = this.getString(path, null);
        if (value == null) {
            return ifAbsent;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException t) {
            return ifAbsent;
        }
    }

    public MIniConfObject getObject(String path) {
        return this.getObject(path, null);
    }

    public MIniConfObject getObject(String path, MIniConfObject ifAbsent) {
        String value = this.getString(path, null);
        if (value == null) {
            return ifAbsent;
        }
        int gap = value.indexOf(40);
        String type = Lib_Result.checkType(gap > -1 ? value.substring(0, gap) : value);
        String[] args = gap > -1 ? Lib_Result.parseList(value.substring(gap), '(', ')') : new String[]{};
        return type == null || args == null ? ifAbsent : new MIniConfObject(type, args);
    }

    public String[] getList(String path) {
        return this.getList(path, null);
    }

    public String[] getList(String path, String[] ifAbsent) {
        String value = this.getString(path, null);
        if (value == null) {
            return ifAbsent;
        }
        return Lib_Result.parseList(value, '[', ']');
    }
}

