/*
 * Decompiled with CFR 0.152.
 */
package de.mn77.miniconf.parser;

import de.mn77.base.data.convert.ConvString;
import de.mn77.base.error.Err;
import de.mn77.miniconf.parser.Lib_MIniConf;
import de.mn77.miniconf.result.MIniConfResult;
import java.util.ArrayList;

public class ScriptParser {
    public static MIniConfResult parse(String s) {
        MIniConfResult result = new MIniConfResult();
        ArrayList<String> lines = ConvString.toList('\n', s);
        ArrayList<String> path = new ArrayList<String>();
        boolean blockComment = false;
        for (String line2 : lines) {
            String line = line2.trim();
            if (line.length() == 0) continue;
            char c0 = line.charAt(0);
            if (line.equals("*/")) {
                blockComment = false;
                continue;
            }
            if (blockComment || c0 == '#' || c0 == ';') continue;
            if (c0 == '/' && line.startsWith("/*")) {
                blockComment = true;
                continue;
            }
            if (c0 == '[') {
                ScriptParser.iPathBracket(path, line);
                continue;
            }
            if (c0 == '*') {
                ScriptParser.iPathStar(path, line);
                continue;
            }
            if (c0 == '.') {
                ScriptParser.iPathDot(path, line);
                continue;
            }
            ScriptParser.iEntry(result, path, line);
        }
        return result;
    }

    private static void iPathBracket(ArrayList<String> path, String line) {
        ScriptParser.iPathBracket(path, 0, line.trim());
    }

    private static void iPathDot(ArrayList<String> path, String line) {
        int dots = Lib_MIniConf.depth(line, '.');
        ScriptParser.iPathBracket(path, dots, line.substring(dots).trim());
    }

    private static void iPathBracket(ArrayList<String> path, int depth1, String line) {
        int end = line.indexOf(93);
        line = end <= -1 ? line.substring(1) : line.substring(1, end);
        int depth2 = Lib_MIniConf.depth(line, '.');
        ScriptParser.iSetPath(path, 1 + depth1 + depth2, line.substring(depth2).trim());
    }

    private static void iPathStar(ArrayList<String> path, String line) {
        int stars = Lib_MIniConf.depth(line, '*');
        ScriptParser.iSetPath(path, stars, line.substring(stars).trim());
    }

    private static void iEntry(MIniConfResult result, ArrayList<String> path, String line) {
        int equalIndex = line.indexOf(61);
        if (equalIndex == -1) {
            equalIndex = line.indexOf(58);
        }
        if (equalIndex == -1) {
            Err.todo(line);
        }
        String key = line.substring(0, equalIndex).trim();
        String v = line.substring(equalIndex + 1).trim();
        String value = v.length() == 0 ? null : v;
        result.addEntry(ScriptParser.iKey(path, key), value);
    }

    private static String iKey(ArrayList<String> path, String key) {
        Lib_MIniConf.checkKey(key);
        StringBuilder sb = new StringBuilder();
        for (String p : path) {
            if (sb.length() > 0) {
                sb.append(".");
            }
            sb.append(p);
        }
        if (sb.length() > 0) {
            sb.append(".");
        }
        sb.append(key);
        return sb.toString().toLowerCase();
    }

    private static void iSetPath(ArrayList<String> path, int depth, String headline) {
        while (path.size() < depth) {
            path.add("_");
        }
        while (path.size() > depth) {
            path.remove(path.size() - 1);
        }
        path.set(depth - 1, headline);
    }
}

