/*
 * Decompiled with CFR 0.152.
 */
package de.mn77.lib.xml.parser;

import de.mn77.base.data.convert.ConvArray;
import de.mn77.base.data.convert.ConvSequence;
import de.mn77.base.data.struct.I_Sequence;
import de.mn77.base.data.struct.keymap.KeyList;
import de.mn77.base.data.struct.list.MList;
import de.mn77.base.error.Err;
import de.mn77.base.event.A_StringEventHandler;
import de.mn77.base.sys.MOut;
import de.mn77.lib.xml.parser.XML_EVENT;
import de.mn77.lib.xml.parser.XML_Element;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.function.Consumer;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class XML_Parser
extends A_StringEventHandler {
    public void parse(String datei) throws XMLStreamException, FileNotFoundException {
        this.parse(new FileInputStream(datei));
    }

    public void parse(File file) throws XMLStreamException, FileNotFoundException {
        this.parse(new FileInputStream(file));
    }

    public void eventAdd(XML_EVENT type, String[] element, Consumer<XML_Element> z) {
        String epfad = this.iString(type, element);
        MOut.temp(epfad);
        this.eventAdd(epfad, z);
    }

    public void parse(InputStream is) throws XMLStreamException {
        XMLInputFactory factory2 = XMLInputFactory.newInstance();
        XMLStreamReader parser = factory2.createXMLStreamReader(is);
        MList<String> curPath = new MList<String>();
        KeyList<String, XML_Element> openElements = new KeyList<String, XML_Element>();
        while (parser.hasNext()) {
            String removed;
            String curPathString;
            XML_Element element;
            int event = parser.next();
            if (event == 1) {
                String elementName = parser.getLocalName();
                curPath.add(elementName);
                String curPathString2 = this.iString(null, curPath);
                element = new XML_Element(curPath.toArray(String.class));
                openElements.add(curPathString2, element);
                MOut.temp(curPath);
                if (parser.getAttributeCount() > 0) {
                    int i = 0;
                    while (i < parser.getAttributeCount()) {
                        element.sAttribut(parser.getAttributeLocalName(i), parser.getAttributeValue(i));
                        ++i;
                    }
                    MOut.temp(curPath);
                    this.eventStart(this.iString(XML_EVENT.START, curPath), element);
                }
            }
            if (event == 4 && !parser.isWhiteSpace()) {
                curPathString = this.iString(null, curPath);
                element = openElements.get(curPathString, null);
                if (element == null) continue;
                element.plusText(parser.getText());
                this.eventStart(this.iString(XML_EVENT.TEXT, curPath), element);
            }
            if (event != 2) continue;
            curPathString = this.iString(null, curPath);
            element = openElements.get(curPathString, null);
            if (element != null) {
                openElements.remove(curPathString);
                this.eventStart(this.iString(XML_EVENT.END, curPath), element);
            }
            if ((removed = (String)curPath.removeLast()).toLowerCase().equals(parser.getLocalName().toLowerCase())) continue;
            Err.forbidden("XML-Format-Fehler", openElements, removed, parser.getLocalName());
        }
    }

    private String iString(XML_EVENT type, String[] sa) {
        String prefix = type == null ? "" : String.valueOf(type.name()) + ':';
        return String.valueOf(prefix) + "/" + ConvArray.toString("/", (Object[])sa);
    }

    private String iString(XML_EVENT type, I_Sequence<String> sa) {
        String prefix = type == null ? "" : String.valueOf(type.name()) + ':';
        return String.valueOf(prefix) + "/" + ConvSequence.toText("/", sa);
    }
}

