/*
 * Decompiled with CFR 0.152.
 */
package de.mn77.lib.terminal;

import de.mn77.base.data.struct.HistoryList;
import de.mn77.base.error.Err;
import de.mn77.base.stream.Lib_Stream;
import de.mn77.base.sys.Sys;
import de.mn77.lib.terminal.CSI;
import de.mn77.lib.terminal.CSI_COLOR_BG;
import de.mn77.lib.terminal.CSI_COLOR_FG;
import java.io.BufferedReader;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;

public final class MTerminal {
    private final HistoryList<String> history = new HistoryList();
    private MODE currentMode = MODE.COOKED;
    private Reader input;
    private final InputStream inputStream = new FileInputStream(FileDescriptor.in);
    private PrintWriter output;
    private boolean debug = false;

    public MTerminal() throws UnsupportedEncodingException {
        if (Sys.isLinux() || Sys.isMac()) {
            this.callStty(MODE.RAW);
        }
        this.input = new InputStreamReader(this.inputStream, "UTF-8");
        this.output = new PrintWriter(new OutputStreamWriter((OutputStream)System.out, "UTF-8"));
        this.output.flush();
    }

    public PrintWriter getOutput() {
        return this.output;
    }

    public boolean isInRawMode() {
        return this.currentMode == MODE.RAW;
    }

    public boolean temporaryCooked() {
        if (this.isInRawMode()) {
            this.callStty(MODE.COOKED);
            return true;
        }
        return false;
    }

    public void temporaryReset(boolean set) {
        if (set) {
            this.callStty(MODE.RAW);
        }
    }

    private void callStty(MODE mode) {
        String[] cmdRaw = new String[]{"/bin/sh", "-c", "stty -ignbrk -brkint -parmrk -istrip -inlcr -igncr -icrnl -ixon -opost -echo -echonl -icanon -isig -iexten -parenb cs8 min 1 < /dev/tty"};
        String[] cmdCooked = new String[]{"/bin/sh", "-c", "stty sane cooked -istrip < /dev/tty"};
        try {
            Process process = mode == MODE.RAW ? Runtime.getRuntime().exec(cmdRaw) : Runtime.getRuntime().exec(cmdCooked);
            BufferedReader in = new BufferedReader(new InputStreamReader(process.getInputStream(), "UTF-8"));
            String line = in.readLine();
            if (line != null && line.length() > 0) {
                System.err.println("WEIRD?! Normal output from stty: " + line);
            }
            while (true) {
                try {
                    process.waitFor();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    continue;
                }
                break;
            }
            if (process.exitValue() == 0) {
                this.currentMode = mode;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void closeTerminal() {
        if (this.currentMode == MODE.RAW) {
            this.callStty(MODE.COOKED);
        } else {
            try {
                if (this.input != null) {
                    this.input.close();
                    this.input = null;
                }
                if (this.output != null) {
                    this.output.close();
                    this.output = null;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public String readLine() throws IOException {
        String input = this.isInRawMode() ? this.readLineRaw() : this.readLineCooked();
        this.history.add(input == null || input.length() == 0 ? null : input);
        return input;
    }

    private String readLineCooked() throws IOException {
        StringBuilder inputBuffer = new StringBuilder();
        int c;
        while ((c = this.input.read()) != -1) {
            char cc = (char)c;
            if (c == 13 || c == 10) {
                return inputBuffer.toString();
            }
            if (c == 3 || c == 4) {
                return null;
            }
            if ((c < 32 || c > 126) && c < 128 && c != 9) continue;
            inputBuffer.append(cc);
        }
        return null;
    }

    private String readLineRaw() throws IOException {
        int index = 0;
        StringBuilder buffer = new StringBuilder();
        while (true) {
            block51: {
                String right;
                char cc;
                int c;
                block52: {
                    String se;
                    block50: {
                        if ((c = this.input.read()) == -1) {
                            return null;
                        }
                        cc = (char)c;
                        if (c != 127) break block50;
                        if (buffer.length() > 0 && index > 0) {
                            if (index == buffer.length()) {
                                buffer.deleteCharAt(buffer.length() - 1);
                                this.output.print(CSI.cursorLeft(new int[0]));
                                this.output.print(CSI.eraseLineToEnd(new int[0]));
                                --index;
                            } else {
                                right = buffer.substring(index);
                                buffer.deleteCharAt(index - 1);
                                this.output.print(CSI.cursorLeft(new int[0]));
                                this.output.print(CSI.eraseLineToEnd(new int[0]));
                                this.output.print(right);
                                this.output.print(CSI.cursorLeft(right.length()));
                                --index;
                            }
                        }
                        break block51;
                    }
                    if (c != 27) break block52;
                    char[] cbuf = new char[16];
                    int count = this.input.read(cbuf);
                    if (count == -1) break block51;
                    char[] ca = new char[count];
                    System.arraycopy(cbuf, 0, ca, 0, count);
                    switch (se = new String(ca)) {
                        case "[D": {
                            if (index > 0) {
                                --index;
                                this.output.print(CSI.cursorLeft(new int[0]));
                                break;
                            }
                            break block51;
                        }
                        case "[C": {
                            if (index < buffer.length()) {
                                ++index;
                                this.output.print(CSI.cursorRight(new int[0]));
                                break;
                            }
                            break block51;
                        }
                        case "[A": {
                            String h = this.history.getBack();
                            if (h != null) {
                                if (buffer.length() > 0) {
                                    this.output.print(CSI.cursorLeft(buffer.length()));
                                    this.output.print(CSI.eraseLineToEnd(new int[0]));
                                }
                                if ((buffer = new StringBuilder(h)).length() > 0) {
                                    this.output.print(buffer);
                                }
                                index = buffer.length();
                                break;
                            }
                            break block51;
                        }
                        case "[B": {
                            String h2 = this.history.getForward();
                            if (buffer.length() > 0) {
                                this.output.print(CSI.cursorLeft(buffer.length()));
                                this.output.print(CSI.eraseLineToEnd(new int[0]));
                            }
                            if (h2 == null) {
                                h2 = "";
                            }
                            if ((buffer = new StringBuilder(h2)).length() > 0) {
                                this.output.print(buffer);
                            }
                            index = buffer.length();
                            break;
                        }
                        case "[3~": {
                            if (buffer.length() > 0 && index < buffer.length()) {
                                String right2 = buffer.substring(index + 1);
                                buffer.deleteCharAt(index);
                                this.output.print(CSI.eraseLineToEnd(new int[0]));
                                if (index < buffer.length()) {
                                    this.output.print(right2);
                                    this.output.print(CSI.cursorLeft(right2.length()));
                                    break;
                                }
                            }
                            break block51;
                        }
                        case "[H": {
                            if (index > 0) {
                                this.output.print(CSI.cursorLeft(index));
                                index = 0;
                                break;
                            }
                            break block51;
                        }
                        case "[F": {
                            if (index < buffer.length()) {
                                int diff = buffer.length() - index;
                                this.output.print(CSI.cursorRight(diff));
                                index = buffer.length();
                                break;
                            }
                            break block51;
                        }
                        default: {
                            if (this.debug) {
                                this.output.print(se);
                                break;
                            }
                            break block51;
                        }
                    }
                    break block51;
                }
                if (c == 13 || c == 10) {
                    return buffer.toString();
                }
                if (c == 3 || c == 4) {
                    return null;
                }
                if (c >= 32 && c <= 126 || c >= 128 || c == 9) {
                    this.output.print("" + cc);
                    if (index == buffer.length()) {
                        buffer.append(cc);
                    } else {
                        right = buffer.substring(index);
                        buffer.insert(index, cc);
                        this.output.print(right);
                        this.output.print(CSI.cursorLeft(right.length()));
                    }
                    ++index;
                } else if (this.debug) {
                    this.output.print(String.valueOf(c) + "(" + cc + ")");
                }
            }
            this.output.flush();
        }
    }

    private int getWidthRaw() {
        try {
            Process p = Runtime.getRuntime().exec(new String[]{"bash", "-c", "tput cols 2> /dev/tty"});
            String s = Lib_Stream.readUTF8(p.getInputStream()).trim();
            return Integer.parseInt(s);
        }
        catch (Exception e) {
            Err.show(e);
            return 80;
        }
    }

    public void print(Object ... oa) {
        Object[] objectArray = oa;
        int n = oa.length;
        int n2 = 0;
        while (n2 < n) {
            Enum c;
            Object o = objectArray[n2];
            if (o instanceof String) {
                this.output.print((String)o);
            } else if (o instanceof CSI_COLOR_FG) {
                c = (CSI_COLOR_FG)((Object)o);
                if (this.isInRawMode()) {
                    this.output.print(((CSI_COLOR_FG)c).color);
                }
            } else if (o instanceof CSI_COLOR_BG) {
                c = (CSI_COLOR_BG)((Object)o);
                if (this.isInRawMode()) {
                    this.output.print(((CSI_COLOR_BG)c).color);
                }
            } else {
                this.output.print(o.toString());
            }
            ++n2;
        }
        this.output.flush();
    }

    public void setDebug() {
        this.debug = true;
    }

    private static enum MODE {
        COOKED,
        RAW;

    }
}

