/*
 * Decompiled with CFR 0.152.
 */
package de.mn77.lib.ntp;

import de.mn77.base.data.struct.table.I_Table;
import de.mn77.base.data.struct.table.MTable;
import de.mn77.base.data.type.datetime.I_Date;
import de.mn77.base.data.type.datetime.I_DateTime;
import de.mn77.base.data.type.datetime.I_Time;
import de.mn77.base.data.type.datetime.MDate;
import de.mn77.base.data.type.datetime.MDateTime;
import de.mn77.base.data.type.datetime.MTime;
import de.mn77.base.error.Err;
import de.mn77.base.error.Err_Network;
import de.mn77.lib.ntp.I_NTP_Client_Base;
import de.mn77.lib.ntp.SNTP_Client;

public class NTP_Client
implements I_NTP_Client_Base {
    public static final boolean DEBUG = false;
    private final String[] servers;
    private long diff = 0L;

    public NTP_Client(String[] servers) {
        Err.ifNull(new Object[]{servers});
        Err.ifToSmall(3.0, servers.length);
        this.servers = servers;
    }

    @Override
    public long getDifferenceMSek() {
        return this.diff;
    }

    @Override
    public I_Time getTime() {
        return new MTime(System.currentTimeMillis() + this.diff);
    }

    @Override
    public I_Date getDate() {
        return new MDate(System.currentTimeMillis() + this.diff);
    }

    @Override
    public I_DateTime getDateTime() {
        return new MDateTime(System.currentTimeMillis() + this.diff);
    }

    @Override
    public void update() throws Err_Network {
        MTable<Object> tab = new MTable<Object>(4);
        String[] stringArray = this.servers;
        int n = this.servers.length;
        int n2 = 0;
        while (n2 < n) {
            String server = stringArray[n2];
            SNTP_Client c = new SNTP_Client(server);
            c.update();
            tab.add(c, c.getMessage().getRanking, c.getTransitTimeMSec(), Math.abs(c.getDifferenceMSek()));
            ++n2;
        }
        long[] value = new long[tab.size()];
        this.evaluate(tab, value, 2);
        this.evaluate(tab, value, 3);
        this.evaluate(tab, value, 4);
        int min = 1000;
        int fav = 1;
        int i = 0;
        while (i < value.length) {
            if (value[i] < (long)min) {
                fav = i + 1;
                min = (int)value[i];
            }
            ++i;
        }
        this.diff = ((SNTP_Client)tab.getCol(1).get(fav)).getDifferenceMSek();
    }

    private void evaluate(I_Table<?> tab, long[] values, int column) {
        long min = -1L;
        long max = -1L;
        long diff = 0L;
        int i = 1;
        while (i <= tab.size()) {
            if (max == -1L || (Long)tab.getCol(column).get(i) > max) {
                max = (Long)tab.getCol(column).get(i);
            }
            ++i;
        }
        diff = max - -1L;
        if (diff == 0L) {
            diff = 1L;
        }
        i = 1;
        while (i <= tab.size()) {
            int n = i - 1;
            values[n] = values[n] + ((Long)tab.getCol(column).get(i) - -1L) * 100L / diff;
            ++i;
        }
    }
}

