/*
 * Decompiled with CFR 0.152.
 */
package de.mn77.base.sys;

import de.mn77.base.data.Lib_Array;
import de.mn77.base.error.Err_Runtime;
import java.util.ArrayList;
import java.util.HashMap;

public class ArgumentParser {
    private final boolean allowSwitches;
    private final boolean allowPropertys;
    private final boolean allowOthers;
    private boolean parsed = false;
    private String[] switches = null;
    private String[] others = null;
    private HashMap<String, String> propertys = null;

    public ArgumentParser(boolean allowSwitches, boolean allowPropertys, boolean allowOthers) {
        this.allowSwitches = allowSwitches;
        this.allowPropertys = allowPropertys;
        this.allowOthers = allowOthers;
    }

    public void parse(String[] args) {
        if (this.parsed) {
            throw new Err_Runtime("Parsing already done!", new Object[0]);
        }
        ArrayList<String> switches = new ArrayList<String>();
        this.propertys = new HashMap();
        int i = 0;
        while (i < args.length) {
            String arg = args[i];
            if (arg.startsWith("--")) {
                this.iParse(switches, arg, 2, false);
            } else if (arg.startsWith("-")) {
                this.iParse(switches, arg, 1, true);
            } else {
                this.others = Lib_Array.cutFrom(args, i);
                break;
            }
            ++i;
        }
        this.switches = switches.toArray(new String[switches.size()]);
        if (this.others == null) {
            this.others = new String[0];
        }
        if (!this.allowSwitches && this.switches.length > 0) {
            throw new Err_Runtime("No switches allowed", new Object[0]);
        }
        if (!this.allowPropertys && this.propertys.size() > 0) {
            throw new Err_Runtime("No propertys allowed", new Object[0]);
        }
        if (!this.allowOthers && this.others.length > 0) {
            throw new Err_Runtime("Other arguments are not allowed", new Object[0]);
        }
        this.parsed = true;
    }

    public HashMap<String, String> getPropertys() {
        this.iCheckParsed();
        return this.propertys;
    }

    public String[] getSwitches() {
        this.iCheckParsed();
        return this.switches;
    }

    public String[] getOthers() {
        this.iCheckParsed();
        return this.others;
    }

    private void iCheckParsed() {
        if (!this.parsed) {
            throw new Err_Runtime("Nothing parsed!", new Object[0]);
        }
    }

    private void iParse(ArrayList<String> switches, String arg, int indent, boolean split) {
        String key = arg.substring(indent);
        String value = null;
        int eIdx = key.indexOf(61);
        if (eIdx >= 0) {
            value = key.substring(eIdx + 1);
            key = key.substring(0, eIdx);
        }
        this.iCheckKey(key);
        if (value != null) {
            this.propertys.put(key, value);
        } else if (split) {
            char[] cArray = key.toCharArray();
            int n = cArray.length;
            int n2 = 0;
            while (n2 < n) {
                char c = cArray[n2];
                switches.add("" + c);
                ++n2;
            }
        } else {
            switches.add(key);
        }
    }

    private void iCheckKey(String key) {
        char[] cArray = key.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (!(c >= '0' && c <= '9' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z')) {
                throw new Err_Runtime("Illegal argument key: " + key, new Object[0]);
            }
            ++n2;
        }
    }
}

