/*
 * Decompiled with CFR 0.152.
 */
package de.mn77.base.data.struct.sort.algo;

import de.mn77.base.data.constant.RELATION;
import de.mn77.base.data.struct.sort.I_Sortable;
import de.mn77.base.data.struct.sort.algo.A_SortAlgo;

public class MergeSort
extends A_SortAlgo {
    @Override
    protected void sortImpl(I_Sortable<?> tab, int ... columnOrder) {
        if (tab.size() > 0) {
            int len = tab.size();
            int[] dat = new int[len];
            int i = 1;
            while (i <= len) {
                dat[i - 1] = i;
                ++i;
            }
            this.part(tab, columnOrder, dat, 0, len - 1);
            tab.sortLike(dat);
        }
    }

    private void part(I_Sortable<?> s, int[] columnOrder, int[] dat, int left, int right) {
        if (left == right) {
            return;
        }
        int len = right - left + 1;
        if (len > 2) {
            int teil = len / 2;
            int l1 = left;
            int r1 = left + teil;
            int l2 = r1 + 1;
            int r2 = right;
            this.part(s, columnOrder, dat, l1, r1);
            this.part(s, columnOrder, dat, l2, r2);
            int p1 = l1;
            int p2 = l2;
            int pi = 0;
            int[] tmp = new int[len];
            while (p1 <= r1 || p2 <= r2) {
                RELATION c;
                int i2;
                int i1 = p1 > r1 ? -1 : dat[p1];
                int n = i2 = p2 > r2 ? -1 : dat[p2];
                RELATION rELATION = p1 > r1 ? RELATION.IS_GREATER : (c = p2 > r2 ? RELATION.IS_SMALLER : this.getRelation(s, i1, i2, columnOrder));
                if (c == RELATION.IS_GREATER) {
                    tmp[pi] = i2;
                    ++p2;
                } else {
                    tmp[pi] = i1;
                    ++p1;
                }
                ++pi;
            }
            int p = 0;
            while (p < len) {
                dat[left + p] = tmp[p];
                ++p;
            }
        } else {
            int il = dat[left];
            int ir = dat[right];
            if (this.getRelation(s, il, ir, columnOrder) == RELATION.IS_GREATER) {
                dat[left] = ir;
                dat[right] = il;
            }
        }
    }
}

