/*
 * Decompiled with CFR 0.152.
 */
package marytts.language.de.preprocess;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import marytts.language.de.preprocess.ExpansionPattern;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DurationEP
extends ExpansionPattern {
    private final String[] _knownTypes = new String[]{"duration", "duration:hms", "duration:hm", "duration:h"};
    private final List<String> knownTypes = Arrays.asList(this._knownTypes);
    protected final String sHour = "(?:0?[0-9]|1[0-9]|2[0-4])";
    protected final String sMinute = "(?:[0-5][0-9])";
    protected final String sSecond = "(?:[0-5][0-9])";
    protected final String sSep = "(?:\\:|\\.)";
    protected final String sFinal = "(?:h|Std\\.)";
    protected final String sMatchingChars = "[0-9:\\.hStd]";
    protected final Pattern reHour = Pattern.compile("((?:0?[0-9]|1[0-9]|2[0-4]))(?:h|Std\\.)");
    protected final Pattern reHourMinute = Pattern.compile("((?:0?[0-9]|1[0-9]|2[0-4]))(?:\\:|\\.)((?:[0-5][0-9]))(?:h|Std\\.)");
    protected final Pattern reHourMinuteSecond = Pattern.compile("((?:0?[0-9]|1[0-9]|2[0-4]))(?:\\:|\\.)((?:[0-5][0-9]))(?:\\:|\\.)((?:[0-5][0-9]))(?:h|Std\\.)");
    private final Pattern reMatchingChars = Pattern.compile("[0-9:\\.hStd]");

    @Override
    public List<String> knownTypes() {
        return this.knownTypes;
    }

    @Override
    public Pattern reMatchingChars() {
        return this.reMatchingChars;
    }

    @Override
    protected int canDealWith(String s, int type) {
        return this.match(s, type);
    }

    @Override
    protected int match(String s, int type) {
        switch (type) {
            case 0: {
                if (this.matchDurationHMS(s)) {
                    return 1;
                }
                if (this.matchDurationHM(s)) {
                    return 2;
                }
                if (!this.matchDurationH(s)) break;
                return 3;
            }
            case 1: {
                if (!this.matchDurationHMS(s)) break;
                return 1;
            }
            case 2: {
                if (!this.matchDurationHM(s)) break;
                return 2;
            }
            case 3: {
                if (!this.matchDurationH(s)) break;
                return 3;
            }
        }
        return -1;
    }

    @Override
    protected List<Element> expand(List<Element> tokens, String s, int type) {
        if (tokens == null) {
            throw new NullPointerException("Received null argument");
        }
        if (tokens.isEmpty()) {
            throw new IllegalArgumentException("Received empty list");
        }
        Document doc = tokens.get(0).getOwnerDocument();
        List<Element> expanded = null;
        switch (type) {
            case 1: {
                expanded = this.expandDurationHMS(doc, s);
                break;
            }
            case 2: {
                expanded = this.expandDurationHM(doc, s);
                break;
            }
            case 3: {
                expanded = this.expandDurationH(doc, s);
            }
        }
        this.replaceTokens(tokens, expanded);
        return expanded;
    }

    protected boolean matchDurationHMS(String s) {
        return this.reHourMinuteSecond.matcher(s).matches();
    }

    protected boolean matchDurationHM(String s) {
        return this.reHourMinute.matcher(s).matches();
    }

    protected boolean matchDurationH(String s) {
        return this.reHour.matcher(s).matches();
    }

    protected List<Element> expandDurationHMS(Document doc, String s) {
        ArrayList<Element> exp = new ArrayList<Element>();
        Matcher reMatcher = this.reHourMinuteSecond.matcher(s);
        if (!reMatcher.find()) {
            return null;
        }
        String hour = reMatcher.group(1);
        String minute = reMatcher.group(2);
        String second = reMatcher.group(3);
        if (hour.equals("01") || hour.equals("1")) {
            exp.addAll(this.makeNewTokens(doc, "eine Stunde"));
        } else {
            exp.addAll(number.expandInteger(doc, hour, false));
            exp.addAll(this.makeNewTokens(doc, "Stunden"));
        }
        if (!minute.equals("00")) {
            if (!second.equals("00")) {
                exp.addAll(this.makeNewTokens(doc, "und"));
            }
            if (minute.equals("01")) {
                exp.addAll(this.makeNewTokens(doc, "eine Minute"));
            } else {
                exp.addAll(number.expandInteger(doc, minute, false));
                exp.addAll(this.makeNewTokens(doc, "Minuten"));
            }
        }
        if (!second.equals("00")) {
            exp.addAll(this.makeNewTokens(doc, "und"));
            if (second.equals("01")) {
                exp.addAll(this.makeNewTokens(doc, "eine Sekunde"));
            } else {
                exp.addAll(number.expandInteger(doc, minute, false));
                exp.addAll(this.makeNewTokens(doc, "Sekunden"));
            }
        }
        return exp;
    }

    protected List<Element> expandDurationHM(Document doc, String s) {
        ArrayList<Element> exp = new ArrayList<Element>();
        Matcher reMatcher = this.reHourMinute.matcher(s);
        reMatcher.find();
        String hour = reMatcher.group(1);
        String minute = reMatcher.group(2);
        if (hour.equals("01") || hour.equals("1")) {
            exp.addAll(this.makeNewTokens(doc, "eine Stunde"));
        } else {
            exp.addAll(number.expandInteger(doc, hour, false));
            exp.addAll(this.makeNewTokens(doc, "Stunden"));
        }
        if (!minute.equals("00")) {
            exp.addAll(this.makeNewTokens(doc, "und"));
            if (minute.equals("01")) {
                exp.addAll(this.makeNewTokens(doc, "eine Minute"));
            } else {
                exp.addAll(number.expandInteger(doc, minute, false));
                exp.addAll(this.makeNewTokens(doc, "Minuten"));
            }
        }
        return exp;
    }

    protected List<Element> expandDurationH(Document doc, String s) {
        ArrayList<Element> exp = new ArrayList<Element>();
        Matcher reMatcher = this.reHour.matcher(s);
        reMatcher.find();
        String hour = reMatcher.group(1);
        if (hour.equals("01") || hour.equals("1")) {
            exp.addAll(this.makeNewTokens(doc, "eine Stunde"));
        } else {
            exp.addAll(number.expandInteger(doc, hour, false));
            exp.addAll(this.makeNewTokens(doc, "Stunden"));
        }
        return exp;
    }
}

